/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.web.flow;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.CoreGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.util.QRUtils;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OneTimeTokenAccountCreateRegistrationAction
extends AbstractMultifactorAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OneTimeTokenAccountCreateRegistrationAction.class);
    public static final String FLOW_SCOPE_ATTR_ACCOUNT = "key";
    public static final String FLOW_SCOPE_ATTR_QR_IMAGE_BASE64 = "QRcode";
    private final OneTimeTokenCredentialRepository repository;
    private final TenantExtractor tenantExtractor;
    private final CasConfigurationProperties casProperties;

    protected Event doExecuteInternal(RequestContext requestContext) throws Exception {
        Principal principal = this.resolvePrincipal(WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal(), requestContext);
        OneTimeTokenAccount keyAccount = this.repository.create(principal.getId());
        String keyUri = this.buildRegistrationUri(requestContext, keyAccount, principal);
        MutableAttributeMap flowScope = requestContext.getFlowScope();
        flowScope.put(FLOW_SCOPE_ATTR_ACCOUNT, (Object)keyAccount);
        String qrCodeBase64 = QRUtils.generateQRCode(keyUri, 250, 250);
        flowScope.put(FLOW_SCOPE_ATTR_QR_IMAGE_BASE64, (Object)qrCodeBase64);
        LOGGER.debug("Registration key URI is [{}]", (Object)keyUri);
        return this.eventFactory.event((Object)this, "register");
    }

    private String buildRegistrationUri(RequestContext requestContext, OneTimeTokenAccount keyAccount, Principal principal) {
        Optional tenantDefinitionResult = this.tenantExtractor.extract(requestContext);
        if (tenantDefinitionResult.isPresent()) {
            TenantDefinition tenantDefinition = (TenantDefinition)tenantDefinitionResult.get();
            keyAccount.setTenant(tenantDefinition.getId());
            ConfigurationPropertiesBindingContext bindingContext = tenantDefinition.bindProperties();
            if (bindingContext.isBound() && bindingContext.containsBindingFor(CoreGoogleAuthenticatorMultifactorProperties.class)) {
                CasConfigurationProperties properties = (CasConfigurationProperties)bindingContext.value();
                return OneTimeTokenAccountCreateRegistrationAction.buildRegistrationUri(principal, keyAccount, properties);
            }
        }
        return OneTimeTokenAccountCreateRegistrationAction.buildRegistrationUri(principal, keyAccount, this.casProperties);
    }

    private static String buildRegistrationUri(Principal principal, OneTimeTokenAccount keyAccount, CasConfigurationProperties casProperties) {
        CoreGoogleAuthenticatorMultifactorProperties gauth = casProperties.getAuthn().getMfa().getGauth().getCore();
        return "otpauth://totp/" + gauth.getLabel() + ":" + principal.getId() + "?secret=" + keyAccount.getSecretKey() + "&issuer=" + gauth.getIssuer();
    }

    @Generated
    public OneTimeTokenAccountCreateRegistrationAction(OneTimeTokenCredentialRepository repository, TenantExtractor tenantExtractor, CasConfigurationProperties casProperties) {
        this.repository = repository;
        this.tenantExtractor = tenantExtractor;
        this.casProperties = casProperties;
    }
}

