/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.repository.credentials;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorScratchCodeProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenAccountCipherExecutor;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.cipher.JasyptNumberCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;

public abstract class BaseOneTimeTokenCredentialRepository
implements OneTimeTokenCredentialRepository {
    private final CipherExecutor<String, String> tokenCredentialCipher;
    private final CipherExecutor<Number, Number> scratchCodesCipher;
    private final TenantExtractor tenantExtractor;

    protected OneTimeTokenAccount encode(OneTimeTokenAccount account) {
        account.setSecretKey(this.toTokenCredentialCipherExecutor(account).encode((Object)account.getSecretKey()).toString());
        CipherExecutor<Number, Number> scratchCodesCipherExecutor = this.toScratchCodesCipherExecutor(account);
        account.setScratchCodes(account.getScratchCodes().stream().map(code -> (Number)FunctionUtils.doAndHandle(() -> (Number)scratchCodesCipherExecutor.encode(code), t -> code).get()).collect(Collectors.toList()));
        account.setUsername(account.getUsername().trim().toLowerCase(Locale.ENGLISH));
        return account;
    }

    protected Collection<? extends OneTimeTokenAccount> decode(Collection<? extends OneTimeTokenAccount> account) {
        return account.stream().map(this::decode).collect(Collectors.toList());
    }

    protected OneTimeTokenAccount decode(OneTimeTokenAccount account) {
        String decodedSecret = this.toTokenCredentialCipherExecutor(account).decode((Object)account.getSecretKey()).toString();
        CipherExecutor<Number, Number> scratchCodesCipherExecutor = this.toScratchCodesCipherExecutor(account);
        List decodedScratchCodes = account.getScratchCodes().stream().map(code -> (Number)FunctionUtils.doAndHandle(() -> (Number)scratchCodesCipherExecutor.decode(code), t -> code).get()).collect(Collectors.toList());
        OneTimeTokenAccount newAccount = account.clone();
        newAccount.setSecretKey(decodedSecret);
        newAccount.setScratchCodes(decodedScratchCodes);
        return newAccount;
    }

    private CipherExecutor toTokenCredentialCipherExecutor(OneTimeTokenAccount account) {
        TenantDefinition tenantDefinition;
        ConfigurationPropertiesBindingContext bindingContext;
        if (StringUtils.isNotBlank((CharSequence)account.getTenant()) && (bindingContext = (tenantDefinition = (TenantDefinition)this.tenantExtractor.getTenantsManager().findTenant(account.getTenant()).orElseThrow()).bindProperties()).containsBindingFor(GoogleAuthenticatorMultifactorProperties.class)) {
            CasConfigurationProperties properties = (CasConfigurationProperties)bindingContext.value();
            EncryptionJwtSigningJwtCryptographyProperties crypto = properties.getAuthn().getMfa().getGauth().getCrypto();
            return crypto.isEnabled() ? CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, OneTimeTokenAccountCipherExecutor.class) : CipherExecutor.noOp();
        }
        return this.tokenCredentialCipher;
    }

    private CipherExecutor<Number, Number> toScratchCodesCipherExecutor(OneTimeTokenAccount account) {
        CasConfigurationProperties properties;
        String scratchCodesKey;
        TenantDefinition tenantDefinition;
        ConfigurationPropertiesBindingContext bindingContext;
        if (StringUtils.isNotBlank((CharSequence)account.getTenant()) && (bindingContext = (tenantDefinition = (TenantDefinition)this.tenantExtractor.getTenantsManager().findTenant(account.getTenant()).orElseThrow()).bindProperties()).isBound() && bindingContext.containsBindingFor(GoogleAuthenticatorMultifactorScratchCodeProperties.class) && StringUtils.isNotBlank((CharSequence)(scratchCodesKey = (properties = (CasConfigurationProperties)bindingContext.value()).getAuthn().getMfa().getGauth().getCore().getScratchCodes().getEncryption().getKey()))) {
            return new JasyptNumberCipherExecutor(scratchCodesKey, "googleAuthenticatorScratchCodesCipherExecutor");
        }
        return this.scratchCodesCipher;
    }

    @Generated
    protected BaseOneTimeTokenCredentialRepository(CipherExecutor<String, String> tokenCredentialCipher, CipherExecutor<Number, Number> scratchCodesCipher, TenantExtractor tenantExtractor) {
        this.tokenCredentialCipher = tokenCredentialCipher;
        this.scratchCodesCipher = scratchCodesCipher;
        this.tenantExtractor = tenantExtractor;
    }
}

