/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.monitor.ExecutableObserver;
import org.apereo.cas.monitor.MonitorableTask;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;

@Configuration(value="CasCoreAuthenticationMonitoringConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Monitoring, CasFeatureModule.FeatureCatalog.Authentication})
@EnableAspectJAutoProxy
@Lazy(value=false)
@ConditionalOnEnabledTracing
class CasCoreAuthenticationMonitoringConfiguration {
    CasCoreAuthenticationMonitoringConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"authenticationManagerMonitoringAspect"})
    public AuthenticationManagerMonitoringAspect authenticationManagerMonitoringAspect(ObjectProvider<ExecutableObserver> observer) {
        return new AuthenticationManagerMonitoringAspect(observer);
    }

    @Bean
    @ConditionalOnMissingBean(name={"authenticationHandlerMonitoringAspect"})
    public AuthenticationHandlerMonitoringAspect authenticationHandlerMonitoringAspect(ObjectProvider<ExecutableObserver> observer) {
        return new AuthenticationHandlerMonitoringAspect(observer);
    }

    @Aspect
    record AuthenticationManagerMonitoringAspect(ObjectProvider<ExecutableObserver> observerProvider) {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationManagerMonitoringAspect.class);

        @Around(value="allComponentsInAuthenticationManagementNamespace()")
        public Object aroundAuthenticationManagementOperations(ProceedingJoinPoint joinPoint) throws Throwable {
            return ExecutableObserver.observe(this.observerProvider, (ProceedingJoinPoint)joinPoint);
        }

        @Pointcut(value="within(org.apereo.cas.authentication.AuthenticationManager+) && execution(* authenticate(..))")
        private void allComponentsInAuthenticationManagementNamespace() {
        }
    }

    @Aspect
    record AuthenticationHandlerMonitoringAspect(ObjectProvider<ExecutableObserver> observerProvider) {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationHandlerMonitoringAspect.class);

        @Around(value="allComponentsInAuthenticationHandlerNamespace()")
        public Object aroundAuthenticationHandlerOperations(ProceedingJoinPoint joinPoint) throws Throwable {
            String taskName = AuthenticationHandlerMonitoringAspect.buildMonitorableTaskName(joinPoint);
            AuthenticationHandlerExecutionResult result = (AuthenticationHandlerExecutionResult)ExecutableObserver.observe(this.observerProvider, (ProceedingJoinPoint)joinPoint, task -> task.withName(taskName));
            MonitorableTask resultingTask = MonitorableTask.from((JoinPoint)joinPoint).withName(taskName).withBoundedValue("success", "true").withUnboundedValue("principal", result.getPrincipal().getId());
            ExecutableObserver.observe(this.observerProvider, (MonitorableTask)resultingTask);
            return result;
        }

        private static String buildMonitorableTaskName(ProceedingJoinPoint joinPoint) {
            Object taskName = MonitorableTask.toTaskName((JoinPoint)joinPoint);
            Object object = joinPoint.getTarget();
            if (object instanceof AuthenticationHandler) {
                AuthenticationHandler handler = (AuthenticationHandler)object;
                taskName = StringUtils.remove((String)handler.getName(), (char)' ') + "." + (String)taskName;
            }
            return ((String)taskName).trim();
        }

        @Pointcut(value="execution(* authenticate(..)) && target(org.apereo.cas.authentication.AuthenticationHandler) && within(*..*AuthenticationHandler)")
        private void allComponentsInAuthenticationHandlerNamespace() {
        }
    }
}

