/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import com.nimbusds.jwt.JWTClaimsSet;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.OAuth20TokenExchangeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthTokenExchangePolicy;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class AccessTokenTokenExchangeGrantRequestExtractor<T extends OAuth20ConfigurationContext>
extends BaseAccessTokenGrantRequestExtractor<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenTokenExchangeGrantRequestExtractor.class);

    public AccessTokenTokenExchangeGrantRequestExtractor(ObjectProvider<T> configurationContext) {
        super(configurationContext);
    }

    public boolean supports(WebContext context) {
        String grantType = ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getRequestParameterResolver().resolveRequestParameter(context, "grant_type").orElse("");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.TOKEN_EXCHANGE;
    }

    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.NONE;
    }

    @Override
    protected AccessTokenRequestContext extractRequest(WebContext webContext) throws Throwable {
        OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
        OAuth20RequestParameterResolver requestParameterResolver = configurationContext.getRequestParameterResolver();
        Set scopes = requestParameterResolver.resolveRequestScopes(webContext);
        String requestedTokenType = requestParameterResolver.resolveRequestParameter(webContext, "requested_token_type").orElseGet(() -> ((OAuth20TokenExchangeTypes)OAuth20TokenExchangeTypes.ACCESS_TOKEN).getType());
        OAuth20TokenExchangeTypes subjectTokenType = requestParameterResolver.resolveRequestParameter(webContext, "subject_token_type").map(OAuth20TokenExchangeTypes::from).orElseThrow(() -> new IllegalArgumentException("Subject token type cannot be undefined"));
        Optional resource = requestParameterResolver.resolveRequestParameter(webContext, "resource");
        String audience = requestParameterResolver.resolveRequestParameter(webContext, "audience").orElse(null);
        TokenExchangeRequest extractedRequest = this.extractSubjectTokenExchangeRequest(webContext);
        WebApplicationService resourceService = resource.map(res -> {
            WebApplicationService service = (WebApplicationService)configurationContext.getWebApplicationServiceServiceFactory().createService(res);
            service.getAttributes().put("client_id", List.of(extractedRequest.registeredService().getClientId()));
            return service;
        }).orElse(null);
        return AccessTokenRequestContext.builder().scopes(scopes).grantType(this.getGrantType()).subjectTokenType(subjectTokenType).requestedTokenType(OAuth20TokenExchangeTypes.from((String)requestedTokenType)).subjectToken(extractedRequest.token()).tokenExchangeResource((Service)resourceService).tokenExchangeAudience(audience).service(extractedRequest.service()).registeredService(extractedRequest.registeredService()).authentication(extractedRequest.authentication()).actorToken(this.getActorTokenAuthentication(webContext, extractedRequest)).build();
    }

    protected TokenExchangeRequest extractSubjectTokenExchangeRequest(WebContext webContext) throws Throwable {
        OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
        OAuth20RequestParameterResolver requestParameterResolver = configurationContext.getRequestParameterResolver();
        OAuth20TokenExchangeTypes subjectTokenType = requestParameterResolver.resolveRequestParameter(webContext, "subject_token_type").map(OAuth20TokenExchangeTypes::from).orElseThrow();
        String subjectToken = (String)requestParameterResolver.resolveRequestParameter(webContext, "subject_token").orElseThrow(() -> new IllegalArgumentException("Subject token cannot be undefined"));
        return switch (subjectTokenType) {
            case OAuth20TokenExchangeTypes.ACCESS_TOKEN -> {
                OAuth20AccessToken token = (OAuth20AccessToken)configurationContext.getTicketRegistry().getTicket(subjectToken, OAuth20AccessToken.class);
                OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(configurationContext.getServicesManager(), token.getClientId());
                yield new TokenExchangeRequest((Serializable)token, token.getService(), registeredService, token.getAuthentication());
            }
            case OAuth20TokenExchangeTypes.JWT -> {
                JWTClaimsSet claimSet = configurationContext.getAccessTokenJwtBuilder().unpack(Optional.empty(), subjectToken);
                WebApplicationService service = (WebApplicationService)configurationContext.getWebApplicationServiceServiceFactory().createService(claimSet.getIssuer());
                service.getAttributes().put("client_id", List.of(claimSet.getIssuer()));
                OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(configurationContext.getServicesManager(), claimSet.getIssuer());
                UserProfile userProfile = this.extractUserProfile(webContext).orElseThrow();
                Authentication authentication = configurationContext.getAuthenticationBuilder().build(userProfile, registeredService, webContext, (Service)service);
                yield new TokenExchangeRequest((Serializable)claimSet, (Service)service, registeredService, authentication);
            }
            default -> throw new IllegalArgumentException("Subject token type %s is not supported".formatted(subjectTokenType));
        };
    }

    protected Authentication getActorTokenAuthentication(WebContext webContext, TokenExchangeRequest extractedRequest) throws Throwable {
        OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
        Optional actorToken = configurationContext.getRequestParameterResolver().resolveRequestParameter(webContext, "actor_token");
        Optional<OAuth20TokenExchangeTypes> actorTokenType = configurationContext.getRequestParameterResolver().resolveRequestParameter(webContext, "actor_token_type").map(OAuth20TokenExchangeTypes::from);
        FunctionUtils.throwIf((actorToken.isPresent() && actorTokenType.isEmpty() ? 1 : 0) != 0, () -> new IllegalArgumentException("Actor token type cannot be undefined when actor token is provided"));
        if (actorToken.isPresent()) {
            RegisteredServiceOAuthTokenExchangePolicy tokenExchangePolicy;
            Authentication actorAuthentication = this.extractActorTokenAuthentication(webContext);
            RegisteredServiceOAuthTokenExchangePolicy registeredServiceOAuthTokenExchangePolicy = tokenExchangePolicy = extractedRequest.registeredService() != null ? extractedRequest.registeredService().getTokenExchangePolicy() : null;
            if (tokenExchangePolicy == null || tokenExchangePolicy.canSubjectTokenActAs(extractedRequest.authentication(), actorAuthentication, (String)actorTokenType.map(OAuth20TokenExchangeTypes::getType).orElse(null))) {
                return actorAuthentication;
            }
        }
        return null;
    }

    protected Authentication extractActorTokenAuthentication(WebContext webContext) throws Throwable {
        OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
        String actorToken = (String)configurationContext.getRequestParameterResolver().resolveRequestParameter(webContext, "actor_token").orElseThrow();
        OAuth20TokenExchangeTypes actorTokenType = configurationContext.getRequestParameterResolver().resolveRequestParameter(webContext, "actor_token_type").map(OAuth20TokenExchangeTypes::from).orElseThrow();
        return switch (actorTokenType) {
            case OAuth20TokenExchangeTypes.ACCESS_TOKEN -> {
                OAuth20Token token = (OAuth20Token)configurationContext.getTicketRegistry().getTicket(actorToken, OAuth20Token.class);
                yield token.getAuthentication();
            }
            case OAuth20TokenExchangeTypes.JWT -> this.buildActorTokenAuthenticationFromJwt(actorToken, webContext);
            default -> throw new IllegalArgumentException("Actor token type %s is not supported".formatted(actorTokenType));
        };
    }

    protected Authentication buildActorTokenAuthenticationFromJwt(String actorToken, WebContext webContext) throws Throwable {
        OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
        JWTClaimsSet claimSet = configurationContext.getAccessTokenJwtBuilder().unpack(Optional.empty(), actorToken);
        WebApplicationService service = (WebApplicationService)configurationContext.getWebApplicationServiceServiceFactory().createService(claimSet.getIssuer());
        service.getAttributes().put("client_id", List.of(claimSet.getIssuer()));
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(configurationContext.getServicesManager(), claimSet.getIssuer());
        UserProfile userProfile = this.extractUserProfile(webContext).orElseThrow();
        return configurationContext.getAuthenticationBuilder().build(userProfile, registeredService, webContext, (Service)service);
    }

    public record TokenExchangeRequest(Serializable token, Service service, OAuthRegisteredService registeredService, Authentication authentication) {
    }
}

