/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.DefaultAuthenticationResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.Ticket;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class AccessTokenPasswordGrantRequestExtractor
extends BaseAccessTokenGrantRequestExtractor<OAuth20ConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenPasswordGrantRequestExtractor.class);

    public AccessTokenPasswordGrantRequestExtractor(ObjectProvider<OAuth20ConfigurationContext> oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    @Override
    public AccessTokenRequestContext extractRequest(WebContext context) throws Throwable {
        OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
        CallContext callContext = new CallContext(context, configurationContext.getSessionStore());
        String clientId = (String)configurationContext.getRequestParameterResolver().resolveClientIdAndClientSecret(callContext).getKey();
        LOGGER.debug("Locating OAuth registered service by client id [{}]", (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(configurationContext.getServicesManager(), clientId);
        LOGGER.debug("Located OAuth registered service [{}]", (Object)registeredService);
        ProfileManager manager = new ProfileManager(context, configurationContext.getSessionStore());
        UserProfile profile = (UserProfile)manager.getProfile().orElseThrow(() -> UnauthorizedServiceException.denied((String)"OAuth user profile cannot be determined"));
        LOGGER.debug("Creating matching service request based on [{}]", (Object)registeredService);
        boolean requireServiceHeader = configurationContext.getCasProperties().getAuthn().getOauth().getGrants().getResourceOwner().isRequireServiceHeader();
        Service service = configurationContext.getAuthenticationBuilder().buildService(registeredService, context, requireServiceHeader);
        LOGGER.debug("Authenticating the OAuth request indicated by [{}]", (Object)service);
        Authentication authentication = configurationContext.getAuthenticationBuilder().build(profile, registeredService, context, service);
        AuditableContext audit = AuditableContext.builder().service(service).authentication(authentication).registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
        DefaultAuthenticationResult result = new DefaultAuthenticationResult(authentication, (Service)(requireServiceHeader ? service : null));
        Ticket ticketGrantingTicket = configurationContext.getCentralAuthenticationService().createTicketGrantingTicket((AuthenticationResult)result);
        Set scopes = configurationContext.getRequestParameterResolver().resolveRequestScopes(context);
        scopes.retainAll(Objects.requireNonNull(registeredService).getScopes());
        return AccessTokenRequestContext.builder().scopes(scopes).service(service).authentication(authentication).registeredService(registeredService).grantType(this.getGrantType()).ticketGrantingTicket(ticketGrantingTicket).generateRefreshToken(registeredService.isGenerateRefreshToken()).build();
    }

    public boolean supports(WebContext context) {
        String grantType = ((OAuth20ConfigurationContext)this.getConfigurationContext().getObject()).getRequestParameterResolver().resolveRequestParameter(context, "grant_type").orElse("");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    public OAuth20ResponseTypes getResponseType() {
        return null;
    }

    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.PASSWORD;
    }

    public boolean requestMustBeAuthenticated() {
        return true;
    }
}

