/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.context.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.lang.Nullable;
import org.springframework.ui.context.HierarchicalThemeSource;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.SimpleTheme;

public class ResourceBundleThemeSource
implements HierarchicalThemeSource,
BeanClassLoaderAware {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleThemeSource.class);
    @Nullable
    private ThemeSource parentThemeSource;
    private String basenamePrefix = "";
    @Nullable
    private String defaultEncoding;
    @Nullable
    private Boolean fallbackToSystemLocale;
    @Nullable
    private ClassLoader beanClassLoader;
    private final Map<String, Theme> themeCache = new ConcurrentHashMap<String, Theme>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParentThemeSource(@Nullable ThemeSource parent) {
        this.parentThemeSource = parent;
        Map<String, Theme> map = this.themeCache;
        synchronized (map) {
            for (Theme theme : this.themeCache.values()) {
                this.initParent(theme);
            }
        }
    }

    public void setBasenamePrefix(@Nullable String basenamePrefix) {
        this.basenamePrefix = basenamePrefix != null ? basenamePrefix : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Theme getTheme(String themeName) {
        Theme theme = this.themeCache.get(themeName);
        if (theme == null) {
            Map<String, Theme> map = this.themeCache;
            synchronized (map) {
                theme = this.themeCache.get(themeName);
                if (theme == null) {
                    String basename = this.basenamePrefix + themeName;
                    MessageSource messageSource = this.createMessageSource(basename);
                    theme = new SimpleTheme(themeName, messageSource);
                    this.initParent(theme);
                    this.themeCache.put(themeName, theme);
                    LOGGER.debug("Theme created: name [{}], basename [{}]", (Object)themeName, (Object)basename);
                }
            }
        }
        return theme;
    }

    protected MessageSource createMessageSource(String basename) {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename(basename);
        if (this.defaultEncoding != null) {
            messageSource.setDefaultEncoding(this.defaultEncoding);
        }
        if (this.fallbackToSystemLocale != null) {
            messageSource.setFallbackToSystemLocale(this.fallbackToSystemLocale.booleanValue());
        }
        if (this.beanClassLoader != null) {
            messageSource.setBeanClassLoader(this.beanClassLoader);
        }
        return messageSource;
    }

    protected void initParent(Theme theme) {
        MessageSource messageSource = theme.getMessageSource();
        if (messageSource instanceof HierarchicalMessageSource) {
            Theme parentTheme;
            HierarchicalMessageSource messageSource2 = (HierarchicalMessageSource)messageSource;
            if (this.getParentThemeSource() != null && messageSource2.getParentMessageSource() == null && (parentTheme = this.getParentThemeSource().getTheme(theme.getName())) != null) {
                messageSource2.setParentMessageSource(parentTheme.getMessageSource());
            }
        }
    }

    @Override
    @Nullable
    @Generated
    public ThemeSource getParentThemeSource() {
        return this.parentThemeSource;
    }

    @Generated
    public void setDefaultEncoding(@Nullable String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    @Generated
    public void setFallbackToSystemLocale(@Nullable Boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    @Generated
    public void setBeanClassLoader(@Nullable ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }
}

