/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.commons.ResourceDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.ConnObjects;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.status.ResourceStatusModal;
import org.apache.syncope.client.console.tasks.LiveSyncTask;
import org.apache.syncope.client.console.tasks.PropagationTasks;
import org.apache.syncope.client.console.tasks.PullTasks;
import org.apache.syncope.client.console.tasks.PushTasks;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceProvisionPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceWizardBuilder;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ResourceDirectoryPanel
extends DirectoryPanel<Serializable, Serializable, ResourceDataProvider, ResourceRestClient> {
    private static final long serialVersionUID = -5223129956783782225L;
    @SpringBean
    protected ConnectorRestClient connectorRestClient;
    @SpringBean
    protected AuditRestClient auditRestClient;
    protected String keyword;
    protected final BaseModal<Serializable> propTaskModal;
    protected final BaseModal<Serializable> schedTaskModal;
    protected final BaseModal<Serializable> provisionModal;
    protected final BaseModal<Serializable> historyModal;

    protected ResourceDirectoryPanel(String id, Builder builder) {
        super(id, (DirectoryPanel.Builder)builder);
        if (SyncopeConsoleSession.get().owns("RESOURCE_CREATE", new String[0])) {
            MetaDataRoleAuthorizationStrategy.authorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        } else {
            MetaDataRoleAuthorizationStrategy.unauthorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        }
        this.setShowResultPanel(false);
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
        this.restClient = builder.restClient;
        this.propTaskModal = new BaseModal("outer");
        this.propTaskModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.propTaskModal});
        this.schedTaskModal = new BaseModal<Serializable>("outer"){
            private static final long serialVersionUID = -6165152045136958913L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.schedTaskModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.schedTaskModal});
        this.provisionModal = new BaseModal("outer");
        this.provisionModal.size(Modal.Size.Large);
        this.provisionModal.addSubmitButton();
        this.addOuterObject(new Component[]{this.provisionModal});
        this.historyModal = new BaseModal("outer");
        this.historyModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.historyModal});
    }

    public void onEvent(IEvent<?> event) {
        Object object = event.getPayload();
        if (object instanceof ResourceSearchEvent) {
            ResourceSearchEvent payload = (ResourceSearchEvent)object;
            AjaxRequestTarget target = payload.getTarget();
            if (StringUtils.isNotEmpty((CharSequence)payload.getKeyword())) {
                this.keyword = payload.getKeyword().toLowerCase();
            }
            this.updateResultTable(target);
        } else {
            super.onEvent(event);
        }
    }

    protected ResourceDataProvider dataProvider() {
        this.dataProvider = new ResourceDataProvider((ResourceRestClient)this.restClient, this.rows, this.pageRef, this.keyword);
        return (ResourceDataProvider)this.dataProvider;
    }

    public ResourceDataProvider getDataProvider() {
        return (ResourceDataProvider)this.dataProvider;
    }

    protected String paginatorRowsKey() {
        return "parameters.paginator.rows";
    }

    protected List<IColumn<Serializable, String>> getColumns() {
        ArrayList<IColumn<Serializable, String>> columns = new ArrayList<IColumn<Serializable, String>>();
        columns.add((IColumn<Serializable, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"keySortParam", "key"));
        columns.add((IColumn<Serializable, String>)new PropertyColumn((IModel)new ResourceModel("connectorDisplayName"), (Object)"connectorDisplayNameSortParam", "connectorDisplayName"));
        return columns;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.singletonList(ActionLink.ActionType.DELETE);
    }

    public ActionsPanel<Serializable> getActions(final IModel<Serializable> model) {
        ActionsPanel panel = super.getActions(model);
        final String key = ((ResourceTO)model.getObject()).getKey();
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = -7220222653598674870L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO resource = ((ResourceRestClient)this.this$0.restClient).read(key);
                ConnInstanceTO connInstance = this.this$0.connectorRestClient.read(resource.getConnector());
                CompoundPropertyModel model = new CompoundPropertyModel((Object)resource);
                this.this$0.modal.setFormModel((Serializable)model);
                target.add(new Component[]{this.this$0.modal.setContent(new ResourceWizardBuilder(resource, (ResourceRestClient)this.this$0.restClient, this.this$0.connectorRestClient, this.this$0.pageRef).build("content", SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", new String[]{connInstance.getAdminRealm()}) ? AjaxWizard.Mode.EDIT : AjaxWizard.Mode.READONLY))});
                this.this$0.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("resource.edit"), ((ResourceTO)model.getObject()).getKey()))));
                this.this$0.modal.show(true);
            }
        }, ActionLink.ActionType.EDIT, String.format("%s,%s", "RESOURCE_READ", "RESOURCE_UPDATE"));
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = -6467344504797047254L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO resource = ((ResourceRestClient)this.this$0.restClient).read(key);
                ConnInstanceTO connInstance = this.this$0.connectorRestClient.read(resource.getConnector());
                if (SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", new String[]{connInstance.getAdminRealm()})) {
                    this.this$0.provisionModal.addSubmitButton();
                } else {
                    this.this$0.provisionModal.removeSubmitButton();
                }
                CompoundPropertyModel model = new CompoundPropertyModel((Object)resource);
                this.this$0.provisionModal.setFormModel((Serializable)model);
                target.add(new Component[]{this.this$0.provisionModal.setContent((ModalPanel)new ResourceProvisionPanel(this.this$0.provisionModal, resource, connInstance.getAdminRealm(), this.this$0.pageRef))});
                this.this$0.provisionModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("resource.edit"), ((ResourceTO)model.getObject()).getKey()))));
                this.this$0.provisionModal.show(true);
            }
        }, ActionLink.ActionType.MAPPING, String.format("%s,%s", "RESOURCE_READ", "RESOURCE_UPDATE"));
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = -1448897313753684142L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO resource = ((ResourceRestClient)this.this$0.restClient).read(key);
                target.add(new Component[]{this.this$0.propTaskModal.setContent((ModalPanel)new ConnObjects(resource, this.this$0.pageRef))});
                this.this$0.propTaskModal.header((IModel)new StringResourceModel("resource.explore.list", (IModel)Model.of((Serializable)((Serializable)model.getObject()))));
                this.this$0.propTaskModal.show(true);
            }
        }, ActionLink.ActionType.EXPLORE_RESOURCE, "RESOURCE_LIST_CONNOBJECT");
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = 4800323783814856195L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{this.this$0.propTaskModal.setContent((ModalPanel)new PropagationTasks(this.this$0.propTaskModal, key, this.this$0.pageRef))});
                this.this$0.propTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("task.propagation.list"), key))));
                this.this$0.propTaskModal.show(true);
            }
        }, ActionLink.ActionType.PROPAGATION_TASKS, "TASK_LIST");
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = -4699610013584898667L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{this.this$0.schedTaskModal.setContent((ModalPanel)new PullTasks(this.this$0.schedTaskModal, key, this.this$0.pageRef))});
                this.this$0.schedTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("task.pull.list"), key))));
                this.this$0.schedTaskModal.show(true);
            }
        }, ActionLink.ActionType.PULL_TASKS, "TASK_LIST");
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = -4699610013584898667L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{this.this$0.schedTaskModal.setContent((ModalPanel)new LiveSyncTask(this.this$0.schedTaskModal, key, this.this$0.pageRef))});
                this.this$0.schedTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("task.livesync"), key))));
                this.this$0.schedTaskModal.show(true);
            }
        }, ActionLink.ActionType.LIVE_SYNC_TASK, "TASK_READ");
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = 2042227976628604686L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{this.this$0.schedTaskModal.setContent((ModalPanel)new PushTasks(this.this$0.schedTaskModal, key, this.this$0.pageRef))});
                this.this$0.schedTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("task.push.list"), key))));
                this.this$0.schedTaskModal.show(true);
            }
        }, ActionLink.ActionType.PUSH_TASKS, "TASK_LIST");
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = -5962061673680621813L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO modelObject = ((ResourceRestClient)this.this$0.restClient).read(key);
                target.add(new Component[]{this.this$0.propTaskModal.setContent((ModalPanel)new ResourceStatusModal(this.this$0.pageRef, modelObject))});
                this.this$0.propTaskModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("resource.reconciliation"), key))));
                this.this$0.propTaskModal.show(true);
            }
        }, ActionLink.ActionType.RECONCILIATION_RESOURCE, "USER_UPDATE");
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = -5432034353017728766L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO modelObject = ((ResourceRestClient)this.this$0.restClient).read(key);
                target.add(new Component[]{this.this$0.historyModal.setContent((ModalPanel)new AuditHistoryModal<ResourceTO>(this, OpEvent.CategoryType.LOGIC, "ResourceLogic", modelObject, "RESOURCE_UPDATE", this.this$0.auditRestClient){
                    private static final long serialVersionUID = -3712506022627033811L;
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = this$1;
                        super(type, category, (EntityTO)entity, auditRestoreEntitlement, restClient);
                    }

                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            ResourceTO updated = (ResourceTO)DirectoryPanel.MAPPER.readValue(json, ResourceTO.class);
                            ((ResourceRestClient)this.this$1.this$0.restClient).update(updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        }
                        catch (Exception e) {
                            DirectoryPanel.LOG.error("While restoring resource {}", (Object)key, (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)this.this$1.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                this.this$0.historyModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("resource.menu.history"), key))));
                this.this$0.historyModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "RESOURCE_READ", "AUDIT_LIST"));
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = 7019899256702149874L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                try {
                    ResourceTO resource = ((ResourceRestClient)this.this$0.restClient).read(key);
                    resource.setKey("Copy of " + resource.getKey());
                    target.add(new Component[]{this.this$0.modal.setContent(new ResourceWizardBuilder(resource, (ResourceRestClient)this.this$0.restClient, this.this$0.connectorRestClient, this.this$0.pageRef).build("content", AjaxWizard.Mode.CREATE))});
                    this.this$0.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("resource.clone"), resource.getKey()))));
                    this.this$0.modal.show(true);
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While cloning resource {}", (Object)key, (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.CLONE, "RESOURCE_CREATE");
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = 4516186028545701573L;
            final /* synthetic */ ResourceDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                try {
                    ((ResourceRestClient)this.this$0.restClient).delete(key);
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting resource {}", (Object)key, (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "RESOURCE_DELETE", true);
        return panel;
    }

    public static class Builder
    extends DirectoryPanel.Builder<Serializable, Serializable, ResourceRestClient> {
        private static final long serialVersionUID = -1391308721262593468L;

        public Builder(ResourceRestClient restClient, PageReference pageRef) {
            super((RestClient)restClient, pageRef);
            this.setShowResultPage(false);
        }

        protected WizardMgtPanel<Serializable> newInstance(String id, boolean wizardInModal) {
            return new ResourceDirectoryPanel(id, this);
        }
    }

    public static class ResourceSearchEvent
    implements Serializable {
        private static final long serialVersionUID = 213974502541311941L;
        protected final AjaxRequestTarget target;
        protected final String keyword;

        public ResourceSearchEvent(AjaxRequestTarget target, String keyword) {
            this.target = target;
            this.keyword = keyword;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public String getKeyword() {
            return this.keyword;
        }
    }
}

