/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.impl.SwapMeter;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongSupplier;

final class SwapTimer
extends SwapMeter<Timer>
implements Timer {
    SwapTimer(Registry registry, LongSupplier versionSupplier, Id id, Timer underlying) {
        super(registry, versionSupplier, id, underlying);
    }

    @Override
    public Timer lookup() {
        return this.registry.timer(this.id);
    }

    @Override
    public Clock clock() {
        return this.registry.clock();
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        ((Timer)this.get()).record(amount, unit);
    }

    @Override
    public long count() {
        return ((Timer)this.get()).count();
    }

    @Override
    public long totalTime() {
        return ((Timer)this.get()).totalTime();
    }

    @Override
    public Timer.BatchUpdater batchUpdater(int batchSize) {
        Timer.BatchUpdater updater = ((Timer)this.get()).batchUpdater(batchSize);
        if (updater instanceof Consumer) {
            ((Consumer)((Object)updater)).accept(this::get);
        }
        return updater;
    }
}

