/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderItemsContainer;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.XmlTag;

public final class HtmlHeaderSectionHandler
extends AbstractMarkupFilter {
    public static final String BODY = "body";
    public static final String HEAD = "head";
    public static final String HEADER_ID = "_header_";
    public static final String HEADER_ID_ITEM = "_header_item_";
    private boolean foundHead = false;
    private boolean foundClosingHead = false;
    private boolean foundHeaderItemsTag = false;
    private boolean ignoreTheRest = false;
    private final Markup markup;
    private static final ComponentTag.IAutoComponentFactory HTML_HEADER_FACTORY = new ComponentTag.IAutoComponentFactory(){

        @Override
        public Component newComponent(MarkupContainer container, ComponentTag tag) {
            return new HtmlHeaderContainer(tag.getId());
        }
    };
    private static final ComponentTag.IAutoComponentFactory HTML_HEADER_ITEMS_FACTORY = new ComponentTag.IAutoComponentFactory(){

        @Override
        public Component newComponent(MarkupContainer container, ComponentTag tag) {
            return new HtmlHeaderItemsContainer(tag.getId());
        }
    };

    public HtmlHeaderSectionHandler(Markup markup) {
        super(markup.getMarkupResourceStream());
        this.markup = markup;
    }

    @Override
    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (this.ignoreTheRest) {
            return tag;
        }
        if (HEAD.equalsIgnoreCase(tag.getName())) {
            if (tag.getNamespace() == null) {
                this.handleHeadTag(tag);
            } else {
                this.foundHead = true;
                this.foundClosingHead = true;
            }
        } else if ("header-items".equalsIgnoreCase(tag.getName()) && tag.getNamespace().equalsIgnoreCase(this.getWicketNamespace())) {
            this.handleHeaderItemsTag(tag);
        } else if (BODY.equalsIgnoreCase(tag.getName()) && tag.getNamespace() == null) {
            this.handleBodyTag();
        }
        return tag;
    }

    private void handleBodyTag() {
        if (this.foundHead && !this.foundClosingHead) {
            throw new MarkupException(new MarkupStream(this.markup), "Invalid page markup. Tag <BODY> found inside <HEAD>");
        }
        if (!this.foundHead) {
            this.insertHeadTag();
        }
        this.ignoreTheRest = true;
    }

    private void handleHeaderItemsTag(ComponentTag tag) {
        if ((tag.isOpen() || tag.isOpenClose()) && this.foundHeaderItemsTag) {
            throw new MarkupException(new MarkupStream(this.markup), "More than one <wicket:header-items/> detected in the <head> element. Only one is allowed.");
        }
        if (this.foundClosingHead) {
            throw new MarkupException(new MarkupStream(this.markup), "Detected <wicket:header-items/> after the closing </head> element.");
        }
        this.foundHeaderItemsTag = true;
        tag.setId(HEADER_ID);
        tag.setAutoComponentTag(true);
        tag.setModified(true);
        tag.setAutoComponentFactory(HTML_HEADER_ITEMS_FACTORY);
    }

    private void handleHeadTag(ComponentTag tag) {
        if (tag.isOpen()) {
            if (this.foundHead) {
                throw new MarkupException(new MarkupStream(this.markup), "Tag <head> is not allowed at this position (do you have multiple <head> tags in your markup?).");
            }
            this.foundHead = true;
            if (tag.getId() == null) {
                tag.setId(HEADER_ID);
                tag.setAutoComponentTag(true);
                tag.setModified(true);
                tag.setAutoComponentFactory(HTML_HEADER_FACTORY);
            }
        } else if (tag.isClose()) {
            if (this.foundHeaderItemsTag) {
                ComponentTag headOpenTag = tag.getOpenTag();
                headOpenTag.setId("_header_-Ignored");
                headOpenTag.setAutoComponentTag(false);
                headOpenTag.setModified(false);
                headOpenTag.setFlag(32, true);
                headOpenTag.setAutoComponentFactory(null);
            }
            this.foundClosingHead = true;
        }
    }

    private void insertHeadTag() {
        ComponentTag openTag = new ComponentTag(HEAD, XmlTag.TagType.OPEN);
        openTag.setId(HEADER_ID);
        openTag.setAutoComponentTag(true);
        openTag.setModified(true);
        openTag.setAutoComponentFactory(HTML_HEADER_FACTORY);
        ComponentTag closeTag = new ComponentTag(HEAD, XmlTag.TagType.CLOSE);
        closeTag.setOpenTag(openTag);
        closeTag.setModified(true);
        this.markup.addMarkupElement(openTag);
        this.markup.addMarkupElement(closeTag);
    }
}

