/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import java.util.Objects;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.authentication.credential.OneTimeTokenCredential;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialValidator;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GoogleAuthenticatorConfirmAccountRegistrationAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorConfirmAccountRegistrationAction.class);
    public static final String ACCOUNT_PROPERTY_REGISTRATION_VERIFIED = "registrationVerified";
    private final OneTimeTokenCredentialRepository repository;
    private final OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> validator;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        ParameterMap requestParameters = requestContext.getRequestParameters();
        Long accountId = (Long)requestParameters.getRequired("accountId", Long.class);
        Boolean validate = requestParameters.getBoolean("validate");
        OneTimeTokenAccount account = this.repository.get(accountId.longValue());
        Objects.requireNonNull(account, "Account cannot be null");
        if (BooleanUtils.isTrue((Boolean)validate)) {
            String token = (String)requestParameters.getRequired("token", String.class);
            Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
            String principal = authentication.getPrincipal().getId();
            LOGGER.debug("Validating account [{}] with token [{}] for principal [{}]", new Object[]{accountId, token, principal});
            GoogleAuthenticatorTokenCredential tokenCredential = new GoogleAuthenticatorTokenCredential(token, accountId);
            GoogleAuthenticatorToken validatedToken = (GoogleAuthenticatorToken)this.validator.validate(authentication, (OneTimeTokenCredential)tokenCredential);
            if (validatedToken != null) {
                LOGGER.debug("Validated OTP token [{}] successfully for [{}]", (Object)validatedToken, (Object)principal);
                this.accountRegistrationVerified(requestContext, account);
                return this.success();
            }
            LOGGER.warn("Authorization of OTP token [{}] has failed", (Object)token);
            throw new FailedLoginException("Failed to authenticate code " + token);
        }
        if (!this.isAccountRegistrationVerified(requestContext, account)) {
            LOGGER.warn("Account registration is not verified for [{}]", (Object)account.getId());
            throw new FailedLoginException("Unauthorized account registration attempt for id " + account.getId());
        }
        this.accountRegistrationUnverified(requestContext, account);
        return this.success();
    }

    protected void accountRegistrationVerified(RequestContext requestContext, OneTimeTokenAccount account) {
        account.getProperties().add(ACCOUNT_PROPERTY_REGISTRATION_VERIFIED);
        this.repository.update(account);
    }

    protected void accountRegistrationUnverified(RequestContext requestContext, OneTimeTokenAccount account) {
        account.getProperties().remove(ACCOUNT_PROPERTY_REGISTRATION_VERIFIED);
        this.repository.update(account);
    }

    protected boolean isAccountRegistrationVerified(RequestContext requestContext, OneTimeTokenAccount account) {
        return account.getProperties().contains(ACCOUNT_PROPERTY_REGISTRATION_VERIFIED);
    }

    @Generated
    public GoogleAuthenticatorConfirmAccountRegistrationAction(OneTimeTokenCredentialRepository repository, OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> validator) {
        this.repository = repository;
        this.validator = validator;
    }
}

