/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry.pubsub;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import lombok.Generated;
import org.apereo.cas.ticket.registry.pubsub.commands.BaseMessageQueueCommand;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.crypto.DecodableCipher;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.cas.util.serialization.SerializationUtils;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;

public class MessageQueueMessageSerializationHandler
implements Serializer<Object>,
Deserializer<Object> {
    private final CipherExecutor cipher;

    public void serialize(@Nonnull Object object, OutputStream outputStream) throws IOException {
        byte[] result = this.serializeToByteArray(object);
        outputStream.write(result);
        outputStream.flush();
    }

    @Nonnull
    public byte[] serializeToByteArray(@Nonnull Object object) {
        return SerializationUtils.serializeAndEncodeObject((EncodableCipher)this.cipher, (Serializable)((Serializable)object));
    }

    @Nonnull
    public BaseMessageQueueCommand deserialize(InputStream inputStream) throws IOException {
        try (InputStream inputStream2 = inputStream;){
            BaseMessageQueueCommand baseMessageQueueCommand = this.deserializeFromByteArray(inputStream.readAllBytes());
            return baseMessageQueueCommand;
        }
    }

    @Nonnull
    public BaseMessageQueueCommand deserializeFromByteArray(@Nonnull byte[] serialized) {
        return (BaseMessageQueueCommand)SerializationUtils.decodeAndDeserializeObject((byte[])serialized, (DecodableCipher)this.cipher, BaseMessageQueueCommand.class);
    }

    @Generated
    public MessageQueueMessageSerializationHandler(CipherExecutor cipher) {
        this.cipher = cipher;
    }
}

