/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.web.AbstractController;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Tag(name="Delegated Authentication")
public class DefaultDelegatedAuthenticationNavigationController
extends AbstractController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedAuthenticationNavigationController.class);
    protected static final String ENDPOINT_RESPONSE = "login/{clientName}";
    private final DelegatedClientAuthenticationConfigurationContext configurationContext;

    @GetMapping(value={"login/{clientName}"})
    @Operation(summary="Redirect response to flow", parameters={@Parameter(name="clientName", in=ParameterIn.PATH, required=true, description="The client name")})
    public View redirectResponseToFlow(@PathVariable(value="clientName") String clientName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildRedirectViewBackToFlow(clientName, request);
    }

    @PostMapping(value={"login/{clientName}"})
    @Operation(summary="Redirect response to flow", parameters={@Parameter(name="clientName", in=ParameterIn.PATH, required=true, description="The client name")})
    public View postResponseToFlow(@PathVariable(value="clientName") String clientName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildRedirectViewBackToFlow(clientName, request);
    }

    protected View buildRedirectViewBackToFlow(String clientName, HttpServletRequest request) throws Exception {
        URIBuilder urlBuilder = new URIBuilder(this.configurationContext.getCasProperties().getServer().getLoginUrl());
        request.getParameterMap().forEach((name, v) -> {
            String value = request.getParameter(name);
            urlBuilder.addParameter(name, value);
        });
        urlBuilder.setParameter("client_name", clientName);
        String url = urlBuilder.toString();
        LOGGER.debug("Received response from client [{}]; Redirecting to [{}]", (Object)clientName, (Object)url);
        return new RedirectView(url);
    }

    @Generated
    public DefaultDelegatedAuthenticationNavigationController(DelegatedClientAuthenticationConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public DelegatedClientAuthenticationConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

