/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web.flow;

import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationCoreProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.webauthn.WebAuthnMultifactorAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WebAuthnStartRegistrationAction
extends AbstractMultifactorAuthenticationAction<WebAuthnMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnStartRegistrationAction.class);
    public static final String FLOW_SCOPE_WEB_AUTHN_APPLICATION_ID = "webauthnApplicationId";
    protected final CasConfigurationProperties casProperties;
    protected final TenantExtractor tenantExtractor;

    protected Event doExecuteInternal(RequestContext requestContext) {
        WebAuthnMultifactorAuthenticationCoreProperties webAuthn = this.casProperties.getAuthn().getMfa().getWebAuthn().getCore();
        Authentication authn = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authn.getPrincipal(), requestContext);
        Map attributes = principal.getAttributes();
        LOGGER.debug("Starting registration sequence for [{}]", (Object)principal);
        MutableAttributeMap flowScope = requestContext.getFlowScope();
        if (attributes.containsKey(webAuthn.getDisplayNameAttribute())) {
            CollectionUtils.firstElement(attributes.get(webAuthn.getDisplayNameAttribute())).ifPresent(value -> flowScope.put("displayName", value));
        } else {
            flowScope.put("displayName", (Object)principal.getId());
        }
        flowScope.put(FLOW_SCOPE_WEB_AUTHN_APPLICATION_ID, (Object)webAuthn.getApplicationId());
        return null;
    }

    @Generated
    public WebAuthnStartRegistrationAction(CasConfigurationProperties casProperties, TenantExtractor tenantExtractor) {
        this.casProperties = casProperties;
        this.tenantExtractor = tenantExtractor;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public TenantExtractor getTenantExtractor() {
        return this.tenantExtractor;
    }
}

