/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.services.ServiceRegistryProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.sms.SmsBodyBuilder;
import org.apereo.cas.notifications.sms.SmsRequest;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServicesEventListener;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.events.service.CasRegisteredServiceExpiredEvent;
import org.apereo.cas.support.events.service.CasRegisteredServicesRefreshEvent;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.StringUtils;

public class DefaultRegisteredServicesEventListener
implements RegisteredServicesEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServicesEventListener.class);
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;
    private final CommunicationsManager communicationsManager;
    private final TenantExtractor tenantExtractor;

    @Override
    public void handleRefreshEvent(CasRegisteredServicesRefreshEvent event) {
        this.servicesManager.load();
    }

    @Override
    public void handleEnvironmentChangeEvent(EnvironmentChangeEvent event) {
        this.servicesManager.load();
    }

    @Override
    public void handleContextRefreshedEvent(ContextRefreshedEvent event) {
        ServicesManager manager = (ServicesManager)event.getApplicationContext().getBean("servicesManager", ServicesManager.class);
        manager.load();
    }

    @Override
    public void handleRegisteredServiceExpiredEvent(CasRegisteredServiceExpiredEvent event) {
        RegisteredService registeredService = event.getRegisteredService();
        List contacts = registeredService.getContacts();
        ServiceRegistryProperties serviceRegistry = this.casProperties.getServiceRegistry();
        String serviceName = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)registeredService.getName(), (CharSequence)registeredService.getServiceId());
        if (contacts == null || contacts.isEmpty()) {
            LOGGER.debug("No contacts are defined to be notified for policy changes to service [{}]", (Object)serviceName);
            return;
        }
        String logMessage = String.format("Sending notification to [{}] as service [{}] is %s from registry", event.isDeleted() ? "deleted" : "expired");
        LOGGER.info(logMessage, (Object)contacts, (Object)serviceName);
        this.communicationsManager.validate();
        if (this.communicationsManager.isMailSenderDefined()) {
            EmailProperties mail = serviceRegistry.getMail();
            String body = EmailMessageBodyBuilder.builder().properties(mail).parameters(Map.of("service", serviceName)).build().get();
            contacts.stream().filter(contact -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contact.getEmail())).forEach(contact -> {
                EmailMessageRequest emailRequest = EmailMessageRequest.builder().emailProperties(mail).to(List.of(contact.getEmail())).tenant(event.getClientInfo().getTenant()).body(body).build();
                this.communicationsManager.email(emailRequest);
            });
        }
        if (this.communicationsManager.isSmsSenderDefined()) {
            SmsProperties sms = serviceRegistry.getSms();
            String message = SmsBodyBuilder.builder().properties(sms).parameters(Map.of("service", serviceName)).build().get();
            contacts.stream().filter(contact -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contact.getPhone())).forEach(Unchecked.consumer(contact -> {
                ArrayList recipients = new ArrayList(StringUtils.commaDelimitedListToSet((String)contact.getPhone()));
                SmsRequest smsRequest = SmsRequest.builder().from(sms.getFrom()).to(recipients).text(message).tenant(event.getClientInfo().getTenant()).build();
                this.communicationsManager.sms(smsRequest);
            }));
        }
    }

    @Generated
    public DefaultRegisteredServicesEventListener(ServicesManager servicesManager, CasConfigurationProperties casProperties, CommunicationsManager communicationsManager, TenantExtractor tenantExtractor) {
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
        this.tenantExtractor = tenantExtractor;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public CommunicationsManager getCommunicationsManager() {
        return this.communicationsManager;
    }

    @Generated
    public TenantExtractor getTenantExtractor() {
        return this.tenantExtractor;
    }
}

