/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.RegularExpressionCapable;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.DefaultRegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceExpirationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceProperty;
import org.apereo.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.apereo.cas.services.FullRegexRegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceContact;
import org.apereo.cas.services.RegisteredServiceDefinition;
import org.apereo.cas.services.RegisteredServiceExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceLogoutType;
import org.apereo.cas.services.RegisteredServiceMatchingStrategy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.RegisteredServicePublicKey;
import org.apereo.cas.services.RegisteredServiceTicketGrantingTicketExpirationPolicy;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.springframework.data.annotation.Id;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class BaseRegisteredService
implements RegisteredService {
    private static final Comparator<RegisteredService> INTERNAL_COMPARATOR = Comparator.comparingInt(RegisteredService::getEvaluationPriority).thenComparingInt(RegisteredService::getEvaluationOrder).thenComparing(service -> StringUtils.defaultString((String)service.getName()), String.CASE_INSENSITIVE_ORDER).thenComparing(RegisteredService::getServiceId).thenComparingLong(RegisteredServiceDefinition::getId);
    private static final long serialVersionUID = 7645279151115635245L;
    @RegularExpressionCapable
    protected String serviceId;
    private String name;
    private String theme;
    private String locale;
    private String informationUrl;
    private String privacyUrl;
    private String templateName;
    @Id
    private long id = -1L;
    private String description;
    private RegisteredServiceExpirationPolicy expirationPolicy = new DefaultRegisteredServiceExpirationPolicy();
    private RegisteredServiceTicketGrantingTicketExpirationPolicy ticketGrantingTicketExpirationPolicy;
    private int evaluationOrder;
    private RegisteredServiceUsernameAttributeProvider usernameAttributeProvider = new DefaultRegisteredServiceUsernameProvider();
    private RegisteredServiceLogoutType logoutType = RegisteredServiceLogoutType.BACK_CHANNEL;
    private Set<String> environments = new LinkedHashSet<String>();
    private RegisteredServiceAttributeReleasePolicy attributeReleasePolicy = new ReturnAllowedAttributeReleasePolicy();
    @JsonProperty(value="multifactorPolicy")
    private RegisteredServiceMultifactorPolicy multifactorAuthenticationPolicy = new DefaultRegisteredServiceMultifactorPolicy();
    private RegisteredServicePublicKey publicKey;
    private RegisteredServiceMatchingStrategy matchingStrategy = new FullRegexRegisteredServiceMatchingStrategy();
    private String logo;
    private String logoutUrl;
    private RegisteredServiceAccessStrategy accessStrategy = new DefaultRegisteredServiceAccessStrategy();
    private RegisteredServiceAuthenticationPolicy authenticationPolicy = new DefaultRegisteredServiceAuthenticationPolicy();
    private Map<String, RegisteredServiceProperty> properties = new HashMap<String, RegisteredServiceProperty>();
    private List<RegisteredServiceContact> contacts = new ArrayList<RegisteredServiceContact>();

    public int compareTo(RegisteredService other) {
        return INTERNAL_COMPARATOR.compare(this, other);
    }

    public boolean matches(Service service) {
        return service != null && this.matches(service.getId());
    }

    public boolean matches(String serviceId) {
        this.configureMatchingStrategy();
        return !StringUtils.isBlank((CharSequence)serviceId) && this.getMatchingStrategy().matches((RegisteredService)this, serviceId);
    }

    protected void configureMatchingStrategy() {
        if (this.getMatchingStrategy() == null) {
            this.setMatchingStrategy(new FullRegexRegisteredServiceMatchingStrategy());
        }
    }

    @JsonIgnore
    @CanIgnoreReturnValue
    public BaseRegisteredService markAsInternal() {
        this.getProperties().put(RegisteredServiceProperty.RegisteredServiceProperties.INTERNAL_SERVICE_DEFINITION.getPropertyName(), new DefaultRegisteredServiceProperty("true"));
        return this;
    }

    @Generated
    public String toString() {
        return "BaseRegisteredService(serviceId=" + this.serviceId + ", name=" + this.name + ", theme=" + this.theme + ", locale=" + this.locale + ", informationUrl=" + this.informationUrl + ", privacyUrl=" + this.privacyUrl + ", templateName=" + this.templateName + ", id=" + this.id + ", description=" + this.description + ", expirationPolicy=" + String.valueOf(this.expirationPolicy) + ", ticketGrantingTicketExpirationPolicy=" + String.valueOf(this.ticketGrantingTicketExpirationPolicy) + ", evaluationOrder=" + this.evaluationOrder + ", usernameAttributeProvider=" + String.valueOf(this.usernameAttributeProvider) + ", logoutType=" + String.valueOf(this.logoutType) + ", environments=" + String.valueOf(this.environments) + ", attributeReleasePolicy=" + String.valueOf(this.attributeReleasePolicy) + ", multifactorAuthenticationPolicy=" + String.valueOf(this.multifactorAuthenticationPolicy) + ", publicKey=" + String.valueOf(this.publicKey) + ", matchingStrategy=" + String.valueOf(this.matchingStrategy) + ", logo=" + this.logo + ", logoutUrl=" + this.logoutUrl + ", accessStrategy=" + String.valueOf(this.accessStrategy) + ", authenticationPolicy=" + String.valueOf(this.authenticationPolicy) + ", properties=" + String.valueOf(this.properties) + ", contacts=" + String.valueOf(this.contacts) + ")";
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTheme() {
        return this.theme;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public String getInformationUrl() {
        return this.informationUrl;
    }

    @Generated
    public String getPrivacyUrl() {
        return this.privacyUrl;
    }

    @Generated
    public String getTemplateName() {
        return this.templateName;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public RegisteredServiceExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @Generated
    public RegisteredServiceTicketGrantingTicketExpirationPolicy getTicketGrantingTicketExpirationPolicy() {
        return this.ticketGrantingTicketExpirationPolicy;
    }

    @Generated
    public int getEvaluationOrder() {
        return this.evaluationOrder;
    }

    @Generated
    public RegisteredServiceUsernameAttributeProvider getUsernameAttributeProvider() {
        return this.usernameAttributeProvider;
    }

    @Generated
    public RegisteredServiceLogoutType getLogoutType() {
        return this.logoutType;
    }

    @Generated
    public Set<String> getEnvironments() {
        return this.environments;
    }

    @Generated
    public RegisteredServiceAttributeReleasePolicy getAttributeReleasePolicy() {
        return this.attributeReleasePolicy;
    }

    @Generated
    public RegisteredServiceMultifactorPolicy getMultifactorAuthenticationPolicy() {
        return this.multifactorAuthenticationPolicy;
    }

    @Generated
    public RegisteredServicePublicKey getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public RegisteredServiceMatchingStrategy getMatchingStrategy() {
        return this.matchingStrategy;
    }

    @Generated
    public String getLogo() {
        return this.logo;
    }

    @Generated
    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    @Generated
    public RegisteredServiceAccessStrategy getAccessStrategy() {
        return this.accessStrategy;
    }

    @Generated
    public RegisteredServiceAuthenticationPolicy getAuthenticationPolicy() {
        return this.authenticationPolicy;
    }

    @Generated
    public Map<String, RegisteredServiceProperty> getProperties() {
        return this.properties;
    }

    @Generated
    public List<RegisteredServiceContact> getContacts() {
        return this.contacts;
    }

    @Generated
    public BaseRegisteredService setServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @Generated
    public BaseRegisteredService setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public BaseRegisteredService setTheme(String theme) {
        this.theme = theme;
        return this;
    }

    @Generated
    public BaseRegisteredService setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @Generated
    public BaseRegisteredService setInformationUrl(String informationUrl) {
        this.informationUrl = informationUrl;
        return this;
    }

    @Generated
    public BaseRegisteredService setPrivacyUrl(String privacyUrl) {
        this.privacyUrl = privacyUrl;
        return this;
    }

    @Generated
    public BaseRegisteredService setTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    @Generated
    public BaseRegisteredService setId(long id) {
        this.id = id;
        return this;
    }

    @Generated
    public BaseRegisteredService setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public BaseRegisteredService setExpirationPolicy(RegisteredServiceExpirationPolicy expirationPolicy) {
        this.expirationPolicy = expirationPolicy;
        return this;
    }

    @Generated
    public BaseRegisteredService setTicketGrantingTicketExpirationPolicy(RegisteredServiceTicketGrantingTicketExpirationPolicy ticketGrantingTicketExpirationPolicy) {
        this.ticketGrantingTicketExpirationPolicy = ticketGrantingTicketExpirationPolicy;
        return this;
    }

    @Generated
    public BaseRegisteredService setEvaluationOrder(int evaluationOrder) {
        this.evaluationOrder = evaluationOrder;
        return this;
    }

    @Generated
    public BaseRegisteredService setUsernameAttributeProvider(RegisteredServiceUsernameAttributeProvider usernameAttributeProvider) {
        this.usernameAttributeProvider = usernameAttributeProvider;
        return this;
    }

    @Generated
    public BaseRegisteredService setLogoutType(RegisteredServiceLogoutType logoutType) {
        this.logoutType = logoutType;
        return this;
    }

    @Generated
    public BaseRegisteredService setEnvironments(Set<String> environments) {
        this.environments = environments;
        return this;
    }

    @Generated
    public BaseRegisteredService setAttributeReleasePolicy(RegisteredServiceAttributeReleasePolicy attributeReleasePolicy) {
        this.attributeReleasePolicy = attributeReleasePolicy;
        return this;
    }

    @Generated
    public BaseRegisteredService setMultifactorAuthenticationPolicy(RegisteredServiceMultifactorPolicy multifactorAuthenticationPolicy) {
        this.multifactorAuthenticationPolicy = multifactorAuthenticationPolicy;
        return this;
    }

    @Generated
    public BaseRegisteredService setPublicKey(RegisteredServicePublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Generated
    public BaseRegisteredService setMatchingStrategy(RegisteredServiceMatchingStrategy matchingStrategy) {
        this.matchingStrategy = matchingStrategy;
        return this;
    }

    @Generated
    public BaseRegisteredService setLogo(String logo) {
        this.logo = logo;
        return this;
    }

    @Generated
    public BaseRegisteredService setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    @Generated
    public BaseRegisteredService setAccessStrategy(RegisteredServiceAccessStrategy accessStrategy) {
        this.accessStrategy = accessStrategy;
        return this;
    }

    @Generated
    public BaseRegisteredService setAuthenticationPolicy(RegisteredServiceAuthenticationPolicy authenticationPolicy) {
        this.authenticationPolicy = authenticationPolicy;
        return this;
    }

    @Generated
    public BaseRegisteredService setProperties(Map<String, RegisteredServiceProperty> properties) {
        this.properties = properties;
        return this;
    }

    @Generated
    public BaseRegisteredService setContacts(List<RegisteredServiceContact> contacts) {
        this.contacts = contacts;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseRegisteredService)) {
            return false;
        }
        BaseRegisteredService other = (BaseRegisteredService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.evaluationOrder != other.evaluationOrder) {
            return false;
        }
        String this$serviceId = this.serviceId;
        String other$serviceId = other.serviceId;
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$theme = this.theme;
        String other$theme = other.theme;
        if (this$theme == null ? other$theme != null : !this$theme.equals(other$theme)) {
            return false;
        }
        String this$locale = this.locale;
        String other$locale = other.locale;
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$informationUrl = this.informationUrl;
        String other$informationUrl = other.informationUrl;
        if (this$informationUrl == null ? other$informationUrl != null : !this$informationUrl.equals(other$informationUrl)) {
            return false;
        }
        String this$privacyUrl = this.privacyUrl;
        String other$privacyUrl = other.privacyUrl;
        if (this$privacyUrl == null ? other$privacyUrl != null : !this$privacyUrl.equals(other$privacyUrl)) {
            return false;
        }
        String this$templateName = this.templateName;
        String other$templateName = other.templateName;
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        RegisteredServiceExpirationPolicy this$expirationPolicy = this.expirationPolicy;
        RegisteredServiceExpirationPolicy other$expirationPolicy = other.expirationPolicy;
        if (this$expirationPolicy == null ? other$expirationPolicy != null : !this$expirationPolicy.equals(other$expirationPolicy)) {
            return false;
        }
        RegisteredServiceTicketGrantingTicketExpirationPolicy this$ticketGrantingTicketExpirationPolicy = this.ticketGrantingTicketExpirationPolicy;
        RegisteredServiceTicketGrantingTicketExpirationPolicy other$ticketGrantingTicketExpirationPolicy = other.ticketGrantingTicketExpirationPolicy;
        if (this$ticketGrantingTicketExpirationPolicy == null ? other$ticketGrantingTicketExpirationPolicy != null : !this$ticketGrantingTicketExpirationPolicy.equals(other$ticketGrantingTicketExpirationPolicy)) {
            return false;
        }
        RegisteredServiceUsernameAttributeProvider this$usernameAttributeProvider = this.usernameAttributeProvider;
        RegisteredServiceUsernameAttributeProvider other$usernameAttributeProvider = other.usernameAttributeProvider;
        if (this$usernameAttributeProvider == null ? other$usernameAttributeProvider != null : !this$usernameAttributeProvider.equals(other$usernameAttributeProvider)) {
            return false;
        }
        RegisteredServiceLogoutType this$logoutType = this.logoutType;
        RegisteredServiceLogoutType other$logoutType = other.logoutType;
        if (this$logoutType == null ? other$logoutType != null : !this$logoutType.equals(other$logoutType)) {
            return false;
        }
        Set<String> this$environments = this.environments;
        Set<String> other$environments = other.environments;
        if (this$environments == null ? other$environments != null : !((Object)this$environments).equals(other$environments)) {
            return false;
        }
        RegisteredServiceAttributeReleasePolicy this$attributeReleasePolicy = this.attributeReleasePolicy;
        RegisteredServiceAttributeReleasePolicy other$attributeReleasePolicy = other.attributeReleasePolicy;
        if (this$attributeReleasePolicy == null ? other$attributeReleasePolicy != null : !this$attributeReleasePolicy.equals(other$attributeReleasePolicy)) {
            return false;
        }
        RegisteredServiceMultifactorPolicy this$multifactorAuthenticationPolicy = this.multifactorAuthenticationPolicy;
        RegisteredServiceMultifactorPolicy other$multifactorAuthenticationPolicy = other.multifactorAuthenticationPolicy;
        if (this$multifactorAuthenticationPolicy == null ? other$multifactorAuthenticationPolicy != null : !this$multifactorAuthenticationPolicy.equals(other$multifactorAuthenticationPolicy)) {
            return false;
        }
        RegisteredServicePublicKey this$publicKey = this.publicKey;
        RegisteredServicePublicKey other$publicKey = other.publicKey;
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        RegisteredServiceMatchingStrategy this$matchingStrategy = this.matchingStrategy;
        RegisteredServiceMatchingStrategy other$matchingStrategy = other.matchingStrategy;
        if (this$matchingStrategy == null ? other$matchingStrategy != null : !this$matchingStrategy.equals(other$matchingStrategy)) {
            return false;
        }
        String this$logo = this.logo;
        String other$logo = other.logo;
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        String this$logoutUrl = this.logoutUrl;
        String other$logoutUrl = other.logoutUrl;
        if (this$logoutUrl == null ? other$logoutUrl != null : !this$logoutUrl.equals(other$logoutUrl)) {
            return false;
        }
        RegisteredServiceAccessStrategy this$accessStrategy = this.accessStrategy;
        RegisteredServiceAccessStrategy other$accessStrategy = other.accessStrategy;
        if (this$accessStrategy == null ? other$accessStrategy != null : !this$accessStrategy.equals(other$accessStrategy)) {
            return false;
        }
        RegisteredServiceAuthenticationPolicy this$authenticationPolicy = this.authenticationPolicy;
        RegisteredServiceAuthenticationPolicy other$authenticationPolicy = other.authenticationPolicy;
        if (this$authenticationPolicy == null ? other$authenticationPolicy != null : !this$authenticationPolicy.equals(other$authenticationPolicy)) {
            return false;
        }
        Map<String, RegisteredServiceProperty> this$properties = this.properties;
        Map<String, RegisteredServiceProperty> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<RegisteredServiceContact> this$contacts = this.contacts;
        List<RegisteredServiceContact> other$contacts = other.contacts;
        return !(this$contacts == null ? other$contacts != null : !((Object)this$contacts).equals(other$contacts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseRegisteredService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.evaluationOrder;
        String $serviceId = this.serviceId;
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $theme = this.theme;
        result = result * 59 + ($theme == null ? 43 : $theme.hashCode());
        String $locale = this.locale;
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $informationUrl = this.informationUrl;
        result = result * 59 + ($informationUrl == null ? 43 : $informationUrl.hashCode());
        String $privacyUrl = this.privacyUrl;
        result = result * 59 + ($privacyUrl == null ? 43 : $privacyUrl.hashCode());
        String $templateName = this.templateName;
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        RegisteredServiceExpirationPolicy $expirationPolicy = this.expirationPolicy;
        result = result * 59 + ($expirationPolicy == null ? 43 : $expirationPolicy.hashCode());
        RegisteredServiceTicketGrantingTicketExpirationPolicy $ticketGrantingTicketExpirationPolicy = this.ticketGrantingTicketExpirationPolicy;
        result = result * 59 + ($ticketGrantingTicketExpirationPolicy == null ? 43 : $ticketGrantingTicketExpirationPolicy.hashCode());
        RegisteredServiceUsernameAttributeProvider $usernameAttributeProvider = this.usernameAttributeProvider;
        result = result * 59 + ($usernameAttributeProvider == null ? 43 : $usernameAttributeProvider.hashCode());
        RegisteredServiceLogoutType $logoutType = this.logoutType;
        result = result * 59 + ($logoutType == null ? 43 : $logoutType.hashCode());
        Set<String> $environments = this.environments;
        result = result * 59 + ($environments == null ? 43 : ((Object)$environments).hashCode());
        RegisteredServiceAttributeReleasePolicy $attributeReleasePolicy = this.attributeReleasePolicy;
        result = result * 59 + ($attributeReleasePolicy == null ? 43 : $attributeReleasePolicy.hashCode());
        RegisteredServiceMultifactorPolicy $multifactorAuthenticationPolicy = this.multifactorAuthenticationPolicy;
        result = result * 59 + ($multifactorAuthenticationPolicy == null ? 43 : $multifactorAuthenticationPolicy.hashCode());
        RegisteredServicePublicKey $publicKey = this.publicKey;
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        RegisteredServiceMatchingStrategy $matchingStrategy = this.matchingStrategy;
        result = result * 59 + ($matchingStrategy == null ? 43 : $matchingStrategy.hashCode());
        String $logo = this.logo;
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        String $logoutUrl = this.logoutUrl;
        result = result * 59 + ($logoutUrl == null ? 43 : $logoutUrl.hashCode());
        RegisteredServiceAccessStrategy $accessStrategy = this.accessStrategy;
        result = result * 59 + ($accessStrategy == null ? 43 : $accessStrategy.hashCode());
        RegisteredServiceAuthenticationPolicy $authenticationPolicy = this.authenticationPolicy;
        result = result * 59 + ($authenticationPolicy == null ? 43 : $authenticationPolicy.hashCode());
        Map<String, RegisteredServiceProperty> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<RegisteredServiceContact> $contacts = this.contacts;
        result = result * 59 + ($contacts == null ? 43 : ((Object)$contacts).hashCode());
        return result;
    }
}

