/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.util.HashMap;
import lombok.Generated;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.web.BaseCaptchaValidator;
import org.springframework.http.HttpMethod;

public class FriendlyCaptchaValidator
extends BaseCaptchaValidator {
    public static final String REQUEST_PARAM_FRIENDLY_CAPTCHA_RESPONSE = "frc-captcha-solution";
    private final String recaptchaResponseParameterName;

    public FriendlyCaptchaValidator(GoogleRecaptchaProperties recaptchaProperties) {
        super(recaptchaProperties);
        this.recaptchaResponseParameterName = REQUEST_PARAM_FRIENDLY_CAPTCHA_RESPONSE;
    }

    @Override
    protected HttpResponse executeCaptchaVerification(String recaptchaResponse, String userAgent) {
        return (HttpResponse)FunctionUtils.doUnchecked(() -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("siteKey", this.recaptchaProperties.getSiteKey());
            data.put("secret", this.recaptchaProperties.getSecret());
            data.put("solution", recaptchaResponse);
            String json = MAPPER.writeValueAsString(data);
            HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.POST).url(this.recaptchaProperties.getVerifyUrl()).headers(CollectionUtils.wrap((String)"Content-Type", (Object)"application/json")).entity(json).build();
            return HttpUtils.execute((HttpExecutionRequest)exec);
        });
    }

    @Override
    @Generated
    public String getRecaptchaResponseParameterName() {
        return this.recaptchaResponseParameterName;
    }
}

