/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.rest;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.RestfulPasswordManagementProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.impl.BasePasswordManagementService;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestPasswordManagementService
extends BasePasswordManagementService {
    private final RestTemplate restTemplate;

    public RestPasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, CasConfigurationProperties casProperties, RestTemplate restTemplate, PasswordHistoryService passwordHistoryService) {
        super(casProperties, cipherExecutor, passwordHistoryService);
        this.restTemplate = restTemplate;
    }

    public boolean changeInternal(PasswordChangeRequest bean) {
        RestfulPasswordManagementProperties rest = this.casProperties.getAuthn().getPm().getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlChange())) {
            return false;
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put(rest.getFieldNameUser(), bean.getUsername());
        body.put(rest.getFieldNamePassword(), bean.toPassword());
        if (bean.getCurrentPassword() != null) {
            body.put(rest.getFieldNamePasswordOld(), bean.toCurrentPassword());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(body, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlChange(), HttpMethod.POST, entity, Boolean.class, new Object[0]);
        return result.getStatusCode().value() == HttpStatus.OK.value() && result.hasBody() && Objects.requireNonNull((Boolean)result.getBody()) != false;
    }

    public String findUsername(PasswordManagementQuery query) {
        RestfulPasswordManagementProperties rest = this.casProperties.getAuthn().getPm().getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlUser())) {
            return null;
        }
        String url = UriComponentsBuilder.fromUriString((String)rest.getEndpointUrlUser()).queryParam("email", new Object[]{query.getUsername()}).build().toUriString();
        RequestEntity request = new RequestEntity(HttpMethod.GET, URI.create(url));
        ResponseEntity result = this.restTemplate.exchange(request, String.class);
        if (result.getStatusCode().value() == HttpStatus.OK.value() && result.hasBody()) {
            return (String)result.getBody();
        }
        return null;
    }

    public String findEmail(PasswordManagementQuery query) {
        RestfulPasswordManagementProperties rest = this.casProperties.getAuthn().getPm().getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlEmail())) {
            return null;
        }
        String url = UriComponentsBuilder.fromUriString((String)rest.getEndpointUrlEmail()).queryParam("username", new Object[]{query.getUsername()}).build().toUriString();
        RequestEntity request = new RequestEntity(HttpMethod.GET, URI.create(url));
        ResponseEntity result = this.restTemplate.exchange(request, String.class);
        if (result.getStatusCode().value() == HttpStatus.OK.value() && result.hasBody()) {
            return (String)result.getBody();
        }
        return null;
    }

    public String findPhone(PasswordManagementQuery query) {
        RestfulPasswordManagementProperties rest = this.casProperties.getAuthn().getPm().getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlPhone())) {
            return null;
        }
        String url = UriComponentsBuilder.fromUriString((String)rest.getEndpointUrlPhone()).queryParam("username", new Object[]{query.getUsername()}).build().toUriString();
        RequestEntity request = new RequestEntity(HttpMethod.GET, URI.create(url));
        ResponseEntity result = this.restTemplate.exchange(request, String.class);
        if (result.getStatusCode().value() == HttpStatus.OK.value() && result.hasBody()) {
            return (String)result.getBody();
        }
        return null;
    }

    public Map<String, String> getSecurityQuestions(PasswordManagementQuery query) {
        RestfulPasswordManagementProperties rest = this.casProperties.getAuthn().getPm().getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlSecurityQuestions())) {
            return null;
        }
        String url = UriComponentsBuilder.fromUriString((String)rest.getEndpointUrlSecurityQuestions()).queryParam("username", new Object[]{query.getUsername()}).build().toUriString();
        RequestEntity request = new RequestEntity(HttpMethod.GET, URI.create(url));
        ResponseEntity result = this.restTemplate.exchange(request, Map.class);
        if (result.getStatusCode().value() == HttpStatus.OK.value() && result.hasBody()) {
            return (Map)result.getBody();
        }
        return null;
    }

    public void updateSecurityQuestions(PasswordManagementQuery query) {
        RestfulPasswordManagementProperties rest = this.casProperties.getAuthn().getPm().getRest();
        if (StringUtils.isNotBlank((CharSequence)rest.getEndpointUrlSecurityQuestions())) {
            String url = UriComponentsBuilder.fromUriString((String)rest.getEndpointUrlSecurityQuestions()).queryParam("username", new Object[]{query.getUsername()}).build().toUriString();
            HttpEntity entity = new HttpEntity((MultiValueMap)query.getSecurityQuestions());
            this.restTemplate.exchange(url, HttpMethod.POST, entity, Boolean.class, new Object[0]);
        }
    }

    public boolean unlockAccount(Credential credential) {
        RestfulPasswordManagementProperties rest = this.casProperties.getAuthn().getPm().getRest();
        boolean result = true;
        if (StringUtils.isNotBlank((CharSequence)rest.getEndpointUrlAccountUnlock())) {
            String url = UriComponentsBuilder.fromUriString((String)rest.getEndpointUrlAccountUnlock()).queryParam("username", new Object[]{credential.getId()}).build().toUriString();
            RequestEntity request = new RequestEntity(HttpMethod.POST, URI.create(url));
            result = this.restTemplate.exchange(request, Boolean.class).getStatusCode().is2xxSuccessful();
        }
        return result;
    }
}

