/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import lombok.Generated;
import net.shibboleth.shared.httpclient.HttpClientBuilder;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.HttpClient;
import org.pac4j.core.exception.TechnicalException;

public class SAML2HttpClientBuilder {
    private Duration connectionTimeout;
    private Duration socketTimeout;
    private boolean useSystemProperties;
    private boolean followRedirects;
    private boolean closeConnectionAfterResponse = true;
    private int maxConnectionsTotal = 3;
    private CredentialsProvider credentialsProvider;

    public HttpClient build() {
        try {
            Pac4jHttpClientBuilder builder = new Pac4jHttpClientBuilder(this.credentialsProvider);
            builder.resetDefaults();
            if (this.connectionTimeout != null) {
                builder.setConnectionTimeout(this.connectionTimeout);
            }
            builder.setUseSystemProperties(this.useSystemProperties);
            if (this.socketTimeout != null) {
                builder.setSocketTimeout(this.socketTimeout);
            }
            builder.setHttpFollowRedirects(this.followRedirects);
            builder.setMaxConnectionsTotal(this.maxConnectionsTotal);
            builder.setConnectionCloseAfterResponse(this.closeConnectionAfterResponse);
            return builder.buildClient();
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isCloseConnectionAfterResponse() {
        return this.closeConnectionAfterResponse;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxConnectionsTotal() {
        return this.maxConnectionsTotal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSocketTimeout(Duration socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUseSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCloseConnectionAfterResponse(boolean closeConnectionAfterResponse) {
        this.closeConnectionAfterResponse = closeConnectionAfterResponse;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxConnectionsTotal(int maxConnectionsTotal) {
        this.maxConnectionsTotal = maxConnectionsTotal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    private static class Pac4jHttpClientBuilder
    extends HttpClientBuilder {
        private final CredentialsProvider credentialsProvider;

        protected CredentialsProvider buildDefaultCredentialsProvider() {
            if (this.credentialsProvider != null) {
                return this.credentialsProvider;
            }
            return super.buildDefaultCredentialsProvider();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Pac4jHttpClientBuilder(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
        }
    }
}

