/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import com.yubico.core.WebAuthnCache;
import com.yubico.data.AssertionRequestWrapper;
import com.yubico.data.AssertionResponse;
import com.yubico.data.CredentialRegistration;
import com.yubico.data.RegistrationRequest;
import com.yubico.data.RegistrationResponse;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.util.Either;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.FinishRegistrationOptions;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.StartAssertionOptions;
import com.yubico.webauthn.StartRegistrationOptions;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.attestation.AttestationMetadataSource;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.AuthenticatorAttestationResponse;
import com.yubico.webauthn.data.AuthenticatorData;
import com.yubico.webauthn.data.AuthenticatorSelectionCriteria;
import com.yubico.webauthn.data.AuthenticatorTransport;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ResidentKeyRequirement;
import com.yubico.webauthn.data.UserIdentity;
import com.yubico.webauthn.exception.AssertionFailedException;
import com.yubico.webauthn.exception.RegistrationFailedException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthnServer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnServer.class);
    private static final int IDENTIFIER_LENGTH = 32;
    private static final ObjectMapper OBJECT_MAPPER = JacksonCodecs.json();
    private final RegistrationStorage userStorage;
    private final WebAuthnCache<RegistrationRequest> registerRequestStorage;
    private final WebAuthnCache<AssertionRequestWrapper> assertRequestStorage;
    private final RelyingParty relyingParty;
    private final SessionManager sessionManager;
    private final CasConfigurationProperties casProperties;

    public Either<String, RegistrationRequest> startRegistration(HttpServletRequest request, @NonNull String username, Optional<String> displayName, Optional<String> credentialNickname, ResidentKeyRequirement residentKeyRequirement, Optional<ByteArray> sessionToken) throws ExecutionException {
        boolean permissionGranted;
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        LOGGER.trace("Starting registration operation for username: [{}], credentialNickname: [{}]", (Object)username, credentialNickname);
        Collection<CredentialRegistration> registrations = this.userStorage.getRegistrationsByUsername(username);
        Optional<UserIdentity> existingUser = registrations.stream().findAny().map(CredentialRegistration::getUserIdentity);
        boolean bl = permissionGranted = this.casProperties.getAuthn().getMfa().getWebAuthn().getCore().isMultipleDeviceRegistrationEnabled() || existingUser.map(userIdentity -> this.sessionManager.isSessionForUser(request, userIdentity.getId(), sessionToken)).orElse(true) != false;
        if (permissionGranted) {
            UserIdentity registrationUserId = existingUser.orElseGet(() -> UserIdentity.builder().name(username).displayName((String)displayName.orElseThrow()).id(SessionManager.generateRandom(32)).build());
            RegistrationRequest registrationRequest = new RegistrationRequest(username, credentialNickname, SessionManager.generateRandom(32), this.relyingParty.startRegistration(StartRegistrationOptions.builder().user(registrationUserId).authenticatorSelection(AuthenticatorSelectionCriteria.builder().residentKey(residentKeyRequirement).build()).build()), Optional.of(this.sessionManager.createSession(request, registrationUserId.getId())));
            this.registerRequestStorage.put(request, registrationRequest.requestId(), registrationRequest);
            return Either.right(registrationRequest);
        }
        return Either.left("The username %s is already registered and/or has an active session.".formatted(username));
    }

    public Either<List<String>, SuccessfulRegistrationResult> finishRegistration(HttpServletRequest request, String responseJson) {
        RegistrationResponse registrationResponse;
        LOGGER.trace("Finishing registration with response: [{}]", (Object)responseJson);
        try {
            registrationResponse = (RegistrationResponse)OBJECT_MAPPER.readValue(responseJson, RegistrationResponse.class);
        }
        catch (IOException e) {
            LOGGER.error("Registration failed; response: [{}]", (Object)responseJson, (Object)e);
            return Either.left(List.of("Registration failed", "Failed to decode response object.", e.getMessage()));
        }
        RegistrationRequest registrationRequest = this.registerRequestStorage.getIfPresent(request, registrationResponse.requestId());
        this.registerRequestStorage.invalidate(request, registrationResponse.requestId());
        if (registrationRequest == null) {
            LOGGER.debug("Finishing registration failed with: [{}]", (Object)responseJson);
            return Either.left(List.of("Registration failed", "No such registration in progress."));
        }
        try {
            RegistrationResult registration = this.relyingParty.finishRegistration(FinishRegistrationOptions.builder().request(registrationRequest.publicKeyCredentialCreationOptions()).response(registrationResponse.credential()).build());
            if (this.userStorage.userExists(registrationRequest.username())) {
                boolean permissionGranted = false;
                Boolean isValidSession = registrationRequest.sessionToken().map(token -> this.sessionManager.isSessionForUser(request, registrationRequest.publicKeyCredentialCreationOptions().getUser().getId(), (ByteArray)token)).orElse(false);
                LOGGER.debug("Session token: [{}], valid session [{}]", registrationRequest.sessionToken(), (Object)isValidSession);
                if (isValidSession.booleanValue()) {
                    permissionGranted = true;
                    LOGGER.info("Session token accepted for user [{}]", (Object)registrationRequest.publicKeyCredentialCreationOptions().getUser().getId());
                }
                LOGGER.debug("Permission granted to finish registration: [{}]", (Object)permissionGranted);
                if (!permissionGranted) {
                    throw new RegistrationFailedException(new IllegalArgumentException("User %s already exists".formatted(registrationRequest.username())));
                }
            }
            return Either.right(new SuccessfulRegistrationResult(registrationRequest, registrationResponse, this.addRegistration(registrationRequest.publicKeyCredentialCreationOptions().getUser(), registrationRequest.credentialNickname(), registration), registration.isAttestationTrusted() || this.relyingParty.isAllowUntrustedAttestation(), this.sessionManager.createSession(request, registrationRequest.publicKeyCredentialCreationOptions().getUser().getId())));
        }
        catch (RegistrationFailedException e) {
            LOGGER.debug("Finishing registration failed with: [{}]", (Object)responseJson, (Object)e);
            return Either.left(List.of("Registration failed", e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error("Finishing registration failed with: [{}]", (Object)responseJson, (Object)e);
            return Either.left(List.of("Registration failed unexpectedly; this is likely a bug.", e.getMessage()));
        }
    }

    public Either<List<String>, AssertionRequestWrapper> startAuthentication(HttpServletRequest request, Optional<String> username) {
        if (username.isPresent() && !this.userStorage.userExists(username.get())) {
            return Either.left(List.of("The username %s is not registered.".formatted(username.get())));
        }
        AssertionRequestWrapper assertionRequest = new AssertionRequestWrapper(SessionManager.generateRandom(32), this.relyingParty.startAssertion(StartAssertionOptions.builder().username(username).build()));
        this.assertRequestStorage.put(request, assertionRequest.getRequestId(), assertionRequest);
        return Either.right(assertionRequest);
    }

    public Either<List<String>, SuccessfulAuthenticationResult> finishAuthentication(HttpServletRequest request, String responseJson) {
        AssertionResponse assertionResponse;
        try {
            assertionResponse = (AssertionResponse)OBJECT_MAPPER.readValue(responseJson, AssertionResponse.class);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to decode response object", (Throwable)e);
            return Either.left(List.of("Assertion failed!", "Failed to decode response object.", e.getMessage()));
        }
        AssertionRequestWrapper assertionRequestWrapper = this.assertRequestStorage.getIfPresent(request, assertionResponse.requestId());
        this.assertRequestStorage.invalidate(request, assertionResponse.requestId());
        if (assertionRequestWrapper == null) {
            return Either.left(List.of("Assertion failed!", "No such assertion in progress."));
        }
        try {
            AssertionResult assertionResult = this.relyingParty.finishAssertion(FinishAssertionOptions.builder().request(assertionRequestWrapper.getRequest()).response(assertionResponse.credential()).build());
            if (assertionResult.isSuccess()) {
                try {
                    this.userStorage.updateSignatureCount(assertionResult);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to update signature count for user \"{}\", credential \"{}\"", new Object[]{assertionResult.getUsername(), assertionResponse.credential().getId(), e});
                }
                ByteArray session = this.sessionManager.createSession(request, assertionResult.getCredential().getUserHandle());
                return Either.right(new SuccessfulAuthenticationResult(assertionRequestWrapper, assertionResponse, this.userStorage.getRegistrationsByUsername(assertionResult.getUsername()), assertionResult.getUsername(), session));
            }
            return Either.left(List.of("Assertion failed: Invalid assertion."));
        }
        catch (AssertionFailedException e) {
            LOGGER.warn("Assertion failed", (Throwable)e);
            return Either.left(List.of("Assertion failed", e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error("Assertion failed", (Throwable)e);
            return Either.left(List.of("Assertion failed unexpectedly; this is likely a bug.", e.getMessage()));
        }
    }

    private CredentialRegistration addRegistration(UserIdentity userIdentity, Optional<String> nickname, RegistrationResult result) {
        return this.addRegistration(userIdentity, nickname, RegisteredCredential.builder().credentialId(result.getKeyId().getId()).userHandle(userIdentity.getId()).publicKeyCose(result.getPublicKeyCose()).signatureCount(result.getSignatureCount()).build(), result.getKeyId().getTransports().orElseGet(TreeSet::new), result.getAttestationTrustPath().flatMap(x5c -> x5c.stream().findFirst()).flatMap(cert -> {
            Object patt0$temp;
            if (this.relyingParty.getAttestationTrustSource().isPresent() && (patt0$temp = this.relyingParty.getAttestationTrustSource().get()) instanceof AttestationMetadataSource) {
                AttestationMetadataSource source = (AttestationMetadataSource)patt0$temp;
                return source.findMetadata((X509Certificate)cert);
            }
            return Optional.empty();
        }));
    }

    private CredentialRegistration addRegistration(UserIdentity userIdentity, Optional<String> nickname, RegisteredCredential credential, SortedSet<AuthenticatorTransport> transports, Optional<Attestation> attestationMetadata) {
        CredentialRegistration reg = CredentialRegistration.builder().userIdentity(userIdentity).credentialNickname(nickname.orElse(null)).registrationTime(Clock.systemUTC().instant()).credential(credential).transports(transports).attestationMetadata(attestationMetadata.orElse(null)).build();
        LOGGER.debug("Adding registration: user: [{}], nickname: [{}], credential: [{}]", new Object[]{userIdentity, nickname, credential});
        this.userStorage.addRegistrationByUsername(userIdentity.getName(), reg);
        return reg;
    }

    @Generated
    public WebAuthnServer(RegistrationStorage userStorage, WebAuthnCache<RegistrationRequest> registerRequestStorage, WebAuthnCache<AssertionRequestWrapper> assertRequestStorage, RelyingParty relyingParty, SessionManager sessionManager, CasConfigurationProperties casProperties) {
        this.userStorage = userStorage;
        this.registerRequestStorage = registerRequestStorage;
        this.assertRequestStorage = assertRequestStorage;
        this.relyingParty = relyingParty;
        this.sessionManager = sessionManager;
        this.casProperties = casProperties;
    }

    public static final class SuccessfulRegistrationResult {
        private final boolean success = true;
        private final RegistrationRequest request;
        private final RegistrationResponse response;
        private final CredentialRegistration registration;
        private final boolean attestationTrusted;
        private final Optional<AttestationCertInfo> attestationCert;
        @JsonSerialize(using=AuthDataSerializer.class)
        private final AuthenticatorData authData;
        private final String username;
        private final ByteArray sessionToken;

        public SuccessfulRegistrationResult(RegistrationRequest request, RegistrationResponse response, CredentialRegistration registration, boolean attestationTrusted, ByteArray sessionToken) {
            this.request = request;
            this.response = response;
            this.registration = registration;
            this.attestationTrusted = attestationTrusted;
            this.attestationCert = Optional.ofNullable(((AuthenticatorAttestationResponse)response.credential().getResponse()).getAttestation().getAttestationStatement().get("x5c")).map(certs -> certs.get(0)).flatMap(certDer -> {
                try {
                    return Optional.of(new ByteArray(certDer.binaryValue()));
                }
                catch (IOException e) {
                    LOGGER.error("Failed to get binary value from x5c element: {}", certDer, (Object)e);
                    return Optional.empty();
                }
            }).map(AttestationCertInfo::new);
            this.authData = ((AuthenticatorAttestationResponse)response.credential().getResponse()).getParsedAuthenticatorData();
            this.username = request.username();
            this.sessionToken = sessionToken;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public RegistrationRequest getRequest() {
            return this.request;
        }

        @Generated
        public RegistrationResponse getResponse() {
            return this.response;
        }

        @Generated
        public CredentialRegistration getRegistration() {
            return this.registration;
        }

        @Generated
        public boolean isAttestationTrusted() {
            return this.attestationTrusted;
        }

        @Generated
        public Optional<AttestationCertInfo> getAttestationCert() {
            return this.attestationCert;
        }

        @Generated
        public AuthenticatorData getAuthData() {
            return this.authData;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getSessionToken() {
            return this.sessionToken;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SuccessfulRegistrationResult)) {
                return false;
            }
            SuccessfulRegistrationResult other = (SuccessfulRegistrationResult)o;
            if (this.success != other.success) {
                return false;
            }
            if (this.attestationTrusted != other.attestationTrusted) {
                return false;
            }
            RegistrationRequest this$request = this.request;
            RegistrationRequest other$request = other.request;
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            RegistrationResponse this$response = this.response;
            RegistrationResponse other$response = other.response;
            if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
                return false;
            }
            CredentialRegistration this$registration = this.registration;
            CredentialRegistration other$registration = other.registration;
            if (this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration)) {
                return false;
            }
            Optional<AttestationCertInfo> this$attestationCert = this.attestationCert;
            Optional<AttestationCertInfo> other$attestationCert = other.attestationCert;
            if (this$attestationCert == null ? other$attestationCert != null : !((Object)this$attestationCert).equals(other$attestationCert)) {
                return false;
            }
            AuthenticatorData this$authData = this.authData;
            AuthenticatorData other$authData = other.authData;
            if (this$authData == null ? other$authData != null : !this$authData.equals(other$authData)) {
                return false;
            }
            String this$username = this.username;
            String other$username = other.username;
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$sessionToken = this.sessionToken;
            ByteArray other$sessionToken = other.sessionToken;
            return !(this$sessionToken == null ? other$sessionToken != null : !this$sessionToken.equals(other$sessionToken));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Objects.requireNonNull(this);
            result = result * 59 + 79;
            result = result * 59 + (this.attestationTrusted ? 79 : 97);
            RegistrationRequest $request = this.request;
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            RegistrationResponse $response = this.response;
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            CredentialRegistration $registration = this.registration;
            result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
            Optional<AttestationCertInfo> $attestationCert = this.attestationCert;
            result = result * 59 + ($attestationCert == null ? 43 : ((Object)$attestationCert).hashCode());
            AuthenticatorData $authData = this.authData;
            result = result * 59 + ($authData == null ? 43 : $authData.hashCode());
            String $username = this.username;
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $sessionToken = this.sessionToken;
            result = result * 59 + ($sessionToken == null ? 43 : $sessionToken.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebAuthnServer.SuccessfulRegistrationResult(success=" + this.success + ", request=" + String.valueOf(this.request) + ", response=" + String.valueOf(this.response) + ", registration=" + String.valueOf(this.registration) + ", attestationTrusted=" + this.attestationTrusted + ", attestationCert=" + String.valueOf(this.attestationCert) + ", authData=" + String.valueOf(this.authData) + ", username=" + this.username + ", sessionToken=" + String.valueOf(this.sessionToken) + ")";
        }
    }

    public static final class SuccessfulAuthenticationResult {
        private final boolean success = true;
        private final AssertionRequestWrapper request;
        private final AssertionResponse response;
        private final Collection<CredentialRegistration> registrations;
        @JsonSerialize(using=AuthDataSerializer.class)
        private final AuthenticatorData authData;
        private final String username;
        private final ByteArray sessionToken;

        public SuccessfulAuthenticationResult(AssertionRequestWrapper request, AssertionResponse response, Collection<CredentialRegistration> registrations, String username, ByteArray sessionToken) {
            this(request, response, registrations, ((AuthenticatorAssertionResponse)response.credential().getResponse()).getParsedAuthenticatorData(), username, sessionToken);
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public AssertionRequestWrapper getRequest() {
            return this.request;
        }

        @Generated
        public AssertionResponse getResponse() {
            return this.response;
        }

        @Generated
        public Collection<CredentialRegistration> getRegistrations() {
            return this.registrations;
        }

        @Generated
        public AuthenticatorData getAuthData() {
            return this.authData;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getSessionToken() {
            return this.sessionToken;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SuccessfulAuthenticationResult)) {
                return false;
            }
            SuccessfulAuthenticationResult other = (SuccessfulAuthenticationResult)o;
            if (this.success != other.success) {
                return false;
            }
            AssertionRequestWrapper this$request = this.request;
            AssertionRequestWrapper other$request = other.request;
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            AssertionResponse this$response = this.response;
            AssertionResponse other$response = other.response;
            if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
                return false;
            }
            Collection<CredentialRegistration> this$registrations = this.registrations;
            Collection<CredentialRegistration> other$registrations = other.registrations;
            if (this$registrations == null ? other$registrations != null : !((Object)this$registrations).equals(other$registrations)) {
                return false;
            }
            AuthenticatorData this$authData = this.authData;
            AuthenticatorData other$authData = other.authData;
            if (this$authData == null ? other$authData != null : !this$authData.equals(other$authData)) {
                return false;
            }
            String this$username = this.username;
            String other$username = other.username;
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$sessionToken = this.sessionToken;
            ByteArray other$sessionToken = other.sessionToken;
            return !(this$sessionToken == null ? other$sessionToken != null : !this$sessionToken.equals(other$sessionToken));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Objects.requireNonNull(this);
            result = result * 59 + 79;
            AssertionRequestWrapper $request = this.request;
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            AssertionResponse $response = this.response;
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            Collection<CredentialRegistration> $registrations = this.registrations;
            result = result * 59 + ($registrations == null ? 43 : ((Object)$registrations).hashCode());
            AuthenticatorData $authData = this.authData;
            result = result * 59 + ($authData == null ? 43 : $authData.hashCode());
            String $username = this.username;
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $sessionToken = this.sessionToken;
            result = result * 59 + ($sessionToken == null ? 43 : $sessionToken.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebAuthnServer.SuccessfulAuthenticationResult(success=" + this.success + ", request=" + String.valueOf(this.request) + ", response=" + String.valueOf(this.response) + ", registrations=" + String.valueOf(this.registrations) + ", authData=" + String.valueOf(this.authData) + ", username=" + this.username + ", sessionToken=" + String.valueOf(this.sessionToken) + ")";
        }

        @Generated
        public SuccessfulAuthenticationResult(AssertionRequestWrapper request, AssertionResponse response, Collection<CredentialRegistration> registrations, AuthenticatorData authData, String username, ByteArray sessionToken) {
            this.request = request;
            this.response = response;
            this.registrations = registrations;
            this.authData = authData;
            this.username = username;
            this.sessionToken = sessionToken;
        }
    }

    private static class AuthDataSerializer
    extends JsonSerializer<AuthenticatorData> {
        private AuthDataSerializer() {
        }

        public void serialize(AuthenticatorData value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("rpIdHash", value.getRpIdHash().getHex());
            gen.writeObjectField("flags", (Object)value.getFlags());
            gen.writeNumberField("signatureCounter", value.getSignatureCounter());
            value.getAttestedCredentialData().ifPresent(acd -> {
                try {
                    gen.writeObjectFieldStart("attestedCredentialData");
                    gen.writeStringField("aaguid", acd.getAaguid().getHex());
                    gen.writeStringField("credentialId", acd.getCredentialId().getHex());
                    gen.writeStringField("publicKey", acd.getCredentialPublicKey().getHex());
                    gen.writeEndObject();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            gen.writeObjectField("extensions", (Object)value.getExtensions());
            gen.writeEndObject();
        }
    }

    public static final class DeregisterCredentialResult {
        private final boolean success = true;
        private final CredentialRegistration droppedRegistration;
        private final boolean accountDeleted;

        @Generated
        public DeregisterCredentialResult(CredentialRegistration droppedRegistration, boolean accountDeleted) {
            this.droppedRegistration = droppedRegistration;
            this.accountDeleted = accountDeleted;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public CredentialRegistration getDroppedRegistration() {
            return this.droppedRegistration;
        }

        @Generated
        public boolean isAccountDeleted() {
            return this.accountDeleted;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeregisterCredentialResult)) {
                return false;
            }
            DeregisterCredentialResult other = (DeregisterCredentialResult)o;
            if (this.success != other.success) {
                return false;
            }
            if (this.accountDeleted != other.accountDeleted) {
                return false;
            }
            CredentialRegistration this$droppedRegistration = this.droppedRegistration;
            CredentialRegistration other$droppedRegistration = other.droppedRegistration;
            return !(this$droppedRegistration == null ? other$droppedRegistration != null : !((Object)this$droppedRegistration).equals(other$droppedRegistration));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Objects.requireNonNull(this);
            result = result * 59 + 79;
            result = result * 59 + (this.accountDeleted ? 79 : 97);
            CredentialRegistration $droppedRegistration = this.droppedRegistration;
            result = result * 59 + ($droppedRegistration == null ? 43 : ((Object)$droppedRegistration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebAuthnServer.DeregisterCredentialResult(success=" + this.success + ", droppedRegistration=" + String.valueOf(this.droppedRegistration) + ", accountDeleted=" + this.accountDeleted + ")";
        }
    }

    public static final class AttestationCertInfo {
        private final ByteArray der;
        private final String text;

        public AttestationCertInfo(ByteArray certDer) {
            this.der = certDer;
            X509Certificate cert = null;
            try {
                cert = CertificateParser.parseDer((byte[])certDer.getBytes());
            }
            catch (CertificateException e) {
                LOGGER.error("Failed to parse attestation certificate");
            }
            this.text = cert == null ? null : cert.toString();
        }

        @Generated
        public ByteArray getDer() {
            return this.der;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttestationCertInfo)) {
                return false;
            }
            AttestationCertInfo other = (AttestationCertInfo)o;
            ByteArray this$der = this.der;
            ByteArray other$der = other.der;
            if (this$der == null ? other$der != null : !this$der.equals(other$der)) {
                return false;
            }
            String this$text = this.text;
            String other$text = other.text;
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteArray $der = this.der;
            result = result * 59 + ($der == null ? 43 : $der.hashCode());
            String $text = this.text;
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebAuthnServer.AttestationCertInfo(der=" + String.valueOf(this.der) + ", text=" + this.text + ")";
        }
    }
}

