/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.pac4j.saml;

import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.starter.pac4j.saml.WASAML2ClientKeystoreGenerator;
import org.apache.syncope.wa.starter.pac4j.saml.WASAML2ClientMetadataGenerator;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.pac4j.core.client.Client;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.keystore.SAML2KeystoreGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WASAML2ClientCustomizer
implements DelegatedClientFactoryCustomizer<Client> {
    private static final Logger LOG = LoggerFactory.getLogger(WASAML2ClientCustomizer.class);
    protected final WARestClient restClient;

    public WASAML2ClientCustomizer(WARestClient restClient) {
        this.restClient = restClient;
    }

    public void customize(Client client) {
        if (client instanceof SAML2Client) {
            SAML2Client saml2Client = (SAML2Client)client;
            LOG.debug("Customizing SAML2 client {}", (Object)client.getName());
            SAML2Configuration configuration = saml2Client.getConfiguration();
            configuration.setKeystoreGenerator((SAML2KeystoreGenerator)new WASAML2ClientKeystoreGenerator(this.restClient, saml2Client));
            configuration.setMetadataGenerator((SAML2MetadataGenerator)new WASAML2ClientMetadataGenerator(this.restClient, saml2Client));
        }
    }
}

