/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateAclsRequestTest {
    private static final short V0 = 0;
    private static final short V1 = 1;
    private static final AclBinding LITERAL_ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.DENY));
    private static final AclBinding LITERAL_ACL2 = new AclBinding(new ResourcePattern(ResourceType.GROUP, "group", PatternType.LITERAL), new AccessControlEntry("User:*", "127.0.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
    private static final AclBinding PREFIXED_ACL1 = new AclBinding(new ResourcePattern(ResourceType.GROUP, "prefix", PatternType.PREFIXED), new AccessControlEntry("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));
    private static final AclBinding UNKNOWN_ACL1 = new AclBinding(new ResourcePattern(ResourceType.UNKNOWN, "unknown", PatternType.LITERAL), new AccessControlEntry("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));

    @Test
    public void shouldThrowOnV0IfNotLiteral() {
        Assertions.assertThrows(UnsupportedVersionException.class, () -> new CreateAclsRequest(CreateAclsRequestTest.data(PREFIXED_ACL1), 0));
    }

    @Test
    public void shouldThrowOnIfUnknown() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CreateAclsRequest(CreateAclsRequestTest.data(UNKNOWN_ACL1), 0));
    }

    @Test
    public void shouldRoundTripV0() {
        CreateAclsRequest original = new CreateAclsRequest(CreateAclsRequestTest.data(LITERAL_ACL1, LITERAL_ACL2), 0);
        ByteBuffer buffer = original.serialize();
        CreateAclsRequest result = CreateAclsRequest.parse((ByteBuffer)buffer, (short)0);
        CreateAclsRequestTest.assertRequestEquals(original, result);
    }

    @Test
    public void shouldRoundTripV1() {
        CreateAclsRequest original = new CreateAclsRequest(CreateAclsRequestTest.data(LITERAL_ACL1, PREFIXED_ACL1), 1);
        ByteBuffer buffer = original.serialize();
        CreateAclsRequest result = CreateAclsRequest.parse((ByteBuffer)buffer, (short)1);
        CreateAclsRequestTest.assertRequestEquals(original, result);
    }

    private static void assertRequestEquals(CreateAclsRequest original, CreateAclsRequest actual) {
        Assertions.assertEquals((int)original.aclCreations().size(), (int)actual.aclCreations().size(), (String)"Number of Acls wrong");
        for (int idx = 0; idx != original.aclCreations().size(); ++idx) {
            AclBinding originalBinding = CreateAclsRequest.aclBinding((CreateAclsRequestData.AclCreation)((CreateAclsRequestData.AclCreation)original.aclCreations().get(idx)));
            AclBinding actualBinding = CreateAclsRequest.aclBinding((CreateAclsRequestData.AclCreation)((CreateAclsRequestData.AclCreation)actual.aclCreations().get(idx)));
            Assertions.assertEquals((Object)originalBinding, (Object)actualBinding);
        }
    }

    private static CreateAclsRequestData data(AclBinding ... acls) {
        List aclCreations = Arrays.stream(acls).map(CreateAclsRequest::aclCreation).collect(Collectors.toList());
        return new CreateAclsRequestData().setCreations(aclCreations);
    }
}

