/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.http;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.http.HttpClient;
import org.springframework.http.HttpMethod;

public class HttpExecutionRequest {
    private final HttpClient httpClient;
    @NonNull
    private final HttpMethod method;
    @NonNull
    private final String url;
    private final String basicAuthUsername;
    private final String basicAuthPassword;
    private final String entity;
    private final String proxyUrl;
    private final String bearerToken;
    private final int maximumRetryAttempts;
    private final Map<String, String> parameters;
    private final Map<String, String> headers;

    boolean isBasicAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.basicAuthUsername) && StringUtils.isNotBlank((CharSequence)this.basicAuthPassword);
    }

    boolean isBearerAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.bearerToken);
    }

    @Generated
    private static int $default$maximumRetryAttempts() {
        return 3;
    }

    @Generated
    private static Map<String, String> $default$parameters() {
        return new LinkedHashMap<String, String>();
    }

    @Generated
    private static Map<String, String> $default$headers() {
        return new LinkedHashMap<String, String>();
    }

    @Generated
    protected HttpExecutionRequest(HttpExecutionRequestBuilder<?, ?> b) {
        this.httpClient = b.httpClient;
        this.method = b.method;
        if (this.method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.url = b.url;
        if (this.url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.basicAuthUsername = b.basicAuthUsername;
        this.basicAuthPassword = b.basicAuthPassword;
        this.entity = b.entity;
        this.proxyUrl = b.proxyUrl;
        this.bearerToken = b.bearerToken;
        this.maximumRetryAttempts = b.maximumRetryAttempts$set ? b.maximumRetryAttempts$value : HttpExecutionRequest.$default$maximumRetryAttempts();
        this.parameters = b.parameters$set ? b.parameters$value : HttpExecutionRequest.$default$parameters();
        this.headers = b.headers$set ? b.headers$value : HttpExecutionRequest.$default$headers();
    }

    @Generated
    public static HttpExecutionRequestBuilder<?, ?> builder() {
        return new HttpExecutionRequestBuilderImpl();
    }

    @Generated
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @NonNull
    @Generated
    public HttpMethod getMethod() {
        return this.method;
    }

    @NonNull
    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getBasicAuthUsername() {
        return this.basicAuthUsername;
    }

    @Generated
    public String getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    @Generated
    public String getEntity() {
        return this.entity;
    }

    @Generated
    public String getProxyUrl() {
        return this.proxyUrl;
    }

    @Generated
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Generated
    public int getMaximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public static abstract class HttpExecutionRequestBuilder<C extends HttpExecutionRequest, B extends HttpExecutionRequestBuilder<C, B>> {
        @Generated
        private HttpClient httpClient;
        @Generated
        private HttpMethod method;
        @Generated
        private String url;
        @Generated
        private String basicAuthUsername;
        @Generated
        private String basicAuthPassword;
        @Generated
        private String entity;
        @Generated
        private String proxyUrl;
        @Generated
        private String bearerToken;
        @Generated
        private boolean maximumRetryAttempts$set;
        @Generated
        private int maximumRetryAttempts$value;
        @Generated
        private boolean parameters$set;
        @Generated
        private Map<String, String> parameters$value;
        @Generated
        private boolean headers$set;
        @Generated
        private Map<String, String> headers$value;

        @Generated
        public B httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this.self();
        }

        @Generated
        public B method(@NonNull HttpMethod method) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.method = method;
            return this.self();
        }

        @Generated
        public B url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this.self();
        }

        @Generated
        public B basicAuthUsername(String basicAuthUsername) {
            this.basicAuthUsername = basicAuthUsername;
            return this.self();
        }

        @Generated
        public B basicAuthPassword(String basicAuthPassword) {
            this.basicAuthPassword = basicAuthPassword;
            return this.self();
        }

        @Generated
        public B entity(String entity) {
            this.entity = entity;
            return this.self();
        }

        @Generated
        public B proxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
            return this.self();
        }

        @Generated
        public B bearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this.self();
        }

        @Generated
        public B maximumRetryAttempts(int maximumRetryAttempts) {
            this.maximumRetryAttempts$value = maximumRetryAttempts;
            this.maximumRetryAttempts$set = true;
            return this.self();
        }

        @Generated
        public B parameters(Map<String, String> parameters) {
            this.parameters$value = parameters;
            this.parameters$set = true;
            return this.self();
        }

        @Generated
        public B headers(Map<String, String> headers) {
            this.headers$value = headers;
            this.headers$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "HttpExecutionRequest.HttpExecutionRequestBuilder(httpClient=" + String.valueOf(this.httpClient) + ", method=" + String.valueOf(this.method) + ", url=" + this.url + ", basicAuthUsername=" + this.basicAuthUsername + ", basicAuthPassword=" + this.basicAuthPassword + ", entity=" + this.entity + ", proxyUrl=" + this.proxyUrl + ", bearerToken=" + this.bearerToken + ", maximumRetryAttempts$value=" + this.maximumRetryAttempts$value + ", parameters$value=" + String.valueOf(this.parameters$value) + ", headers$value=" + String.valueOf(this.headers$value) + ")";
        }
    }

    @Generated
    private static final class HttpExecutionRequestBuilderImpl
    extends HttpExecutionRequestBuilder<HttpExecutionRequest, HttpExecutionRequestBuilderImpl> {
        @Generated
        private HttpExecutionRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected HttpExecutionRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public HttpExecutionRequest build() {
            return new HttpExecutionRequest(this);
        }
    }
}

