/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.cfg.standalone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.cfg.TransactionContext;
import org.flowable.common.engine.impl.cfg.TransactionListener;
import org.flowable.common.engine.impl.cfg.TransactionPropagation;
import org.flowable.common.engine.impl.cfg.TransactionState;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneMybatisTransactionContext
implements TransactionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneMybatisTransactionContext.class);
    protected CommandContext commandContext;
    protected DbSqlSession dbSqlSession;
    protected Map<TransactionState, List<TransactionListener>> stateTransactionListeners;

    public StandaloneMybatisTransactionContext(CommandContext commandContext) {
        this.commandContext = commandContext;
        this.dbSqlSession = Context.getCommandContext().getSession(DbSqlSession.class);
    }

    @Override
    public void addTransactionListener(TransactionState transactionState, TransactionListener transactionListener) {
        List<TransactionListener> transactionListeners;
        if (this.stateTransactionListeners == null) {
            this.stateTransactionListeners = new HashMap<TransactionState, List<TransactionListener>>();
        }
        if ((transactionListeners = this.stateTransactionListeners.get((Object)transactionState)) == null) {
            transactionListeners = new ArrayList<TransactionListener>();
            this.stateTransactionListeners.put(transactionState, transactionListeners);
        }
        transactionListeners.add(transactionListener);
    }

    @Override
    public void commit() {
        LOGGER.debug("firing event committing...");
        this.fireTransactionEvent(TransactionState.COMMITTING, false);
        LOGGER.debug("committing the ibatis sql session...");
        this.dbSqlSession.commit();
        LOGGER.debug("firing event committed...");
        this.fireTransactionEvent(TransactionState.COMMITTED, true);
    }

    protected void fireTransactionEvent(TransactionState transactionState, boolean executeInNewContext) {
        if (this.stateTransactionListeners == null) {
            return;
        }
        final List<TransactionListener> transactionListeners = this.stateTransactionListeners.get((Object)transactionState);
        if (transactionListeners == null) {
            return;
        }
        if (executeInNewContext) {
            CommandExecutor commandExecutor = Context.getCommandContext().getCommandExecutor();
            CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
            commandExecutor.execute(commandConfig, new Command<Void>(){

                @Override
                public Void execute(CommandContext commandContext) {
                    StandaloneMybatisTransactionContext.this.executeTransactionListeners(transactionListeners, commandContext);
                    return null;
                }
            });
        } else {
            this.executeTransactionListeners(transactionListeners, this.commandContext);
        }
    }

    protected void executeTransactionListeners(List<TransactionListener> transactionListeners, CommandContext commandContext) {
        for (TransactionListener transactionListener : transactionListeners) {
            transactionListener.execute(commandContext);
        }
    }

    @Override
    public void rollback() {
        block10: {
            try {
                try {
                    LOGGER.debug("firing event rolling back...");
                    this.fireTransactionEvent(TransactionState.ROLLINGBACK, false);
                }
                catch (Throwable exception) {
                    try {
                        LOGGER.info("Exception during transaction: {}", (Object)exception.getMessage());
                        this.commandContext.exception(exception);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        LOGGER.debug("rolling back ibatis sql session...");
                        this.dbSqlSession.rollback();
                    }
                }
                LOGGER.debug("rolling back ibatis sql session...");
                this.dbSqlSession.rollback();
            }
            catch (Throwable exception) {
                LOGGER.info("Exception during transaction: {}", (Object)exception.getMessage());
                this.commandContext.exception(exception);
            }
            finally {
                LOGGER.debug("firing event rolled back...");
                this.fireTransactionEvent(TransactionState.ROLLED_BACK, true);
            }
        }
    }
}

