/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.clients;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviderFactory;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientsEndpointContributor;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.pac4j.core.client.BaseClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="delegatedClients", defaultAccess=Access.NONE)
public class DelegatedClientsEndpoint
extends BaseCasActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientsEndpoint.class);
    private final ObjectProvider<DelegatedIdentityProviderFactory> clientFactory;
    private final ObjectProvider<List<DelegatedClientsEndpointContributor>> delegatedClientsEndpointContributors;

    public DelegatedClientsEndpoint(CasConfigurationProperties casProperties, ObjectProvider<DelegatedIdentityProviderFactory> clientFactory, ObjectProvider<List<DelegatedClientsEndpointContributor>> delegatedClientsEndpointContributors) {
        super(casProperties);
        this.clientFactory = clientFactory;
        this.delegatedClientsEndpointContributors = delegatedClientsEndpointContributors;
    }

    @DeleteOperation
    @Operation(summary="Clear loaded identity providers and rebuild from CAS configuration or other sources.")
    public Map<String, Map<String, Object>> reload() {
        Collection currentClients = ((DelegatedIdentityProviderFactory)this.clientFactory.getObject()).rebuild();
        return this.buildClientMap(currentClients);
    }

    @ReadOperation
    @Operation(summary="Load delegated identity provider clients from the configuration")
    public Map<String, Map<String, Object>> getClients() {
        Collection currentClients = ((DelegatedIdentityProviderFactory)this.clientFactory.getObject()).build();
        return this.buildClientMap(currentClients);
    }

    private Map<String, Map<String, Object>> buildClientMap(Collection<BaseClient> currentClients) {
        TreeMap<String, Map<String, Object>> clientsMap = new TreeMap<String, Map<String, Object>>();
        currentClients.forEach(client -> this.delegatedClientsEndpointContributors.ifAvailable(contributors -> contributors.stream().filter(contributor -> contributor.supports((BaseClient)client)).forEach(contributor -> clientsMap.put(client.getName(), contributor.contribute((BaseClient)client)))));
        return clientsMap;
    }
}

