/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.ApiException;
import org.apache.syncope.ext.openfga.client.ApiResponse;
import org.apache.syncope.ext.openfga.client.Configuration;
import org.apache.syncope.ext.openfga.client.Pair;
import org.apache.syncope.ext.openfga.client.model.ReadAuthorizationModelResponse;
import org.apache.syncope.ext.openfga.client.model.ReadAuthorizationModelsResponse;
import org.apache.syncope.ext.openfga.client.model.WriteAuthorizationModelRequest;
import org.apache.syncope.ext.openfga.client.model.WriteAuthorizationModelResponse;

public class AuthorizationModelsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<InputStream>> memberVarAsyncResponseInterceptor;

    public AuthorizationModelsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationModelsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = null;
        try (InputStream responseBody = ApiClient.getResponseBody(response);){
            body = responseBody == null ? null : new String(responseBody.readAllBytes());
        }
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public File downloadFileFromResponse(HttpResponse<InputStream> response, InputStream responseBody) throws ApiException {
        if (responseBody == null) {
            throw new ApiException(new IOException("Response body is empty"));
        }
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy(responseBody, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private File prepareDownloadFile(HttpResponse<InputStream> response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        Optional<String> contentDisposition = response.headers().firstValue("Content-Disposition");
        if (contentDisposition.isPresent() && !"".equals(contentDisposition.get()) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition.get())).find()) {
            filename = matcher.group(1);
        }
        File file = null;
        if (filename != null) {
            Path tempDir = Files.createTempDirectory("swagger-gen-native", new FileAttribute[0]);
            Path filePath = Files.createFile(tempDir.resolve(filename), new FileAttribute[0]);
            file = filePath.toFile();
            tempDir.toFile().deleteOnExit();
            file.deleteOnExit();
        } else {
            file = Files.createTempFile("download-", "", new FileAttribute[0]).toFile();
            file.deleteOnExit();
        }
        return file;
    }

    public ReadAuthorizationModelResponse readAuthorizationModel(@Nonnull String storeId, @Nonnull String id) throws ApiException {
        return this.readAuthorizationModel(storeId, id, null);
    }

    public ReadAuthorizationModelResponse readAuthorizationModel(@Nonnull String storeId, @Nonnull String id, Map<String, String> headers) throws ApiException {
        ApiResponse<ReadAuthorizationModelResponse> localVarResponse = this.readAuthorizationModelWithHttpInfo(storeId, id, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<ReadAuthorizationModelResponse> readAuthorizationModelWithHttpInfo(@Nonnull String storeId, @Nonnull String id) throws ApiException {
        return this.readAuthorizationModelWithHttpInfo(storeId, id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<ReadAuthorizationModelResponse> readAuthorizationModelWithHttpInfo(@Nonnull String storeId, @Nonnull String id, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.readAuthorizationModelRequestBuilder(storeId, id, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("readAuthorizationModel", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                ReadAuthorizationModelResponse responseValue = responseBody.isBlank() ? null : (ReadAuthorizationModelResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ReadAuthorizationModelResponse>(this){});
                ApiResponse<ReadAuthorizationModelResponse> apiResponse = new ApiResponse<ReadAuthorizationModelResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder readAuthorizationModelRequestBuilder(@Nonnull String storeId, @Nonnull String id, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling readAuthorizationModel");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling readAuthorizationModel");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/authorization-models/{id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString())).replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ReadAuthorizationModelsResponse readAuthorizationModels(@Nonnull String storeId, @Nullable Integer pageSize, @Nullable String continuationToken) throws ApiException {
        return this.readAuthorizationModels(storeId, pageSize, continuationToken, null);
    }

    public ReadAuthorizationModelsResponse readAuthorizationModels(@Nonnull String storeId, @Nullable Integer pageSize, @Nullable String continuationToken, Map<String, String> headers) throws ApiException {
        ApiResponse<ReadAuthorizationModelsResponse> localVarResponse = this.readAuthorizationModelsWithHttpInfo(storeId, pageSize, continuationToken, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<ReadAuthorizationModelsResponse> readAuthorizationModelsWithHttpInfo(@Nonnull String storeId, @Nullable Integer pageSize, @Nullable String continuationToken) throws ApiException {
        return this.readAuthorizationModelsWithHttpInfo(storeId, pageSize, continuationToken, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<ReadAuthorizationModelsResponse> readAuthorizationModelsWithHttpInfo(@Nonnull String storeId, @Nullable Integer pageSize, @Nullable String continuationToken, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.readAuthorizationModelsRequestBuilder(storeId, pageSize, continuationToken, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("readAuthorizationModels", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                ReadAuthorizationModelsResponse responseValue = responseBody.isBlank() ? null : (ReadAuthorizationModelsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ReadAuthorizationModelsResponse>(this){});
                ApiResponse<ReadAuthorizationModelsResponse> apiResponse = new ApiResponse<ReadAuthorizationModelsResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder readAuthorizationModelsRequestBuilder(@Nonnull String storeId, @Nullable Integer pageSize, @Nullable String continuationToken, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling readAuthorizationModels");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/authorization-models".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page_size";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page_size", pageSize));
        localVarQueryParameterBaseName = "continuation_token";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("continuation_token", continuationToken));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public WriteAuthorizationModelResponse writeAuthorizationModel(@Nonnull String storeId, @Nonnull WriteAuthorizationModelRequest body) throws ApiException {
        return this.writeAuthorizationModel(storeId, body, null);
    }

    public WriteAuthorizationModelResponse writeAuthorizationModel(@Nonnull String storeId, @Nonnull WriteAuthorizationModelRequest body, Map<String, String> headers) throws ApiException {
        ApiResponse<WriteAuthorizationModelResponse> localVarResponse = this.writeAuthorizationModelWithHttpInfo(storeId, body, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<WriteAuthorizationModelResponse> writeAuthorizationModelWithHttpInfo(@Nonnull String storeId, @Nonnull WriteAuthorizationModelRequest body) throws ApiException {
        return this.writeAuthorizationModelWithHttpInfo(storeId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<WriteAuthorizationModelResponse> writeAuthorizationModelWithHttpInfo(@Nonnull String storeId, @Nonnull WriteAuthorizationModelRequest body, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.writeAuthorizationModelRequestBuilder(storeId, body, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("writeAuthorizationModel", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                WriteAuthorizationModelResponse responseValue = responseBody.isBlank() ? null : (WriteAuthorizationModelResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<WriteAuthorizationModelResponse>(this){});
                ApiResponse<WriteAuthorizationModelResponse> apiResponse = new ApiResponse<WriteAuthorizationModelResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder writeAuthorizationModelRequestBuilder(@Nonnull String storeId, @Nonnull WriteAuthorizationModelRequest body, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling writeAuthorizationModel");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling writeAuthorizationModel");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/authorization-models".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    private static class HttpRequestBuilderExtensions {
        private HttpRequestBuilderExtensions() {
        }

        static HttpRequest.Builder withAdditionalHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            return builder;
        }
    }
}

