/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.InterBrokerSendThread;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t%v!B\u00181\u0011\u00039d!B\u001d1\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011\u0005bB\"\u0002\u0005\u0004%I\u0001\u0012\u0005\u0007\u001b\u0006\u0001\u000b\u0011B#\t\u000f9\u000b!\u0019!C\u0005\t\"1q*\u0001Q\u0001\n\u0015C\u0001\u0002U\u0001C\u0002\u0013\u0005\u0001'\u0015\u0005\u00075\u0006\u0001\u000b\u0011\u0002*\t\u000bm\u000bA\u0011\u0001/\u0007\te\u0002\u0004A\u0018\u0005\te*\u0011\t\u0011)A\u0005g\"A\u0001P\u0003B\u0001B\u0003%\u0011\u0010\u0003\u0005}\u0015\t\u0005\t\u0015!\u0003~\u0011)\t9A\u0003B\u0001B\u0003%\u0011\u0011\u0002\u0005\u000b\u0003\u001fQ!\u0011!Q\u0001\n\u0005E\u0001BB!\u000b\t\u0003\ty\u0002C\u0005\u0002,)\u0011\r\u0011\"\u0003\u0002.!A\u00111\b\u0006!\u0002\u0013\ty\u0003C\u0005\u0002>)\u0011\r\u0011\"\u0003\u0002@!A\u0011Q\n\u0006!\u0002\u0013\t\t\u0005C\u0005\u0002P)\u0011\r\u0011\"\u0003\u0002R!A\u00111\u000e\u0006!\u0002\u0013\t\u0019\u0006C\u0005\u0002n)\u0011\r\u0011\"\u0003\u0002p!A\u0011\u0011\u000f\u0006!\u0002\u0013\t)\u0007C\u0005\u0002t)\u0011\r\u0011\"\u0003\u0002v!A\u0011\u0011\u0012\u0006!\u0002\u0013\t9\bC\u0005\u0002\f*\u0011\r\u0011\"\u0003\u0002\u000e\"A\u0011\u0011\u0016\u0006!\u0002\u0013\ty\tC\u0005\u0002,*\u0011\r\u0011\"\u0003\u0002.\"A\u0011Q\u0017\u0006!\u0002\u0013\ty\u000bC\u0004\u00028*!\t%!/\t\u000f\u0005\u0005'\u0002\"\u0003\u0002:\"A\u00111\u0019\u0006\u0005\u0002A\n)\r\u0003\u0005\u0002R*!\t\u0001MA8\u0011!\t\u0019N\u0003C\u0001a\u0005U\u0007bBAy\u0015\u0011%\u0011\u0011\u0018\u0005\b\u0003gTA\u0011IA{\u0011\u001d\u0011)A\u0003C\u0005\u0005\u000fAqA!\u0004\u000b\t\u0003\u0011y\u0001C\u0004\u0003:)!\tAa\u000f\t\u000f\tu\"\u0002\"\u0003\u0003@!9!\u0011\n\u0006\u0005\u0002\t-\u0003b\u0002B)\u0015\u0011%!1\u000b\u0005\b\u00053RA\u0011\u0001B.\u0011\u001d\u0011iH\u0003C\u0001\u0005\u007fBqA!\"\u000b\t\u0003\u00119)A\u0010Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJT!!\r\u001a\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003gQ\n1bY8pe\u0012Lg.\u0019;pe*\tQ'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005a\nQ\"\u0001\u0019\u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'o\u0005\u0002\u0002wA\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001c\u0002KUs7N\\8x]\u0012+7\u000f^5oCRLwN\\)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,W#A#\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015\u0001\u00027b]\u001eT\u0011AS\u0001\u0005U\u00064\u0018-\u0003\u0002M\u000f\n11\u000b\u001e:j]\u001e\fa%\u00168l]><h\u000eR3ti&t\u0017\r^5p]F+X-^3TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003\u0005bunZ!qa\u0016tGMU3uef\fV/Z;f'&TX-T3ue&\u001cg*Y7f\u0003\tbunZ!qa\u0016tGMU3uef\fV/Z;f'&TX-T3ue&\u001cg*Y7fA\u0005YQ*\u001a;sS\u000et\u0015-\\3t+\u0005\u0011\u0006cA*Y\u000b6\tAK\u0003\u0002V-\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003/v\n!bY8mY\u0016\u001cG/[8o\u0013\tIFKA\u0002TKR\fA\"T3ue&\u001cg*Y7fg\u0002\nQ!\u00199qYf$R\"\u0018BF\u0005\u001b\u0013IJa'\u0003\u001e\n}\u0005C\u0001\u001d\u000b'\rQq\f\u001c\t\u0003A*l\u0011!\u0019\u0006\u0003E\u000e\fA!\u001e;jY*\u0011A-Z\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005U2'BA4i\u0003\u0019\t\u0007/Y2iK*\t\u0011.A\u0002pe\u001eL!a[1\u0003+%sG/\u001a:Ce>\\WM]*f]\u0012$\u0006N]3bIB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eN\u0001\u0006kRLGn]\u0005\u0003c:\u0014q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003iZl\u0011!\u001e\u0006\u0003IRJ!a^;\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005QT\u0018BA>v\u00055iU\r^1eCR\f7)Y2iK\u0006ia.\u001a;x_J\\7\t\\5f]R\u00042A`A\u0002\u001b\u0005y(bAA\u0001K\u000691\r\\5f]R\u001c\u0018bAA\u0003\u007f\nia*\u001a;x_J\\7\t\\5f]R\fq\u0002\u001e=o'R\fG/Z'b]\u0006<WM\u001d\t\u0004q\u0005-\u0011bAA\u0007a\t9BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM]\u0001\u0005i&lW\r\u0005\u0003\u0002\u0014\u0005mQBAA\u000b\u0015\ry\u0017q\u0003\u0006\u0004\u00033)\u0017AB2p[6|g.\u0003\u0003\u0002\u001e\u0005U!\u0001\u0002+j[\u0016$2\"XA\u0011\u0003G\t)#a\n\u0002*!)!\u000f\u0005a\u0001g\")\u0001\u0010\u0005a\u0001s\")A\u0010\u0005a\u0001{\"9\u0011q\u0001\tA\u0002\u0005%\u0001bBA\b!\u0001\u0007\u0011\u0011C\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003_\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003k\u0019\u0017aB7fiJL7m]\u0005\u0005\u0003s\t\u0019DA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013aF5oi\u0016\u0014(I]8lKJd\u0015n\u001d;f]\u0016\u0014h*Y7f+\t\t\t\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\u0011\t9%a\u0006\u0002\u000f9,Go^8sW&!\u00111JA#\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003aIg\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s\u001d\u0006lW\rI\u0001\u0016[\u0006\u00148.\u001a:t#V,W/\u001a)fe\n\u0013xn[3s+\t\t\u0019\u0006\u0005\u0005\u0002V\u0005m\u0013qLA3\u001b\t\t9FC\u0002\u0002ZY\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\ti&a\u0016\u0003\u00075\u000b\u0007\u000fE\u0002=\u0003CJ1!a\u0019>\u0005\rIe\u000e\u001e\t\u0004q\u0005\u001d\u0014bAA5a\tqA\u000b\u001f8NCJ\\WM])vKV,\u0017AF7be.,'o])vKV,\u0007+\u001a:Ce>\\WM\u001d\u0011\u000295\f'o[3sgF+X-^3G_J,fn\u001b8po:\u0014%o\\6feV\u0011\u0011QM\u0001\u001e[\u0006\u00148.\u001a:t#V,W/\u001a$peVs7N\\8x]\n\u0013xn[3sA\u00051B\u000f\u001f8M_\u001e\f\u0005\u000f]3oIJ+GO]=Rk\u0016,X-\u0006\u0002\u0002xA1\u0011\u0011PA@\u0003\u0007k!!a\u001f\u000b\t\u0005e\u0013Q\u0010\u0006\u0003E&KA!!!\u0002|\t\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vKB\u0019\u0001(!\"\n\u0007\u0005\u001d\u0005G\u0001\nQK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017a\u0006;y]2{w-\u00119qK:$'+\u001a;ssF+X-^3!\u0003y!(/\u00198tC\u000e$\u0018n\u001c8t/&$\b\u000eU3oI&tw-T1sW\u0016\u00148/\u0006\u0002\u0002\u0010BA\u0011\u0011PAI\u0003+\u000b\u0019)\u0003\u0003\u0002\u0014\u0006m$!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u0011qSAS\u001d\u0011\tI*!)\u0011\u0007\u0005mU(\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014\u001c\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019+P\u0001\u0007!J,G-\u001a4\n\u00071\u000b9KC\u0002\u0002$v\nq\u0004\u001e:b]N\f7\r^5p]N<\u0016\u000e\u001e5QK:$\u0017N\\4NCJ\\WM]:!\u0003u9(/\u001b;f)btW*\u0019:lKJ\u001c(+Z9vKN$h+\u001a:tS>tWCAAX!\ra\u0014\u0011W\u0005\u0004\u0003gk$!B*i_J$\u0018AH<sSR,G\u000b\u001f8NCJ\\WM]:SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8!\u0003!\u0019\b.\u001e;e_^tGCAA^!\ra\u0014QX\u0005\u0004\u0003\u007fk$\u0001B+oSR\fQB]3n_Z,W*\u001a;sS\u000e\u001c\u0018AD9vKV,gi\u001c:Ce>\\WM\u001d\u000b\u0005\u0003\u000f\fi\rE\u0003=\u0003\u0013\f)'C\u0002\u0002Lv\u0012aa\u00149uS>t\u0007bBAhC\u0001\u0007\u0011qL\u0001\tEJ|7.\u001a:JI\u0006)\u0012/^3vK\u001a{'/\u00168l]><hN\u0011:pW\u0016\u0014\u0018aE1eI6\u000b'o[3sg\u001a{'O\u0011:pW\u0016\u0014H\u0003CA^\u0003/\f\u0019/a:\t\u000f\u0005e7\u00051\u0001\u0002\\\u00061!M]8lKJ\u0004B!!8\u0002`6\u0011\u0011qC\u0005\u0005\u0003C\f9B\u0001\u0003O_\u0012,\u0007bBAsG\u0001\u0007\u0011qL\u0001\u0012ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAuG\u0001\u0007\u00111^\u0001\u001ca\u0016tG-\u001b8h\u0007>l\u0007\u000f\\3uKRCh.\u00118e\u001b\u0006\u00148.\u001a:\u0011\u0007a\ni/C\u0002\u0002pB\u0012\u0001\u0005U3oI&twmQ8na2,G/\u001a+y]\u0006sG-T1sW\u0016\u0014XI\u001c;ss\u0006y!/\u001a;ss2{w-\u00119qK:$7/\u0001\thK:,'/\u0019;f%\u0016\fX/Z:ugR\u0011\u0011q\u001f\t\u0007\u0003s\fY0a@\u000e\u0005\u0005u\u0014\u0002BA\u007f\u0003{\u0012!bQ8mY\u0016\u001cG/[8o!\r\u0001'\u0011A\u0005\u0004\u0005\u0007\t'a\u0007*fcV,7\u000f^!oI\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'/\u0001\nxe&$X\r\u0016=o\u0007>l\u0007\u000f\\3uS>tG\u0003BA^\u0005\u0013AqAa\u0003'\u0001\u0004\t\u0019)\u0001\nqK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017aE1eIRCh.T1sW\u0016\u00148\u000fV8TK:$GCCA^\u0005#\u0011)B!\n\u00030!9!1C\u0014A\u0002\u0005}\u0013\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011\u001d\u00119b\na\u0001\u00053\t\u0011\u0002\u001e=o%\u0016\u001cX\u000f\u001c;\u0011\t\tm!\u0011E\u0007\u0003\u0005;QAAa\b\u0002\u0018\u0005A!/Z9vKN$8/\u0003\u0003\u0003$\tu!!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\"9!qE\u0014A\u0002\t%\u0012a\u0003;y]6+G/\u00193bi\u0006\u00042\u0001\u000fB\u0016\u0013\r\u0011i\u0003\r\u0002\u0014)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0005\b\u0005c9\u0003\u0019\u0001B\u001a\u0003-qWm^'fi\u0006$\u0017\r^1\u0011\u0007a\u0012)$C\u0002\u00038A\u0012!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\u0006Ib.^7Uq:\u001cx+\u001b;i!\u0016tG-\u001b8h\u001b\u0006\u00148.\u001a:t+\t\ty&\u0001\riCN\u0004VM\u001c3j]\u001el\u0015M]6feN$vn\u0016:ji\u0016$BA!\u0011\u0003HA\u0019AHa\u0011\n\u0007\t\u0015SHA\u0004C_>dW-\u00198\t\u000f\t\u001d\u0012\u00061\u0001\u0003*\u00059R.Y=cK^\u0013\u0018\u000e^3Uq:\u001cu.\u001c9mKRLwN\u001c\u000b\u0005\u0003w\u0013i\u0005C\u0004\u0003P)\u0002\r!!&\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\fa\u0002\u001e:z\u0003B\u0004XM\u001c3U_2{w\r\u0006\u0003\u0002<\nU\u0003b\u0002B,W\u0001\u0007\u00111Q\u0001\ribtGj\\4BaB,g\u000eZ\u0001\u001bC\u0012$G\u000b\u001f8NCJ\\WM]:U_\n\u0013xn[3s#V,W/\u001a\u000b\r\u0003w\u0013iFa\u001a\u0003l\t=$\u0011\u000f\u0005\b\u0005?b\u0003\u0019\u0001B1\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\t\u0004y\t\r\u0014b\u0001B3{\t!Aj\u001c8h\u0011\u001d\u0011I\u0007\fa\u0001\u0003_\u000bQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007b\u0002B7Y\u0001\u0007!\u0011D\u0001\u0007e\u0016\u001cX\u000f\u001c;\t\u000f\t-A\u00061\u0001\u0002\u0004\"9!1\u000f\u0017A\u0002\tU\u0014a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\tMC&q\u000f\t\u0005\u0003;\u0014I(\u0003\u0003\u0003|\u0005]!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\"e\u0016lwN^3NCJ\\WM]:G_J$\u0006P\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\u0005\u0003w\u0013\t\tC\u0004\u0003\u00046\u0002\r!a\u0018\u0002'QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u00133\u0002'I,Wn\u001c<f\u001b\u0006\u00148.\u001a:t\r>\u0014H\u000b\u001f8\u0015\t\u0005m&\u0011\u0012\u0005\b\u0005\u0017q\u0003\u0019AAB\u0011\u0015\u0011\u0018\u00021\u0001t\u0011\u001d\t)$\u0003a\u0001\u0005\u001f\u0003BA!%\u0003\u00166\u0011!1\u0013\u0006\u0005\u0003k\t9\"\u0003\u0003\u0003\u0018\nM%aB'fiJL7m\u001d\u0005\u0006q&\u0001\r!\u001f\u0005\b\u0003\u000fI\u0001\u0019AA\u0005\u0011\u001d\ty!\u0003a\u0001\u0003#AqA!)\n\u0001\u0004\u0011\u0019+\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004B!a\u0005\u0003&&!!qUA\u000b\u0005)aunZ\"p]R,\u0007\u0010\u001e")
public class TransactionMarkerChannelManager
extends InterBrokerSendThread
implements Logging {
    private final MetadataCache metadataCache;
    private final TransactionStateManager txnStateManager;
    private final Time time;
    private final KafkaMetricsGroup metricsGroup;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker;
    private final TxnMarkerQueue markersQueueForUnknownBroker;
    private final LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue;
    private final ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers;
    private final short writeTxnMarkersRequestVersion;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionMarkerChannelManager apply(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, TransactionStateManager txnStateManager, Time time, LogContext logContext) {
        return TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, txnStateManager, time, logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker() {
        return this.markersQueuePerBroker;
    }

    private TxnMarkerQueue markersQueueForUnknownBroker() {
        return this.markersQueueForUnknownBroker;
    }

    private LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue() {
        return this.txnLogAppendRetryQueue;
    }

    private ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers;
    }

    private short writeTxnMarkersRequestVersion() {
        return this.writeTxnMarkersRequestVersion;
    }

    public void shutdown() {
        try {
            super.shutdown();
            this.markersQueuePerBroker().clear();
        }
        finally {
            this.removeMetrics();
        }
    }

    private void removeMetrics() {
        TransactionMarkerChannelManager$.MODULE$.MetricNames().foreach((Function1 & Serializable)x$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<TxnMarkerQueue> queueForBroker(int brokerId) {
        return this.markersQueuePerBroker().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
    }

    public TxnMarkerQueue queueForUnknownBroker() {
        return this.markersQueueForUnknownBroker();
    }

    /*
     * WARNING - void declaration
     */
    public void addMarkersForBroker(Node broker, int txnTopicPartition, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        Object object;
        void atomicGetOrUpdate_key;
        int brokerId = broker.id();
        Integer n = BoxesRunTime.boxToInteger((int)brokerId);
        scala.collection.concurrent.Map<Object, TxnMarkerQueue> atomicGetOrUpdate_map = this.markersQueuePerBroker();
        Option option = atomicGetOrUpdate_map.get((Object)atomicGetOrUpdate_key);
        if (option instanceof Some) {
            object = ((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            TxnMarkerQueue atomicGetOrUpdate_value = TransactionMarkerChannelManager.$anonfun$addMarkersForBroker$1(this, brokerId, broker);
            object = atomicGetOrUpdate_map.putIfAbsent((Object)atomicGetOrUpdate_key, (Object)atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1(atomicGetOrUpdate_value));
        } else {
            throw new MatchError((Object)option);
        }
        Object var6_6 = null;
        n = null;
        option = null;
        Object var9_8 = null;
        TxnMarkerQueue brokerRequestQueue = (TxnMarkerQueue)object;
        brokerRequestQueue.destination_$eq(broker);
        brokerRequestQueue.addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Added marker ").append(pendingCompleteTxnAndMarker.txnMarkerEntry()).append(" for transactional id").append(" ").append(pendingCompleteTxnAndMarker.pendingCompleteTxn().transactionalId()).append(" to destination broker ").append(brokerId).toString());
    }

    private void retryLogAppends() {
        ArrayList txnLogAppendRetries = new ArrayList();
        this.txnLogAppendRetryQueue().drainTo(txnLogAppendRetries);
        txnLogAppendRetries.forEach(txnLogAppend -> {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Retry appending ").append(txnLogAppend).append(" transaction log").toString());
            this.tryAppendToLog((PendingCompleteTxn)txnLogAppend);
        });
    }

    public Collection<RequestAndCompletionHandler> generateRequests() {
        this.retryLogAppends();
        ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
        this.markersQueueForUnknownBroker().forEachTxnTopicPartition((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)x1$1.drainTo(pendingCompleteTxnAndMarkerEntries)));
        CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarkerEntries).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$2(check$ifrefutable$1))).foreach((Function1 & Serializable)pendingCompleteTxnAndMarker -> {
            TransactionMarkerChannelManager.$anonfun$generateRequests$3(this, pendingCompleteTxnAndMarker);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = this.time.milliseconds();
        return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOps)((IterableOps)this.markersQueuePerBroker().values().map((Function1 & Serializable)brokerRequestQueue -> {
            ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
            brokerRequestQueue.forEachTxnTopicPartition((Function2 & Serializable)(x0$2, x1$2) -> BoxesRunTime.boxToInteger((int)x1$2.drainTo(pendingCompleteTxnAndMarkerEntries)));
            return new Tuple2((Object)brokerRequestQueue.destination(), pendingCompleteTxnAndMarkerEntries);
        })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$generateRequests$6(x0$3)))).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                Node node = (Node)x0$4._1();
                ArrayList entries = (ArrayList)x0$4._2();
                List markersToSend = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala((List)entries).asScala().map((Function1 & Serializable)x$4 -> x$4.txnMarkerEntry())).asJava();
                TransactionMarkerRequestCompletionHandler requestCompletionHandler = new TransactionMarkerRequestCompletionHandler(node.id(), $this.txnStateManager, this, entries);
                WriteTxnMarkersRequest.Builder request = new WriteTxnMarkersRequest.Builder(this.writeTxnMarkersRequestVersion(), markersToSend);
                return new RequestAndCompletionHandler(currentTimeMs, node, (AbstractRequest.Builder)request, (RequestCompletionHandler)requestCompletionHandler);
            }
            throw new MatchError(null);
        })).asJavaCollection();
    }

    private void writeTxnCompletion(PendingCompleteTxn pendingCompleteTxn) {
        Option option;
        Errors errors;
        String transactionalId = pendingCompleteTxn.transactionalId();
        TransactionMetadata txnMetadata = pendingCompleteTxn.txnMetadata();
        TxnTransitMetadata newMetadata = pendingCompleteTxn.newMetadata();
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Completed sending transaction markers for ").append(transactionalId).append("; begin transition ").append("to ").append(newMetadata.txnState()).toString());
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("No longer the coordinator for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel appending ").append(newMetadata).append(" to transaction log").toString());
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(187).append("Loading the transaction partition that contains ").append(transactionalId).append(" while my ").append("current coordinator epoch is ").append(coordinatorEpoch).append("; so cancel appending ").append(newMetadata).append(" to ").append("transaction log since the loading process will continue the remaining work").toString());
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            throw new IllegalStateException(new StringBuilder(56).append("Unhandled error ").append(unexpectedError).append(" when fetching current transaction state").toString());
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(116).append("Sending ").append(transactionalId).append("'s transaction markers for ").append(txnMetadata).append(" with ").append("coordinator epoch ").append(coordinatorEpoch).append(" succeeded, trying to append complete transaction log now").toString());
                    this.tryAppendToLog(new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata));
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(178).append("The cached metadata ").append(txnMetadata).append(" has changed to ").append(epochAndMetadata).append(" after ").append("completed sending the markers with coordinator epoch ").append(coordinatorEpoch).append("; abort ").append("transiting the metadata to ").append(newMetadata).append(" as it may have been updated by another process").toString());
                return;
            }
        }
        if (bl2 && None$.MODULE$.equals(option = (Option)right.value())) {
            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", ").append("but there is no metadata in the cache; this is not expected").toString();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(either);
    }

    public void addTxnMarkersToSend(int coordinatorEpoch, TransactionResult txnResult, TransactionMetadata txnMetadata, TxnTransitMetadata newMetadata) {
        String transactionalId = txnMetadata.transactionalId();
        PendingCompleteTxn pendingCompleteTxn = new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata);
        PendingCompleteTxn prev = this.transactionsWithPendingMarkers().put(transactionalId, pendingCompleteTxn);
        if (prev != null) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Replaced an existing pending complete txn ").append(prev).append(" with ").append(pendingCompleteTxn).append(" while adding markers to send.").toString());
        }
        this.addTxnMarkersToBrokerQueue(txnMetadata.producerId(), txnMetadata.producerEpoch(), txnResult, pendingCompleteTxn, (Set<TopicPartition>)txnMetadata.topicPartitions().toSet());
        this.maybeWriteTxnCompletion(transactionalId);
    }

    public int numTxnsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers().size();
    }

    private boolean hasPendingMarkersToWrite(TransactionMetadata txnMetadata) {
        return BoxesRunTime.unboxToBoolean(txnMetadata.inLock((JFunction0.mcZ.sp & Serializable)() -> txnMetadata.topicPartitions().nonEmpty()));
    }

    public void maybeWriteTxnCompletion(String transactionalId) {
        Option$.MODULE$.apply((Object)this.transactionsWithPendingMarkers().get(transactionalId)).foreach((Function1 & Serializable)pendingCompleteTxn -> {
            TransactionMarkerChannelManager.$anonfun$maybeWriteTxnCompletion$1(this, transactionalId, pendingCompleteTxn);
            return BoxedUnit.UNIT;
        });
    }

    private void tryAppendToLog(PendingCompleteTxn txnLogAppend) {
        this.txnStateManager.appendTransactionToLog(txnLogAppend.transactionalId(), txnLogAppend.coordinatorEpoch(), txnLogAppend.newMetadata(), (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
            this.appendCallback$1(error, txnLogAppend);
            return BoxedUnit.UNIT;
        }, (Function1<Errors, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$tryAppendToLog$7(x$5)), RequestLocal$.MODULE$.NoCaching());
    }

    public void addTxnMarkersToBrokerQueue(long producerId, short producerEpoch, TransactionResult result, PendingCompleteTxn pendingCompleteTxn, Set<TopicPartition> topicPartitions) {
        int txnTopicPartition = this.txnStateManager.partitionFor(pendingCompleteTxn.transactionalId());
        Map partitionsByDestination = topicPartitions.groupBy((Function1 & Serializable)topicPartition -> $this.metadataCache.getPartitionLeaderEndpoint(topicPartition.topic(), topicPartition.partition(), this.interBrokerListenerName()));
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        partitionsByDestination.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$6 -> {
            if (x$6 != null) {
                Option broker = (Option)x$6._1();
                Set topicPartitions = (Set)x$6._2();
                if (broker != null && topicPartitions != null) {
                    if (broker instanceof Some) {
                        Node brokerNode = (Node)((Some)broker).value();
                        WriteTxnMarkersRequest.TxnMarkerEntry marker = new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topicPartitions.toList()).asJava());
                        PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker = new PendingCompleteTxnAndMarkerEntry(pendingCompleteTxn, marker);
                        Node node = brokerNode;
                        Node node2 = Node.noNode();
                        if (!(node != null ? !node.equals(node2) : node2 != null)) {
                            this.markersQueueForUnknownBroker().addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
                            return BoxedUnit.UNIT;
                        }
                        this.addMarkersForBroker(brokerNode, txnTopicPartition, pendingCompleteTxnAndMarker);
                        return BoxedUnit.UNIT;
                    }
                    if (None$.MODULE$.equals(broker)) {
                        Option option;
                        String transactionalId = pendingCompleteTxn.transactionalId();
                        boolean bl = false;
                        Right right = null;
                        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
                        if (either instanceof Left) {
                            Errors error = (Errors)((Left)either).value();
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(127).append("Encountered ").append(error).append(" trying to fetch transaction metadata for ").append(transactionalId).append(" with coordinator epoch ").append(coordinatorEpoch).append("; cancel sending markers to its partition leaders").toString());
                            return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                        }
                        if (either instanceof Right) {
                            bl = true;
                            right = (Right)either;
                            Option option2 = (Option)right.value();
                            if (option2 instanceof Some) {
                                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option2).value();
                                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(144).append("The cached metadata has changed to ").append(epochAndMetadata).append(" (old coordinator epoch is ").append(coordinatorEpoch).append(") since preparing to send markers; cancel sending markers to its partition leaders").toString());
                                    return BoxesRunTime.boxToBoolean((boolean)this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                                }
                                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(161).append("Couldn't find leader endpoint for partitions ").append(topicPartitions).append(" while trying to send transaction markers for ").append(transactionalId).append(", these partitions are likely deleted already and hence can be skipped").toString());
                                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                txnMetadata.inLock((JFunction0.mcV.sp & Serializable)() -> topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
                                    txnMetadata.removePartition(topicPartition);
                                    return BoxedUnit.UNIT;
                                }));
                                this.maybeWriteTxnCompletion(transactionalId);
                                return BoxedUnit.UNIT;
                            }
                        }
                        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
                            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError(either);
                    }
                    throw new MatchError((Object)broker);
                }
            }
            throw new MatchError(x$6);
        });
        this.wakeup();
    }

    public void removeMarkersForTxnTopicPartition(int txnTopicPartitionId) {
        this.markersQueueForUnknownBroker().removeMarkersForTxnTopicPartition(txnTopicPartitionId).foreach((Function1 & Serializable)queue -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1(this, txnTopicPartitionId, queue);
            return BoxedUnit.UNIT;
        });
        this.markersQueuePerBroker().foreach((Function1 & Serializable)x0$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$4(this, txnTopicPartitionId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void removeMarkersForTxn(PendingCompleteTxn pendingCompleteTxn) {
        String transactionalId = pendingCompleteTxn.transactionalId();
        if (!this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn)) {
            PendingCompleteTxn current = this.transactionsWithPendingMarkers().get(transactionalId);
            if (current != null) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Failed to remove pending marker entry ").append(current).append(" trying to remove ").append(pendingCompleteTxn).toString());
                return;
            }
            return;
        }
    }

    public final /* synthetic */ int kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$1() {
        return this.markersQueueForUnknownBroker().totalNumMarkers();
    }

    public final /* synthetic */ int kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$2() {
        return this.txnLogAppendRetryQueue().size();
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(TransactionMarkerChannelManager $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    public static final /* synthetic */ TxnMarkerQueue $anonfun$addMarkersForBroker$1(TransactionMarkerChannelManager $this, int brokerId$1, Node broker$1) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Creating new marker queue map to destination broker ").append(brokerId$1).toString());
        return new TxnMarkerQueue(broker$1);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(PendingCompleteTxnAndMarkerEntry check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$generateRequests$3(TransactionMarkerChannelManager $this, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        long producerId = pendingCompleteTxnAndMarker.txnMarkerEntry().producerId();
        short producerEpoch = pendingCompleteTxnAndMarker.txnMarkerEntry().producerEpoch();
        TransactionResult txnResult = pendingCompleteTxnAndMarker.txnMarkerEntry().transactionResult();
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        Set topicPartitions = CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarker.txnMarkerEntry().partitions()).asScala().toSet();
        $this.addTxnMarkersToBrokerQueue(producerId, producerEpoch, txnResult, pendingCompleteTxn, (Set<TopicPartition>)topicPartitions);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$6(Tuple2 x0$3) {
        if (x0$3 != null) {
            return !((ArrayList)x0$3._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeWriteTxnCompletion$1(TransactionMarkerChannelManager $this, String transactionalId$2, PendingCompleteTxn pendingCompleteTxn) {
        if (!$this.hasPendingMarkersToWrite(pendingCompleteTxn.txnMetadata()) && $this.transactionsWithPendingMarkers().remove(transactionalId$2, pendingCompleteTxn)) {
            $this.writeTxnCompletion(pendingCompleteTxn);
            return;
        }
    }

    private final void appendCallback$1(Errors error, PendingCompleteTxn txnLogAppend$2) {
        if (Errors.NONE.equals(error)) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Completed transaction for ").append(txnLogAppend$2.transactionalId()).append(" with coordinator epoch ").append(txnLogAppend$2.coordinatorEpoch()).append(", final state after commit: ").append(txnLogAppend$2.txnMetadata().state()).toString());
            return;
        }
        if (Errors.NOT_COORDINATOR.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(122).append("No longer the coordinator for transactionalId: ").append(txnLogAppend$2.transactionalId()).append(" while trying to append to transaction log, skip writing to transaction log").toString());
            return;
        }
        if (Errors.COORDINATOR_NOT_AVAILABLE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Not available to append ").append(txnLogAppend$2).append(": possible causes include ").append(Errors.UNKNOWN_TOPIC_OR_PARTITION).append(", ").append(Errors.NOT_ENOUGH_REPLICAS).append(", ").append(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND).append(" and ").append(Errors.REQUEST_TIMED_OUT).append("; retry appending").toString());
            this.txnLogAppendRetryQueue().add(txnLogAppend$2);
            return;
        }
        if (Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(149).append("Coordinator is loading the partition ").append($this.txnStateManager.partitionFor(txnLogAppend$2.transactionalId())).append(" and hence cannot complete append of ").append(txnLogAppend$2).append("; ").append("skip writing to transaction log as the loading process should complete it").toString());
            return;
        }
        if (error != null) {
            String errorMsg = new StringBuilder(57).append("Unexpected error ").append(error.exceptionName()).append(" while appending to transaction log for ").append(txnLogAppend$2.transactionalId()).toString();
            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$tryAppendToLog$7(Errors x$5) {
        Errors errors = x$5;
        Errors errors2 = Errors.COORDINATOR_NOT_AVAILABLE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$addTxnMarkersToBrokerQueue$2(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            Option broker = (Option)check$ifrefutable$2._1();
            Set topicPartitions = (Set)check$ifrefutable$2._2();
            if (broker != null && topicPartitions != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$2(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Removing ").append(entry).append(" for txn partition ").append(txnTopicPartitionId$1).append(" to destination broker -1").toString());
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$1(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().foreach((Function1 & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$2($this, txnTopicPartitionId$1, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$6(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Removing ").append(entry).append(" for txn partition ").append(txnTopicPartitionId$1).append(" to destination broker ").append(brokerId$2).toString());
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$5(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)queue).asScala().foreach((Function1 & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$6($this, txnTopicPartitionId$1, brokerId$2, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$4(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int brokerId = x0$1._1$mcI$sp();
            ((TxnMarkerQueue)x0$1._2()).removeMarkersForTxnTopicPartition(txnTopicPartitionId$1).foreach((Function1 & Serializable)queue -> {
                TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, txnTopicPartitionId$1, brokerId, queue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public TransactionMarkerChannelManager(KafkaConfig config, MetadataCache metadataCache, NetworkClient networkClient, TransactionStateManager txnStateManager, Time time) {
        this.metadataCache = metadataCache;
        this.txnStateManager = txnStateManager;
        this.time = time;
        super(new StringBuilder(22).append("TxnMarkerSenderThread-").append(config.brokerId()).toString(), (KafkaClient)networkClient, Predef$.MODULE$.Integer2int(config.requestTimeoutMs()), time);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.logIdent_$eq(new StringBuilder(39).append("[Transaction Marker Channel Manager ").append(config.brokerId()).append("]: ").toString());
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.markersQueuePerBroker = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.markersQueueForUnknownBroker = new TxnMarkerQueue(Node.noNode());
        this.txnLogAppendRetryQueue = new LinkedBlockingQueue();
        this.transactionsWithPendingMarkers = new ConcurrentHashMap();
        this.writeTxnMarkersRequestVersion = config.interBrokerProtocolVersion().isAtLeast(MetadataVersion.IBP_2_8_IV0) ? (short)1 : 0;
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$UnknownDestinationQueueSizeMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$LogAppendRetryQueueSizeMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TransactionMarkerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManager$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

