/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OAUTHBEARERBindRequestProperties;
import com.unboundid.ldap.sdk.OAUTHBEARERBindResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OAUTHBEARERBindRequest
extends SASLBindRequest {
    @NotNull
    public static final String OAUTHBEARER_MECHANISM_NAME = "OAUTHBEARER";
    private static final byte GS2_HEADER_DELIMITER = 44;
    private static final byte OAUTHBEARER_DELIMITER = 1;
    @NotNull
    private static final byte[] GS2_HEADER_ELEMENT_NO_CHANNEL_BINDING = StaticUtils.getBytes("n");
    @NotNull
    private static final byte[] GS2_HEADER_ELEMENT_AUTHZ_ID_PREFIX = StaticUtils.getBytes("a=");
    @NotNull
    private static final byte[] OAUTHBEARER_CRED_ELEMENT_ACCESS_TOKEN_PREFIX = StaticUtils.getBytes("auth=Bearer ");
    @NotNull
    private static final byte[] OAUTHBEARER_CRED_ELEMENT_SERVER_ADDRESS_PREFIX = StaticUtils.getBytes("host=");
    @NotNull
    private static final byte[] OAUTHBEARER_CRED_ELEMENT_SERVER_PORT_PREFIX = StaticUtils.getBytes("port=");
    @NotNull
    private static final byte[] OAUTHBEARER_CRED_ELEMENT_REQUEST_METHOD_PREFIX = StaticUtils.getBytes("mthd=");
    @NotNull
    private static final byte[] OAUTHBEARER_CRED_ELEMENT_REQUEST_PATH_PREFIX = StaticUtils.getBytes("path=");
    @NotNull
    private static final byte[] OAUTHBEARER_CRED_ELEMENT_REQUEST_POST_DATA_PREFIX = StaticUtils.getBytes("post=");
    @NotNull
    private static final byte[] OAUTHBEARER_CRED_ELEMENT_REQUEST_QUERY_STRING_PREFIX = StaticUtils.getBytes("qs=");
    @NotNull
    private static final ASN1OctetString DUMMY_REQUEST_CREDENTIALS = new ASN1OctetString(new byte[]{1});
    private static final long serialVersionUID = -1216152242833705618L;
    private volatile int messageID;
    @Nullable
    private final Integer serverPort;
    @NotNull
    private final Map<String, String> additionalKeyValuePairs;
    @NotNull
    private final String accessToken;
    @Nullable
    private final String authorizationID;
    @Nullable
    private final String requestMethod;
    @Nullable
    private final String requestPath;
    @Nullable
    private final String requestPostData;
    @Nullable
    private final String requestQueryString;
    @Nullable
    private final String serverAddress;

    public OAUTHBEARERBindRequest(@NotNull String accessToken, Control ... controls) {
        super(controls);
        Validator.ensureNotNullOrEmpty(accessToken, "OAUTHBEARERBindRequest.accessToken must not be null or empty.");
        this.accessToken = accessToken;
        this.authorizationID = null;
        this.serverAddress = null;
        this.serverPort = null;
        this.requestMethod = null;
        this.requestPath = null;
        this.requestPostData = null;
        this.requestQueryString = null;
        this.additionalKeyValuePairs = Collections.emptyMap();
        this.messageID = -1;
    }

    public OAUTHBEARERBindRequest(@NotNull OAUTHBEARERBindRequestProperties properties, Control ... controls) {
        super(controls);
        this.accessToken = properties.getAccessToken();
        this.authorizationID = properties.getAuthorizationID();
        this.serverAddress = properties.getServerAddress();
        this.serverPort = properties.getServerPort();
        this.requestMethod = properties.getRequestMethod();
        this.requestPath = properties.getRequestPath();
        this.requestPostData = properties.getRequestPostData();
        this.requestQueryString = properties.getRequestQueryString();
        this.additionalKeyValuePairs = Collections.unmodifiableMap(new LinkedHashMap<String, String>(properties.getAdditionalKeyValuePairs()));
        this.messageID = -1;
    }

    @Override
    @NotNull
    public String getSASLMechanismName() {
        return OAUTHBEARER_MECHANISM_NAME;
    }

    @NotNull
    public String getAccessToken() {
        return this.accessToken;
    }

    @Nullable
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Nullable
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Nullable
    public Integer getServerPort() {
        return this.serverPort;
    }

    @Nullable
    public String getRequestMethod() {
        return this.requestMethod;
    }

    @Nullable
    public String getRequestPath() {
        return this.requestPath;
    }

    @Nullable
    public String getRequestPostData() {
        return this.requestPostData;
    }

    @Nullable
    public String getRequestQueryString() {
        return this.requestQueryString;
    }

    @NotNull
    public Map<String, String> getAdditionalKeyValuePairs() {
        return this.additionalKeyValuePairs;
    }

    @Override
    @NotNull
    protected OAUTHBEARERBindResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        BindResult finalBindResult;
        this.setReferralDepth(depth);
        this.messageID = InternalSDKHelper.nextMessageID(connection);
        BindResult initialBindResult = this.sendBindRequest(connection, "", this.encodeCredentials(), this.getControls(), this.getResponseTimeoutMillis(connection));
        if (initialBindResult.getResultCode() != ResultCode.SASL_BIND_IN_PROGRESS) {
            return new OAUTHBEARERBindResult(initialBindResult);
        }
        try {
            this.messageID = InternalSDKHelper.nextMessageID(connection);
            finalBindResult = this.sendBindRequest(connection, "", DUMMY_REQUEST_CREDENTIALS, this.getControls(), this.getResponseTimeoutMillis(connection));
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            finalBindResult = new BindResult(e);
        }
        return new OAUTHBEARERBindResult(initialBindResult, finalBindResult);
    }

    @NotNull
    ASN1OctetString encodeCredentials() {
        ByteStringBuffer buffer = new ByteStringBuffer();
        buffer.append(GS2_HEADER_ELEMENT_NO_CHANNEL_BINDING);
        buffer.append((byte)44);
        if (this.authorizationID != null) {
            buffer.append(GS2_HEADER_ELEMENT_AUTHZ_ID_PREFIX);
            OAUTHBEARERBindRequest.escapeAuthorizationID(this.authorizationID, buffer);
        }
        buffer.append((byte)44);
        buffer.append((byte)1);
        buffer.append(OAUTHBEARER_CRED_ELEMENT_ACCESS_TOKEN_PREFIX);
        buffer.append(this.accessToken);
        buffer.append((byte)1);
        if (this.serverAddress != null) {
            buffer.append(OAUTHBEARER_CRED_ELEMENT_SERVER_ADDRESS_PREFIX);
            buffer.append(this.serverAddress);
            buffer.append((byte)1);
        }
        if (this.serverPort != null) {
            buffer.append(OAUTHBEARER_CRED_ELEMENT_SERVER_PORT_PREFIX);
            buffer.append(this.serverPort.toString());
            buffer.append((byte)1);
        }
        if (this.requestMethod != null) {
            buffer.append(OAUTHBEARER_CRED_ELEMENT_REQUEST_METHOD_PREFIX);
            buffer.append(this.requestMethod);
            buffer.append((byte)1);
        }
        if (this.requestPath != null) {
            buffer.append(OAUTHBEARER_CRED_ELEMENT_REQUEST_PATH_PREFIX);
            buffer.append(this.requestPath);
            buffer.append((byte)1);
        }
        if (this.requestPostData != null) {
            buffer.append(OAUTHBEARER_CRED_ELEMENT_REQUEST_POST_DATA_PREFIX);
            buffer.append(this.requestPostData);
            buffer.append((byte)1);
        }
        if (this.requestQueryString != null) {
            buffer.append(OAUTHBEARER_CRED_ELEMENT_REQUEST_QUERY_STRING_PREFIX);
            buffer.append(this.requestQueryString);
            buffer.append((byte)1);
        }
        for (Map.Entry<String, String> e : this.additionalKeyValuePairs.entrySet()) {
            buffer.append(e.getKey());
            buffer.append('=');
            buffer.append(e.getValue());
            buffer.append((byte)1);
        }
        return new ASN1OctetString(buffer.toByteArray());
    }

    private static void escapeAuthorizationID(@NotNull String authorizationID, @NotNull ByteStringBuffer buffer) {
        int length = authorizationID.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = authorizationID.charAt(i);
            switch (c) {
                case ',': {
                    buffer.append("=2C");
                    continue block4;
                }
                case '=': {
                    buffer.append("=3D");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
    }

    @Override
    @NotNull
    public OAUTHBEARERBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public OAUTHBEARERBindRequest duplicate(@Nullable Control[] controls) {
        OAUTHBEARERBindRequestProperties properties = new OAUTHBEARERBindRequestProperties(this);
        OAUTHBEARERBindRequest bindRequest = new OAUTHBEARERBindRequest(properties, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        bindRequest.setIntermediateResponseListener(this.getIntermediateResponseListener());
        bindRequest.setReferralDepth(this.getReferralDepth());
        bindRequest.setReferralConnector(this.getReferralConnectorInternal());
        return bindRequest;
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("OAUTHBEARERBindRequest(accessToken='{redacted}'");
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if (this.serverAddress != null) {
            buffer.append(", serverAddress='");
            buffer.append(this.serverAddress);
            buffer.append('\'');
        }
        if (this.serverPort != null) {
            buffer.append(", serverPort=");
            buffer.append(this.serverPort);
        }
        if (this.requestMethod != null) {
            buffer.append(", requestMethod='");
            buffer.append(this.requestMethod);
            buffer.append('\'');
        }
        if (this.requestPath != null) {
            buffer.append(", requestPath='");
            buffer.append(this.requestPath);
            buffer.append('\'');
        }
        if (this.requestPostData != null) {
            buffer.append(", requestPostData='{redacted}'");
        }
        if (this.requestQueryString != null) {
            buffer.append(", requestQueryString='");
            buffer.append(this.requestQueryString);
            buffer.append('\'');
        }
        if (!this.additionalKeyValuePairs.isEmpty()) {
            buffer.append(", additionalKeyValuePairs=[");
            Iterator<Map.Entry<String, String>> iterator = this.additionalKeyValuePairs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> e = iterator.next();
                buffer.append(" \"");
                buffer.append(e.getKey());
                buffer.append("\"=\"");
                buffer.append(e.getValue());
                buffer.append('\"');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append(" ]");
        }
        buffer.append(')');
    }

    @Override
    public void toCode(@NotNull List<String> lineList, @NotNull String requestID, int indentSpaces, boolean includeProcessing) {
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "OAUTHBEARERBindRequestProperties", requestID + "RequestProperties", "new OAUTHBEARERBindRequestProperties", ToCodeArgHelper.createString(this.accessToken, "Access Token"));
        if (this.authorizationID != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setAuthorizationID", ToCodeArgHelper.createString(this.authorizationID, null));
        }
        if (this.serverAddress != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setServerAddress", ToCodeArgHelper.createString(this.serverAddress, null));
        }
        if (this.serverPort != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setServerPort", ToCodeArgHelper.createInteger(this.serverPort.intValue(), null));
        }
        if (this.requestMethod != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setRequestMethod", ToCodeArgHelper.createString(this.requestMethod, null));
        }
        if (this.requestPath != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setRequestPath", ToCodeArgHelper.createString(this.requestPath, null));
        }
        if (this.requestPostData != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setRequestPostData", ToCodeArgHelper.createString(this.requestPostData, null));
        }
        if (this.requestQueryString != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setRequestQueryString", ToCodeArgHelper.createString(this.requestQueryString, null));
        }
        for (Map.Entry<String, String> e : this.additionalKeyValuePairs.entrySet()) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.addKeyValuePair", ToCodeArgHelper.createString(e.getKey(), null), ToCodeArgHelper.createString(e.getValue(), null));
        }
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(2);
        constructorArgs.add(ToCodeArgHelper.createRaw(requestID + "RequestProperties", null));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "OAUTHBEARERBindRequest", requestID + "Request", "new OAUTHBEARERBindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will " + "help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add("");
            lineList.add("OAUTHBEARERBindResult bindResult = new OAUTHBEARERBindResult(new BindResult(e));");
            lineList.add("String authorizationErrorCode = bindResult.getAuthorizationErrorCode();");
            lineList.add("Set<String> scopes = bindResult.getScopes();");
            lineList.add("String openIDConfigurationURL = bindResult.getOpenIDConfigurationURL();");
            lineList.add(indent + '}');
        }
    }
}

