/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.helpers;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ColorAndBackgroundBehavior
extends BootstrapBaseBehavior {
    private IModel<Color> colorModel;

    public ColorAndBackgroundBehavior(Color color) {
        this((IModel<Color>)Model.of((Serializable)((Object)color)));
    }

    public ColorAndBackgroundBehavior(IModel<Color> colorModel) {
        this.colorModel = colorModel;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass(tag, (ICssClassNameProvider)this.colorModel.getObject());
    }

    public ColorAndBackgroundBehavior color(Color color) {
        this.colorModel.setObject((Object)color);
        return this;
    }

    public ColorAndBackgroundBehavior color(IModel<Color> colorModel) {
        this.colorModel = colorModel;
        return this;
    }

    public Color getColor() {
        return (Color)this.colorModel.getObject();
    }

    public IModel<Color> getColorModel() {
        return this.colorModel;
    }

    public static ColorAndBackgroundBehavior primary() {
        return new ColorAndBackgroundBehavior(Color.Primary);
    }

    public static ColorAndBackgroundBehavior secondary() {
        return new ColorAndBackgroundBehavior(Color.Secondary);
    }

    public static ColorAndBackgroundBehavior success() {
        return new ColorAndBackgroundBehavior(Color.Success);
    }

    public static ColorAndBackgroundBehavior danger() {
        return new ColorAndBackgroundBehavior(Color.Danger);
    }

    public static ColorAndBackgroundBehavior warning() {
        return new ColorAndBackgroundBehavior(Color.Warning);
    }

    public static ColorAndBackgroundBehavior info() {
        return new ColorAndBackgroundBehavior(Color.Info);
    }

    public static ColorAndBackgroundBehavior light() {
        return new ColorAndBackgroundBehavior(Color.Light);
    }

    public static ColorAndBackgroundBehavior dark() {
        return new ColorAndBackgroundBehavior(Color.Dark);
    }

    public static enum Color implements ICssClassNameProvider
    {
        Primary("primary"),
        Secondary("secondary"),
        Success("success"),
        Danger("danger"),
        Warning("warning"),
        Info("info"),
        Light("light"),
        Dark("dark");

        private final String cssClassName;

        private Color(String value) {
            this.cssClassName = "text-bg-" + value;
        }

        @Override
        public String cssClassName() {
            return this.cssClassName;
        }
    }
}

