/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.entity.task;

import org.apache.syncope.common.lib.to.TaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.entity.task.LiveSyncTask;
import org.apache.syncope.core.persistence.api.entity.task.MacroTask;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;

public interface TaskUtils {
    public TaskType getType();

    public <T extends Task<T>> T newTask();

    public <E extends TaskExec<?>> E newTaskExec();

    default public <T extends TaskTO> T newTaskTO() {
        Class taskClass = this.getType().getToClass();
        try {
            return (T)((TaskTO)taskClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            return null;
        }
    }

    default public <T extends Task<T>> Class<T> taskClass() {
        Class result = null;
        switch (this.getType()) {
            case PROPAGATION: {
                result = PropagationTask.class;
                break;
            }
            case SCHEDULED: {
                result = SchedTask.class;
                break;
            }
            case LIVE_SYNC: {
                result = LiveSyncTask.class;
                break;
            }
            case PULL: {
                result = PullTask.class;
                break;
            }
            case PUSH: {
                result = PushTask.class;
                break;
            }
            case MACRO: {
                result = MacroTask.class;
                break;
            }
            case NOTIFICATION: {
                result = NotificationTask.class;
                break;
            }
        }
        return result;
    }

    public String getTaskStorage();

    public Class<? extends Task<?>> getTaskEntity();

    public String getTaskExecStorage();

    public Class<? extends TaskExec<?>> getTaskExecEntity();
}

