/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.panels.SCIMConfAccordionContainer;
import org.apache.syncope.client.console.panels.SCIMConfTabPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.common.lib.scim.SCIMComplexConf;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.syncope.common.lib.scim.SCIMUserAddressConf;
import org.apache.syncope.common.lib.scim.SCIMUserConf;
import org.apache.syncope.common.lib.scim.SCIMUserNameConf;
import org.apache.syncope.common.lib.scim.types.AddressCanonicalType;
import org.apache.syncope.common.lib.scim.types.EmailCanonicalType;
import org.apache.syncope.common.lib.scim.types.IMCanonicalType;
import org.apache.syncope.common.lib.scim.types.PhoneNumberCanonicalType;
import org.apache.syncope.common.lib.scim.types.PhotoCanonicalType;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCIMConfUserPanel
extends SCIMConfTabPanel {
    protected static final Logger LOG = LoggerFactory.getLogger(SCIMConfUserPanel.class);
    private static final long serialVersionUID = 8747864142447220523L;
    private final SCIMUserConf scimUserConf;

    public SCIMConfUserPanel(String id, SCIMConf scimConf) {
        super(id);
        if (scimConf.getUserConf() == null) {
            scimConf.setUserConf(new SCIMUserConf());
        }
        if (scimConf.getUserConf().getName() == null) {
            scimConf.getUserConf().setName(new SCIMUserNameConf());
        }
        this.scimUserConf = scimConf.getUserConf();
        AjaxTextFieldPanel externalIdPanel = new AjaxTextFieldPanel("externalId", "externalId", (IModel)new PropertyModel<String>((Object)"externalId", "externalId"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getExternalId();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.setExternalId(object);
            }
        });
        externalIdPanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel displayNamePanel = new AjaxTextFieldPanel("displayName", "displayName", (IModel)new PropertyModel<String>((Object)"displayName", "displayName"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getDisplayName();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.setDisplayName(object);
            }
        });
        displayNamePanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel localePanel = new AjaxTextFieldPanel("locale", "locale", (IModel)new PropertyModel<String>((Object)"locale", "locale"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getLocale();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.setLocale(object);
            }
        });
        localePanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel nickNamePanel = new AjaxTextFieldPanel("nickName", "nickName", (IModel)new PropertyModel<String>((Object)"nickName", "nickName"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getNickName();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.setNickName(object);
            }
        });
        nickNamePanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel preferredLanguagePanel = new AjaxTextFieldPanel("preferredLanguage", "preferredLanguage", (IModel)new PropertyModel<String>((Object)"preferredLanguage", "preferredLanguage"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getPreferredLanguage();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.setPreferredLanguage(object);
            }
        });
        preferredLanguagePanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel profileUrlPanel = new AjaxTextFieldPanel("profileUrl", "profileUrl", (IModel)new PropertyModel<String>((Object)"profileUrl", "profileUrl"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getProfileUrl();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.setProfileUrl(object);
            }
        });
        profileUrlPanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel timezonePanel = new AjaxTextFieldPanel("timezone", "timezone", (IModel)new PropertyModel<String>((Object)"timezone", "timezone"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getTimezone();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.setTimezone(object);
            }
        });
        timezonePanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel titlePanel = new AjaxTextFieldPanel("title", "title", (IModel)new PropertyModel<String>((Object)"title", "title"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getTitle();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.setTitle(object);
            }
        });
        titlePanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel userTypePanel = new AjaxTextFieldPanel("userType", "userType", (IModel)new PropertyModel<String>((Object)"userType", "userType"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getUserType();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.setUserType(object);
            }
        });
        userTypePanel.setChoices((List)this.userPlainSchemas.getObject());
        this.buildNameAccordion();
        AjaxTextFieldPanel x509CertificatesPanel = new AjaxTextFieldPanel("panel", "x509CertificatesPanel", (IModel)new Model(null));
        x509CertificatesPanel.setChoices((List)this.userPlainSchemas.getObject());
        MultiFieldPanel x509CertificatesMultiPanel = new MultiFieldPanel.Builder((IModel)new ListModel(this.scimUserConf.getX509Certificates())).build("x509Certificates", "x509Certificates", (FieldPanel)x509CertificatesPanel);
        ArrayList<SCIMUserAddressConf> addresses = new ArrayList<SCIMUserAddressConf>();
        for (AddressCanonicalType canonicalType : AddressCanonicalType.values()) {
            SCIMUserAddressConf address = this.scimUserConf.getAddresses().stream().filter(addressConf -> addressConf.getType().equals((Object)canonicalType)).findFirst().orElseGet(() -> {
                SCIMUserAddressConf empty = new SCIMUserAddressConf();
                empty.setType(canonicalType);
                return empty;
            });
            this.buildAddressAccordion(address, canonicalType);
            addresses.add(address);
        }
        this.scimUserConf.getAddresses().clear();
        this.scimUserConf.getAddresses().addAll(addresses);
        this.buildComplexPanels(this.scimUserConf.getEmails(), "emailsAccordion", "emails", (Enum[])EmailCanonicalType.values());
        this.buildComplexPanels(this.scimUserConf.getPhoneNumbers(), "phoneNumbersAccordion", "phoneNumbers", (Enum[])PhoneNumberCanonicalType.values());
        this.buildComplexPanels(this.scimUserConf.getIms(), "imsAccordion", "ims", (Enum[])IMCanonicalType.values());
        this.buildComplexPanels(this.scimUserConf.getPhotos(), "photosAccordion", "photos", (Enum[])PhotoCanonicalType.values());
        this.add(new Component[]{externalIdPanel});
        this.add(new Component[]{displayNamePanel});
        this.add(new Component[]{localePanel});
        this.add(new Component[]{nickNamePanel});
        this.add(new Component[]{preferredLanguagePanel});
        this.add(new Component[]{profileUrlPanel});
        this.add(new Component[]{timezonePanel});
        this.add(new Component[]{titlePanel});
        this.add(new Component[]{userTypePanel});
        this.add(new Component[]{x509CertificatesMultiPanel});
        this.add(new Component[]{new Label("nameLabel", (IModel)Model.of((Serializable)((Object)"name")))});
        this.add(new Component[]{new Label("addressesLabel", (IModel)Model.of((Serializable)((Object)"addresses")))});
        this.add(new Component[]{new Label("emailsLabel", (IModel)Model.of((Serializable)((Object)"emails")))});
        this.add(new Component[]{new Label("phoneNumbersLabel", (IModel)Model.of((Serializable)((Object)"phoneNumbers")))});
        this.add(new Component[]{new Label("imsLabel", (IModel)Model.of((Serializable)((Object)"ims")))});
        this.add(new Component[]{new Label("photosLabel", (IModel)Model.of((Serializable)((Object)"photos")))});
    }

    private <T extends Enum<?>> void buildComplexPanels(List<SCIMComplexConf<T>> complexes, String basePanelId, String baseTabId, T[] canonicalTypes) {
        ArrayList<SCIMComplexConf> newElems = new ArrayList<SCIMComplexConf>();
        for (Object canonicalType : canonicalTypes) {
            SCIMComplexConf complex = complexes.stream().filter(complexConf -> complexConf.getType().equals(canonicalType)).findFirst().orElseGet(() -> {
                SCIMComplexConf empty = new SCIMComplexConf();
                empty.setType(canonicalType);
                return empty;
            });
            this.buildComplexAccordion((SCIMComplexConf<T>)complex, basePanelId, baseTabId, canonicalType);
            newElems.add(complex);
        }
        complexes.clear();
        complexes.addAll(newElems);
    }

    private void buildNameAccordion() {
        Accordion accordion = new Accordion("nameAccordion", List.of(new AbstractTab((IModel)Model.of((Serializable)((Object)"name"))){
            private static final long serialVersionUID = -5861786415855103549L;

            public WebMarkupContainer getPanel(String panelId) {
                return SCIMConfUserPanel.this.buildNameAccordionContent(panelId);
            }
        }), (IModel)Model.of((Serializable)Integer.valueOf(-1)));
        this.add(new Component[]{accordion.setOutputMarkupId(true)});
    }

    private void buildAddressAccordion(final SCIMUserAddressConf address, final AddressCanonicalType canonicalType) {
        Accordion accordion = new Accordion("addressesAccordion_" + address.getType().name(), List.of(new AbstractTab((IModel)Model.of((Serializable)((Object)("address." + address.getType().name())))){
            private static final long serialVersionUID = -5861786415855103549L;

            public WebMarkupContainer getPanel(String panelId) {
                return SCIMConfUserPanel.this.buildAddressAccordionContent(address, canonicalType, panelId);
            }
        }), (IModel)Model.of((Serializable)Integer.valueOf(-1)));
        this.add(new Component[]{accordion.setOutputMarkupId(true)});
    }

    private <T extends Enum<?>> void buildComplexAccordion(final SCIMComplexConf<T> complex, String basePanelId, String baseTabId, final T canonicalType) {
        Accordion accordion = new Accordion(basePanelId + "_" + complex.getType().name(), List.of(new AbstractTab((IModel)Model.of((Serializable)((Object)(baseTabId + "." + complex.getType().name())))){
            private static final long serialVersionUID = -5861786415855103549L;

            public WebMarkupContainer getPanel(String panelId) {
                return SCIMConfUserPanel.this.buildComplexAccordionContent(complex, canonicalType, panelId);
            }
        }), (IModel)Model.of((Serializable)Integer.valueOf(-1)));
        this.add(new Component[]{accordion.setOutputMarkupId(true)});
    }

    private SCIMConfAccordionContainer buildNameAccordionContent(String panelId) {
        ArrayList<AjaxTextFieldPanel> panelList = new ArrayList<AjaxTextFieldPanel>();
        AjaxTextFieldPanel nameFamilyNamePanel = new AjaxTextFieldPanel("accordionContent", "name.familyName", (IModel)new PropertyModel<String>((Object)this.scimUserConf.getName(), "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getName().getFamilyName();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.getName().setFamilyName(object);
            }
        });
        nameFamilyNamePanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel nameFormattedPanel = new AjaxTextFieldPanel("accordionContent", "name.formatted", (IModel)new PropertyModel<String>((Object)this.scimUserConf.getName(), "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getName().getFormatted();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.getName().setFormatted(object);
            }
        });
        nameFormattedPanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel nameGivenNamePanel = new AjaxTextFieldPanel("accordionContent", "name.givenName", (IModel)new PropertyModel<String>((Object)this.scimUserConf.getName(), "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getName().getGivenName();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.getName().setGivenName(object);
            }
        });
        nameGivenNamePanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel nameHonorificPrefixPanel = new AjaxTextFieldPanel("accordionContent", "name.honorificPrefix", (IModel)new PropertyModel<String>((Object)this.scimUserConf.getName(), "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getName().getHonorificPrefix();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.getName().setHonorificPrefix(object);
            }
        });
        nameHonorificPrefixPanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel nameHonorificSuffixPanel = new AjaxTextFieldPanel("accordionContent", "name.honorificSuffix", (IModel)new PropertyModel<String>((Object)this.scimUserConf.getName(), "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getName().getHonorificSuffix();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.getName().setHonorificSuffix(object);
            }
        });
        nameHonorificSuffixPanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel nameMiddleNamePanel = new AjaxTextFieldPanel("accordionContent", "name.middleName", (IModel)new PropertyModel<String>((Object)this.scimUserConf.getName(), "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return SCIMConfUserPanel.this.scimUserConf.getName().getMiddleName();
            }

            public void setObject(String object) {
                SCIMConfUserPanel.this.scimUserConf.getName().setMiddleName(object);
            }
        });
        nameMiddleNamePanel.setChoices((List)this.userPlainSchemas.getObject());
        panelList.add(nameFamilyNamePanel);
        panelList.add(nameFormattedPanel);
        panelList.add(nameGivenNamePanel);
        panelList.add(nameHonorificPrefixPanel);
        panelList.add(nameHonorificSuffixPanel);
        panelList.add(nameMiddleNamePanel);
        return new SCIMConfAccordionContainer(panelId, panelList);
    }

    private <T extends Enum<?>> SCIMConfAccordionContainer buildComplexAccordionContent(final SCIMComplexConf<T> complex, T canonicalType, String panelId) {
        ArrayList<AjaxTextFieldPanel> panelList = new ArrayList<AjaxTextFieldPanel>();
        String fieldName = panelId + "." + canonicalType.name();
        AjaxTextFieldPanel displayPanel = new AjaxTextFieldPanel("accordionContent", fieldName + ".display", (IModel)new PropertyModel<String>(complex, "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return complex.getDisplay();
            }

            public void setObject(String object) {
                complex.setDisplay(object);
            }
        });
        displayPanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel valuePanel = new AjaxTextFieldPanel("accordionContent", fieldName + ".value", (IModel)new PropertyModel<String>(complex, "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return complex.getValue();
            }

            public void setObject(String object) {
                complex.setValue(object);
            }
        });
        valuePanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel primaryPanel = new AjaxTextFieldPanel("accordionContent", fieldName + ".primary", (IModel)new PropertyModel<String>(complex, "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return String.valueOf(complex.isPrimary());
            }

            public void setObject(String object) {
                complex.setPrimary(Boolean.parseBoolean(object));
            }
        });
        primaryPanel.setChoices(List.of("true", "false"));
        panelList.add(displayPanel);
        panelList.add(valuePanel);
        panelList.add(primaryPanel);
        return new SCIMConfAccordionContainer(panelId, panelList);
    }

    private SCIMConfAccordionContainer buildAddressAccordionContent(final SCIMUserAddressConf address, AddressCanonicalType canonicalType, String panelId) {
        ArrayList<AjaxTextFieldPanel> panelList = new ArrayList<AjaxTextFieldPanel>();
        String fieldName = "addresses." + canonicalType.name();
        AjaxTextFieldPanel addressCountryPanel = new AjaxTextFieldPanel("accordionContent", fieldName + ".country", (IModel)new PropertyModel<String>((Object)address, "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return address.getCountry();
            }

            public void setObject(String object) {
                address.setCountry(object);
            }
        });
        addressCountryPanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel addressFormattedPanel = new AjaxTextFieldPanel("accordionContent", fieldName + ".formatted", (IModel)new PropertyModel<String>((Object)address, "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return address.getFormatted();
            }

            public void setObject(String object) {
                address.setFormatted(object);
            }
        });
        addressFormattedPanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel addressLocalityPanel = new AjaxTextFieldPanel("accordionContent", fieldName + ".locality", (IModel)new PropertyModel<String>((Object)address, "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return address.getLocality();
            }

            public void setObject(String object) {
                address.setLocality(object);
            }
        });
        addressLocalityPanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel addressRegionPanel = new AjaxTextFieldPanel("accordionContent", fieldName + ".region", (IModel)new PropertyModel<String>((Object)address, "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return address.getRegion();
            }

            public void setObject(String object) {
                address.setRegion(object);
            }
        });
        addressRegionPanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel addressPostalCodePanel = new AjaxTextFieldPanel("accordionContent", fieldName + ".postalCode", (IModel)new PropertyModel<String>((Object)address, "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return address.getPostalCode();
            }

            public void setObject(String object) {
                address.setPostalCode(object);
            }
        });
        addressPostalCodePanel.setChoices((List)this.userPlainSchemas.getObject());
        AjaxTextFieldPanel addressPrimaryPanel = new AjaxTextFieldPanel("accordionContent", fieldName + ".primary", (IModel)new PropertyModel<String>((Object)address, "accordionContent"){
            private static final long serialVersionUID = -6427731218492117883L;

            public String getObject() {
                return String.valueOf(address.isPrimary());
            }

            public void setObject(String object) {
                address.setPrimary(Boolean.parseBoolean(object));
            }
        });
        addressPrimaryPanel.setChoices(List.of("true", "false"));
        panelList.add(addressCountryPanel);
        panelList.add(addressFormattedPanel);
        panelList.add(addressLocalityPanel);
        panelList.add(addressRegionPanel);
        panelList.add(addressPostalCodePanel);
        panelList.add(addressPrimaryPanel);
        return new SCIMConfAccordionContainer(panelId, panelList);
    }
}

