/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import jakarta.servlet.Filter;
import java.util.List;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.JWTAuthenticationFilter;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.MustChangePasswordFilter;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.SyncopeAccessDeniedHandler;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetailsSource;
import org.apache.syncope.core.spring.security.SyncopeBasicAuthenticationEntryPoint;
import org.apache.syncope.core.spring.security.UsernamePasswordAuthenticationProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableWebSecurity
@EnableMethodSecurity(prePostEnabled=true)
@Configuration(proxyBeanMethods=false)
public class WebSecurityContext {
    @Bean
    public HttpFirewall allowUrlEncodedSlashHttpFirewall() {
        DefaultHttpFirewall firewall = new DefaultHttpFirewall();
        firewall.setAllowUrlEncodedSlash(true);
        return firewall;
    }

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer(HttpFirewall allowUrlEncodedSlashHttpFirewall) {
        return web -> web.httpFirewall(allowUrlEncodedSlashHttpFirewall);
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider, AccessDeniedHandler accessDeniedHandler, AuthDataAccessor dataAccessor, DefaultCredentialChecker defaultCredentialChecker) throws Exception {
        AuthenticationManager authenticationManager = (AuthenticationManager)((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)).parentAuthenticationManager(null).authenticationProvider((AuthenticationProvider)usernamePasswordAuthenticationProvider).build();
        http.authenticationManager(authenticationManager);
        SyncopeAuthenticationDetailsSource authenticationDetailsSource = new SyncopeAuthenticationDetailsSource();
        SyncopeBasicAuthenticationEntryPoint basicAuthenticationEntryPoint = new SyncopeBasicAuthenticationEntryPoint();
        basicAuthenticationEntryPoint.setRealmName("Apache Syncope authentication");
        http.httpBasic(customizer -> customizer.authenticationEntryPoint((AuthenticationEntryPoint)basicAuthenticationEntryPoint).authenticationDetailsSource((AuthenticationDetailsSource)authenticationDetailsSource));
        JWTAuthenticationFilter jwtAuthenticationFilter = new JWTAuthenticationFilter(authenticationManager, (AuthenticationEntryPoint)basicAuthenticationEntryPoint, authenticationDetailsSource, dataAccessor, defaultCredentialChecker);
        http.addFilterBefore((Filter)jwtAuthenticationFilter, BasicAuthenticationFilter.class);
        MustChangePasswordFilter mustChangePasswordFilter = new MustChangePasswordFilter();
        http.addFilterBefore((Filter)mustChangePasswordFilter, AuthorizationFilter.class);
        http.authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/actuator/**")})).hasAuthority("ANONYMOUS").requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/**")})).permitAll());
        http.securityContext(AbstractHttpConfigurer::disable);
        http.sessionManagement(AbstractHttpConfigurer::disable);
        http.headers(AbstractHttpConfigurer::disable);
        http.csrf(AbstractHttpConfigurer::disable);
        http.exceptionHandling(customizer -> customizer.accessDeniedHandler(accessDeniedHandler));
        return (SecurityFilterChain)http.build();
    }

    @ConditionalOnMissingBean
    @Bean
    public UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider(SecurityProperties securityProperties, EncryptorManager encryptorManager, DomainOps domainOps, AuthDataAccessor dataAccessor, UserProvisioningManager provisioningManager, DefaultCredentialChecker credentialChecker) {
        return new UsernamePasswordAuthenticationProvider(domainOps, dataAccessor, provisioningManager, credentialChecker, securityProperties, encryptorManager);
    }

    @Bean
    public AccessDeniedHandler accessDeniedHandler() {
        return new SyncopeAccessDeniedHandler();
    }

    @ConditionalOnMissingBean
    @Bean
    public AuthDataAccessor authDataAccessor(SecurityProperties securityProperties, EncryptorManager encryptorManager, RealmSearchDAO realmSearchDAO, UserDAO userDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, AccessTokenDAO accessTokenDAO, ConfParamOps confParamOps, RoleDAO roleDAO, DelegationDAO delegationDAO, ExternalResourceDAO resourceDAO, ConnectorManager connectorManager, AuditManager auditManager, MappingManager mappingManager, List<JWTSSOProvider> jwtSSOProviders) {
        return new AuthDataAccessor(securityProperties, encryptorManager, realmSearchDAO, userDAO, groupDAO, anySearchDAO, accessTokenDAO, confParamOps, roleDAO, delegationDAO, resourceDAO, connectorManager, auditManager, mappingManager, jwtSSOProviders);
    }
}

