/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.Encryptor;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.jasypt.digest.StandardStringDigester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCrypt;

public class DefaultEncryptor
implements Encryptor {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultEncryptor.class);
    protected final SecurityProperties.DigesterProperties digesterProperties;
    protected final Map<CipherAlgorithm, StandardStringDigester> digesters = new ConcurrentHashMap<CipherAlgorithm, StandardStringDigester>();
    protected final Optional<SecretKeySpec> aesKeySpec;

    protected DefaultEncryptor(String aesSecretKey, SecurityProperties.DigesterProperties digesterProperties) {
        this.digesterProperties = digesterProperties;
        SecretKeySpec sks = null;
        if (StringUtils.isNotBlank((CharSequence)aesSecretKey)) {
            String actualKey = aesSecretKey;
            Integer pad = null;
            boolean truncate = false;
            if (actualKey.length() < 16) {
                pad = 16 - actualKey.length();
            } else if (actualKey.length() > 16 && actualKey.length() < 24) {
                pad = 24 - actualKey.length();
            } else if (actualKey.length() > 24 && actualKey.length() < 32) {
                pad = 32 - actualKey.length();
            } else if (actualKey.length() > 32) {
                truncate = true;
            }
            if (pad != null) {
                StringBuilder actualKeyPadding = new StringBuilder(actualKey);
                String randomChars = SecureRandomUtils.generateRandomPassword(pad);
                actualKeyPadding.append(randomChars);
                actualKey = actualKeyPadding.toString();
                LOG.warn("The configured AES secret key is too short (< {}), padding with random chars: {}", (Object)actualKey.length(), (Object)actualKey);
            }
            if (truncate) {
                actualKey = actualKey.substring(0, 32);
                LOG.warn("The configured AES secret key is too long (> 32), truncating: {}", (Object)actualKey);
            }
            try {
                sks = new SecretKeySpec(actualKey.getBytes(StandardCharsets.UTF_8), CipherAlgorithm.AES.getAlgorithm());
                LOG.debug("AES-{} successfully configured", (Object)(actualKey.length() * 8));
            }
            catch (Exception e) {
                LOG.error("Error during key specification", (Throwable)e);
            }
        }
        this.aesKeySpec = Optional.ofNullable(sks);
    }

    public String encode(String value, CipherAlgorithm cipherAlgorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String encoded = null;
        if (value != null) {
            if (cipherAlgorithm == null || cipherAlgorithm == CipherAlgorithm.AES) {
                Cipher cipher = Cipher.getInstance(CipherAlgorithm.AES.getAlgorithm());
                cipher.init(1, this.aesKeySpec.orElseThrow(() -> new IllegalArgumentException("AES not configured")));
                encoded = Base64.getEncoder().encodeToString(cipher.doFinal(value.getBytes(StandardCharsets.UTF_8)));
            } else {
                encoded = cipherAlgorithm == CipherAlgorithm.BCRYPT ? BCrypt.hashpw((String)value, (String)BCrypt.gensalt()) : this.getDigester(cipherAlgorithm).digest(value);
            }
        }
        return encoded;
    }

    public boolean verify(String value, CipherAlgorithm cipherAlgorithm, String encoded) {
        boolean verified = false;
        try {
            if (value != null) {
                verified = cipherAlgorithm == null || cipherAlgorithm == CipherAlgorithm.AES ? this.encode(value, cipherAlgorithm).equals(encoded) : (cipherAlgorithm == CipherAlgorithm.BCRYPT ? BCrypt.checkpw((String)value, (String)encoded) : this.getDigester(cipherAlgorithm).matches(value, encoded));
            }
        }
        catch (Exception e) {
            LOG.error("Could not verify encoded value", (Throwable)e);
        }
        return verified;
    }

    public String decode(String encoded, CipherAlgorithm cipherAlgorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String decoded = null;
        if (encoded != null && cipherAlgorithm == CipherAlgorithm.AES) {
            Cipher cipher = Cipher.getInstance(CipherAlgorithm.AES.getAlgorithm());
            cipher.init(2, this.aesKeySpec.orElseThrow(() -> new IllegalArgumentException("AES not configured")));
            decoded = new String(cipher.doFinal(Base64.getDecoder().decode(encoded)), StandardCharsets.UTF_8);
        }
        return decoded;
    }

    protected StandardStringDigester getDigester(CipherAlgorithm cipherAlgorithm) {
        return this.digesters.computeIfAbsent(cipherAlgorithm, k -> {
            StandardStringDigester digester = new StandardStringDigester();
            if (cipherAlgorithm.getAlgorithm().startsWith("S-")) {
                digester.setAlgorithm(cipherAlgorithm.getAlgorithm().replaceFirst("S\\-", ""));
                digester.setIterations(this.digesterProperties.getSaltIterations());
                digester.setSaltSizeBytes(this.digesterProperties.getSaltSizeBytes());
                digester.setInvertPositionOfPlainSaltInEncryptionResults(this.digesterProperties.isInvertPositionOfPlainSaltInEncryptionResults());
                digester.setInvertPositionOfSaltInMessageBeforeDigesting(this.digesterProperties.isInvertPositionOfSaltInMessageBeforeDigesting());
                digester.setUseLenientSaltSizeCheck(this.digesterProperties.isUseLenientSaltSizeCheck());
            } else {
                digester.setAlgorithm(cipherAlgorithm.getAlgorithm());
                digester.setIterations(1);
                digester.setSaltSizeBytes(0);
            }
            digester.setStringOutputType("hexadecimal");
            return digester;
        });
    }
}

