/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.transport;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import lombok.Generated;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.transport.AbstractPac4jDecoder;
import org.pac4j.saml.util.SAML2Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pac4jHTTPRedirectDeflateDecoder
extends AbstractPac4jDecoder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jHTTPRedirectDeflateDecoder.class);

    public Pac4jHTTPRedirectDeflateDecoder(CallContext context) {
        super(context);
    }

    protected void doDecode() throws MessageDecodingException {
        SAML2MessageContext messageContext = new SAML2MessageContext(this.callContext);
        if (!WebContextHelper.isGet((WebContext)this.callContext.webContext())) {
            throw new MessageDecodingException("This message decoder only supports the HTTP-Redirect method");
        }
        String relayState = this.callContext.webContext().getRequestParameter("RelayState").orElse(null);
        LOGGER.debug("Decoded SAML relay state of: {}", (Object)relayState);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext.getMessageContext(), (String)relayState);
        byte[] base64DecodedMessage = this.getBase64DecodedMessage();
        InputStream inflatedMessage = this.inflate(base64DecodedMessage);
        SAMLObject inboundMessage = (SAMLObject)this.unmarshallMessage(inflatedMessage);
        SAML2Utils.logProtocolMessage((XMLObject)inboundMessage);
        messageContext.getMessageContext().setMessage((Object)inboundMessage);
        LOGGER.debug("Decoded SAML message");
        this.populateBindingContext(messageContext);
        this.setMessageContext(messageContext.getMessageContext());
    }

    protected InputStream inflate(byte[] input) throws MessageDecodingException {
        try {
            return this.internalInflate(input, new Inflater(true));
        }
        catch (IOException e) {
            try {
                return this.internalInflate(input, new Inflater());
            }
            catch (IOException e2) {
                LOGGER.warn("Cannot inflate message, returning it as is");
                return new ByteArrayInputStream(input);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream internalInflate(byte[] input, Inflater inflater) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(input), inflater);
        try {
            int length;
            byte[] buffer = new byte[1000];
            while ((length = iis.read(buffer)) > 0) {
                baos.write(buffer, 0, length);
            }
            byte[] decodedBytes = baos.toByteArray();
            String decodedMessage = new String(decodedBytes, StandardCharsets.UTF_8);
            LOGGER.debug("Inflated SAML message: {}", (Object)decodedMessage);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decodedBytes);
            return byteArrayInputStream;
        }
        finally {
            baos.close();
            iis.close();
        }
    }

    @Override
    public String getBindingURI(SAML2MessageContext messageContext) {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }
}

