/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class EventAccumulator<K, T extends Event<K>>
implements AutoCloseable {
    private final Random random;
    private final Map<K, Deque<T>> queues;
    private final List<K> availableKeys;
    private final Set<K> inflightKeys;
    private final ReentrantLock lock;
    private final Condition condition;
    private int size;
    private boolean closed;

    public EventAccumulator() {
        this(new Random());
    }

    public EventAccumulator(Random random) {
        this.random = random;
        this.queues = new HashMap<K, Deque<T>>();
        this.availableKeys = new ArrayList<K>();
        this.inflightKeys = new HashSet<K>();
        this.closed = false;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(T event) throws RejectedExecutionException {
        this.lock.lock();
        try {
            if (this.closed) {
                throw new RejectedExecutionException("Can't accept an event because the accumulator is closed.");
            }
            Object key = event.key();
            Deque<T> queue = this.queues.get(key);
            if (queue == null) {
                queue = new LinkedList<T>();
                this.queues.put(key, queue);
                if (!this.inflightKeys.contains(key)) {
                    this.addAvailableKey(key);
                }
            }
            queue.addLast(event);
            ++this.size;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(T event) throws RejectedExecutionException {
        this.lock.lock();
        try {
            if (this.closed) {
                throw new RejectedExecutionException("Can't accept an event because the accumulator is closed.");
            }
            Object key = event.key();
            Deque<T> queue = this.queues.get(key);
            if (queue == null) {
                queue = new LinkedList<T>();
                this.queues.put(key, queue);
                if (!this.inflightKeys.contains(key)) {
                    this.addAvailableKey(key);
                }
            }
            queue.addFirst(event);
            ++this.size;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T poll() {
        return this.poll(0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll(long timeout, TimeUnit unit) {
        this.lock.lock();
        try {
            K key = this.randomKey();
            long nanos = unit.toNanos(timeout);
            while (key == null && !this.closed && nanos > 0L) {
                try {
                    nanos = this.condition.awaitNanos(nanos);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                key = this.randomKey();
            }
            if (key == null) {
                T t = null;
                return t;
            }
            Deque<T> queue = this.queues.get(key);
            Event event = (Event)queue.poll();
            if (queue.isEmpty()) {
                this.queues.remove(key);
            }
            this.inflightKeys.add(key);
            --this.size;
            Event event2 = event;
            return (T)event2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void done(T event) {
        this.lock.lock();
        try {
            Object key = event.key();
            this.inflightKeys.remove(key);
            if (this.queues.containsKey(key)) {
                this.addAvailableKey(key);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.closed = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addAvailableKey(K key) {
        this.availableKeys.add(key);
        this.condition.signal();
    }

    private K randomKey() {
        if (this.availableKeys.isEmpty()) {
            return null;
        }
        int lastIndex = this.availableKeys.size() - 1;
        int randomIndex = this.random.nextInt(this.availableKeys.size());
        K randomKey = this.availableKeys.get(randomIndex);
        Collections.swap(this.availableKeys, randomIndex, lastIndex);
        this.availableKeys.remove(lastIndex);
        return randomKey;
    }

    public static interface Event<K> {
        public K key();
    }
}

