/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableBatchPartMigrationException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.tenant.TenantContext;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.tenant.CurrentTenant;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.InternalJobCompatibilityManager;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobProcessorContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.asyncexecutor.AsyncRunnableExecutionExceptionHandler;
import org.flowable.job.service.impl.asyncexecutor.JobExecutionObservation;
import org.flowable.job.service.impl.asyncexecutor.JobExecutionObservationProvider;
import org.flowable.job.service.impl.cmd.ExecuteAsyncRunnableJobCmd;
import org.flowable.job.service.impl.cmd.LockExclusiveJobCmd;
import org.flowable.job.service.impl.cmd.UnlockExclusiveJobCmd;
import org.flowable.job.service.impl.nontx.NonTransactionalJobHandler;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.flowable.job.service.impl.util.JobProcessorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteAsyncRunnable.class);
    protected final JobInfo job;
    protected final JobExecutionObservationProvider jobExecutionObservationProvider;
    protected JobServiceConfiguration jobServiceConfiguration;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected List<AsyncRunnableExecutionExceptionHandler> asyncRunnableExecutionExceptionHandlers;

    public ExecuteAsyncRunnable(JobInfo job, JobServiceConfiguration jobServiceConfiguration, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager, AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler, JobExecutionObservationProvider jobExecutionObservationProvider) {
        this.job = job;
        this.jobServiceConfiguration = jobServiceConfiguration;
        this.jobEntityManager = jobEntityManager;
        this.asyncRunnableExecutionExceptionHandlers = this.initializeExceptionHandlers(jobServiceConfiguration, asyncRunnableExecutionExceptionHandler);
        this.jobExecutionObservationProvider = jobExecutionObservationProvider;
    }

    private List<AsyncRunnableExecutionExceptionHandler> initializeExceptionHandlers(JobServiceConfiguration jobServiceConfiguration, AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler) {
        ArrayList<AsyncRunnableExecutionExceptionHandler> asyncRunnableExecutionExceptionHandlers = new ArrayList<AsyncRunnableExecutionExceptionHandler>();
        if (asyncRunnableExecutionExceptionHandler != null) {
            asyncRunnableExecutionExceptionHandlers.add(asyncRunnableExecutionExceptionHandler);
        }
        if (jobServiceConfiguration.getAsyncRunnableExecutionExceptionHandlers() != null) {
            asyncRunnableExecutionExceptionHandlers.addAll(jobServiceConfiguration.getAsyncRunnableExecutionExceptionHandlers());
        }
        return asyncRunnableExecutionExceptionHandlers;
    }

    @Override
    public void run() {
        TenantContext tenantContext = CurrentTenant.getTenantContext();
        JobExecutionObservation observation = this.jobExecutionObservationProvider.create(this.job);
        try {
            tenantContext.setTenantId(this.job.getTenantId());
            observation.start();
            this.runInternally(observation);
        }
        finally {
            observation.stop();
            tenantContext.clearTenantId();
        }
    }

    protected void runInternally(JobExecutionObservation observation) {
        if (this.job instanceof Job) {
            Job jobObject = (Job)this.job;
            InternalJobCompatibilityManager internalJobCompatibilityManager = this.jobServiceConfiguration.getInternalJobCompatibilityManager();
            if (internalJobCompatibilityManager != null && internalJobCompatibilityManager.isFlowable5Job(jobObject)) {
                internalJobCompatibilityManager.executeV5JobWithLockAndRetry(jobObject);
                return;
            }
        }
        if (this.job instanceof AbstractRuntimeJobEntity) {
            boolean lockingNeeded = ((AbstractRuntimeJobEntity)this.job).isExclusive();
            boolean executeJob = true;
            if (lockingNeeded) {
                executeJob = this.lockJob(observation);
            }
            if (executeJob) {
                this.executeJob(lockingNeeded, observation);
            }
        } else {
            this.executeJob(false, observation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeJob(boolean unlock, JobExecutionObservation observation) {
        try (JobExecutionObservation.Scope ignored = observation.executionScope();){
            Map<String, JobHandler> jobHandlers;
            JobHandler jobHandler;
            boolean jobHandled = false;
            if (this.job instanceof JobEntity && (jobHandler = (jobHandlers = this.jobServiceConfiguration.getJobHandlers()).get(this.job.getJobHandlerType())) instanceof NonTransactionalJobHandler) {
                NonTransactionalJobHandler nonTransactionalJobHandler = (NonTransactionalJobHandler)jobHandler;
                jobHandled = this.handleNontransactionalJob(nonTransactionalJobHandler, unlock);
            }
            if (!jobHandled) {
                this.handleTransactionalJob(unlock);
            }
        }
        catch (FlowableOptimisticLockingException e) {
            try {
                this.handleFailedJob(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Optimistic locking exception during job execution. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor threads running against the same database. Exception message: {}", (Object)e.getMessage());
            }
            observation.executionError(e);
        }
        catch (Throwable exception) {
            try {
                this.handleFailedJob(exception);
            }
            finally {
                observation.executionError(exception);
            }
        }
    }

    protected void handleTransactionalJob(boolean unlock) {
        this.jobServiceConfiguration.getCommandExecutor().execute((Command)new ExecuteAsyncRunnableJobCmd(this.job.getId(), this.jobEntityManager, this.jobServiceConfiguration, unlock));
    }

    protected boolean handleNontransactionalJob(NonTransactionalJobHandler<Object> jobHandler, boolean unlock) {
        JobProcessorUtil.callJobProcessors(this.jobServiceConfiguration, JobProcessorContext.Phase.BEFORE_EXECUTE, (JobEntity)this.job);
        Object nonTransactionalOutput = jobHandler.executeNonTransactionally((JobEntity)this.job, this.job.getJobHandlerConfiguration());
        FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_EXECUTION_SUCCESS, this.job), this.jobServiceConfiguration.getEngineName());
        }
        this.jobServiceConfiguration.getCommandExecutor().execute(commandContext -> {
            jobHandler.afterExecute((JobEntity)this.job, this.job.getJobHandlerConfiguration(), nonTransactionalOutput, commandContext);
            if (unlock) {
                new UnlockExclusiveJobCmd((Job)this.job, this.jobServiceConfiguration).execute(commandContext);
            }
            this.jobServiceConfiguration.getJobEntityManager().delete((JobEntity)this.job);
            return null;
        });
        return true;
    }

    protected void unlockJobIfNeeded() {
        if (this.job instanceof HistoryJob) {
            return;
        }
        Job job = (Job)this.job;
        try {
            if (job.isExclusive()) {
                this.jobServiceConfiguration.getCommandExecutor().execute((Command)new UnlockExclusiveJobCmd(job, this.jobServiceConfiguration));
            }
        }
        catch (FlowableOptimisticLockingException optimisticLockingException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Optimistic locking exception while unlocking the job. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error while unlocking exclusive job {}", (Object)job.getId(), (Object)t);
        }
    }

    protected boolean lockJob(JobExecutionObservation observation) {
        Job job = (Job)this.job;
        try (JobExecutionObservation.Scope ignored = observation.lockScope();){
            this.jobServiceConfiguration.getCommandExecutor().execute((Command)new LockExclusiveJobCmd(job, this.jobServiceConfiguration));
        }
        catch (Throwable lockException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Could not lock exclusive job. Unlocking job so it can be acquired again. Caught exception: {}", (Object)lockException.getMessage());
            }
            this.unacquireJob();
            observation.lockError(lockException);
            return false;
        }
        return true;
    }

    protected void unacquireJob() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            this.jobServiceConfiguration.getJobManager().unacquire(this.job);
        } else {
            this.jobServiceConfiguration.getCommandExecutor().execute((Command)new Command<Void>(){

                public Void execute(CommandContext commandContext) {
                    ExecuteAsyncRunnable.this.jobServiceConfiguration.getJobManager().unacquire(ExecuteAsyncRunnable.this.job);
                    return null;
                }
            });
        }
    }

    protected void handleFailedJob(Throwable exception) {
        if (exception instanceof FlowableBatchPartMigrationException && ((FlowableBatchPartMigrationException)exception).isIgnoreFailedJob()) {
            this.jobServiceConfiguration.getCommandExecutor().execute((Command)new Command<Object>(){

                public Void execute(CommandContext commandContext) {
                    CommandConfig commandConfig = ExecuteAsyncRunnable.this.jobServiceConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                    return (Void)ExecuteAsyncRunnable.this.jobServiceConfiguration.getCommandExecutor().execute(commandConfig, (Command)new Command<Void>(){

                        public Void execute(CommandContext commandContext2) {
                            ExecuteAsyncRunnable.this.jobServiceConfiguration.getJobManager().deleteExecutableJob(ExecuteAsyncRunnable.this.job);
                            return null;
                        }
                    });
                }
            });
            return;
        }
        for (AsyncRunnableExecutionExceptionHandler asyncRunnableExecutionExceptionHandler : this.asyncRunnableExecutionExceptionHandlers) {
            if (!asyncRunnableExecutionExceptionHandler.handleException(this.jobServiceConfiguration, this.job, exception)) continue;
            this.unlockJobIfNeeded();
            return;
        }
        LOGGER.error("Unable to handle exception {} for job {}.", (Object)exception, (Object)this.job);
        throw new FlowableException("Unable to handle exception " + exception.getMessage() + " for " + String.valueOf(this.job) + ".", exception);
    }
}

