/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.profiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.test.profiler.CommandExecutionResult;

public class CommandStats {
    protected long getTotalCommandTime;
    protected List<Long> commandExecutionTimings = new ArrayList<Long>();
    protected List<Long> databaseTimings = new ArrayList<Long>();
    protected Map<String, Long> dbSelects = new HashMap<String, Long>();
    protected Map<String, Long> dbInserts = new HashMap<String, Long>();
    protected Map<String, Long> dbUpdates = new HashMap<String, Long>();
    protected Map<String, Long> dbDeletes = new HashMap<String, Long>();

    public CommandStats(List<CommandExecutionResult> executions) {
        for (CommandExecutionResult execution : executions) {
            this.getTotalCommandTime += execution.getTotalTimeInMs();
            this.commandExecutionTimings.add(execution.getTotalTimeInMs());
            this.databaseTimings.add(execution.getDatabaseTimeInMs());
            this.addToDbOperation(execution.getDbSelects(), this.dbSelects);
            this.addToDbOperation(execution.getDbInserts(), this.dbInserts);
            this.addToDbOperation(execution.getDbUpdates(), this.dbUpdates);
            this.addToDbOperation(execution.getDbDeletes(), this.dbDeletes);
        }
    }

    protected void addToDbOperation(Map<String, Long> executionMap, Map<String, Long> globalMap) {
        for (String key : executionMap.keySet()) {
            if (!globalMap.containsKey(key)) {
                globalMap.put(key, 0L);
            }
            Long oldValue = globalMap.get(key);
            globalMap.put(key, oldValue + executionMap.get(key));
        }
    }

    public long getCount() {
        return this.commandExecutionTimings.size();
    }

    public long getGetTotalCommandTime() {
        return this.getTotalCommandTime;
    }

    public double getAverageExecutionTime() {
        long total = 0L;
        for (Long timing : this.commandExecutionTimings) {
            total += timing.longValue();
        }
        double average = (double)total / (double)this.commandExecutionTimings.size();
        return (double)Math.round(average * 100.0) / 100.0;
    }

    public double getAverageDatabaseExecutionTimePercentage() {
        double totalAvg = this.getAverageExecutionTime();
        double databaseAvg = this.getAverageDatabaseExecutionTime();
        double percentage = 100.0 * (databaseAvg / totalAvg);
        return (double)Math.round(percentage * 100.0) / 100.0;
    }

    public double getAverageDatabaseExecutionTime() {
        long total = 0L;
        for (Long timing : this.databaseTimings) {
            total += timing.longValue();
        }
        double average = (double)total / (double)this.commandExecutionTimings.size();
        return (double)Math.round(average * 100.0) / 100.0;
    }

    public Map<String, Long> getDbSelects() {
        return this.dbSelects;
    }

    public void setDbSelects(Map<String, Long> dbSelects) {
        this.dbSelects = dbSelects;
    }

    public Map<String, Long> getDbInserts() {
        return this.dbInserts;
    }

    public void setDbInserts(Map<String, Long> dbInserts) {
        this.dbInserts = dbInserts;
    }

    public Map<String, Long> getDbUpdates() {
        return this.dbUpdates;
    }

    public void setDbUpdates(Map<String, Long> dbUpdates) {
        this.dbUpdates = dbUpdates;
    }

    public Map<String, Long> getDbDeletes() {
        return this.dbDeletes;
    }

    public void setDbDeletes(Map<String, Long> dbDeletes) {
        this.dbDeletes = dbDeletes;
    }
}

