/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.rest;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.AttributeFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class FIQLFilterTranslator
extends AbstractFilterTranslator<Map<String, Object>> {
    private Map<String, Object> createMap(ConditionType conditionType, AttributeFilter filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String name = filter.getAttribute().getName();
        String value = AttributeUtil.getAsStringValue((Attribute)filter.getAttribute());
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        map.put("conditionType", conditionType);
        map.put("left", name);
        map.put("right", value);
        return map;
    }

    protected Map<String, Object> createContainsExpression(ContainsFilter filter, boolean not) {
        String value = AttributeUtil.getAsStringValue((Attribute)filter.getAttribute());
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        filter.getAttribute().getValue().set(0, "*" + value + "*");
        return this.createMap(not ? ConditionType.NOT_EQUALS : ConditionType.EQUALS, (AttributeFilter)filter);
    }

    protected Map<String, Object> createEndsWithExpression(EndsWithFilter filter, boolean not) {
        String value = AttributeUtil.getAsStringValue((Attribute)filter.getAttribute());
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        filter.getAttribute().getValue().set(0, "*" + value);
        return this.createMap(not ? ConditionType.NOT_EQUALS : ConditionType.EQUALS, (AttributeFilter)filter);
    }

    protected Map<String, Object> createStartsWithExpression(StartsWithFilter filter, boolean not) {
        String value = AttributeUtil.getAsStringValue((Attribute)filter.getAttribute());
        if (StringUtil.isBlank((String)value)) {
            return null;
        }
        filter.getAttribute().getValue().set(0, value + "*");
        return this.createMap(not ? ConditionType.NOT_EQUALS : ConditionType.EQUALS, (AttributeFilter)filter);
    }

    protected Map<String, Object> createEqualsExpression(EqualsFilter filter, boolean not) {
        return this.createMap(not ? ConditionType.NOT_EQUALS : ConditionType.EQUALS, (AttributeFilter)filter);
    }

    protected Map<String, Object> createEqualsIgnoreCaseExpression(EqualsIgnoreCaseFilter filter, boolean not) {
        return this.createMap(not ? ConditionType.NOT_EQUALS : ConditionType.EQUALS, (AttributeFilter)filter);
    }

    protected Map<String, Object> createAndExpression(Map<String, Object> leftExpression, Map<String, Object> rightExpression) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conditionType", ConditionType.AND);
        map.put("left", leftExpression);
        map.put("right", rightExpression);
        return map;
    }

    protected Map<String, Object> createOrExpression(Map<String, Object> leftExpression, Map<String, Object> rightExpression) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conditionType", ConditionType.OR);
        map.put("left", leftExpression);
        map.put("right", rightExpression);
        return map;
    }

    protected Map<String, Object> createGreaterThanExpression(GreaterThanFilter filter, boolean not) {
        return this.createMap(not ? ConditionType.LESS_OR_EQUALS : ConditionType.GREATER_THAN, (AttributeFilter)filter);
    }

    protected Map<String, Object> createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
        return this.createMap(not ? ConditionType.LESS_THAN : ConditionType.GREATER_OR_EQUALS, (AttributeFilter)filter);
    }

    protected Map<String, Object> createLessThanExpression(LessThanFilter filter, boolean not) {
        return this.createMap(not ? ConditionType.GREATER_OR_EQUALS : ConditionType.LESS_THAN, (AttributeFilter)filter);
    }

    protected Map<String, Object> createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
        return this.createMap(not ? ConditionType.GREATER_THAN : ConditionType.LESS_OR_EQUALS, (AttributeFilter)filter);
    }
}

