/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonEditorPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.XMLEditorPanel;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.EncryptedFieldPanel;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.keymaster.client.api.model.JPADomain;
import org.apache.syncope.common.keymaster.client.api.model.Neo4jDomain;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class DomainWizardBuilder
extends BaseAjaxWizardBuilder<Domain> {
    private static final long serialVersionUID = -6731030158762705250L;
    private static final List<String> JDBC_DRIVERS = List.of("org.postgresql.Driver", "com.mysql.cj.jdbc.Driver", "org.mariadb.jdbc.Driver", "oracle.jdbc.OracleDriver", "org.h2.Driver");
    private static final List<String> DATABASE_PLATFORMS = List.of("org.apache.openjpa.jdbc.sql.PostgresDictionary", "org.apache.openjpa.jdbc.sql.MySQLDictionary(blobTypeName=LONGBLOB,dateFractionDigits=3,useSetStringForClobs=true)", "org.apache.openjpa.jdbc.sql.MariaDBDictionary(blobTypeName=LONGBLOB,dateFractionDigits=3)", "org.apache.openjpa.jdbc.sql.OracleDictionary", "org.apache.openjpa.jdbc.sql.H2Dictionary");
    private final DomainOps domainOps;

    public DomainWizardBuilder(DomainOps domainOps, Domain domain, PageReference pageRef) {
        super(domain, pageRef);
        this.domainOps = domainOps;
    }

    protected Serializable onApplyInternal(Domain domain) {
        this.domainOps.create(domain);
        return domain;
    }

    protected WizardModel buildModelSteps(Domain domain, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)(domain instanceof Neo4jDomain ? new Neo4jStorage(domain) : new JPAStorage(domain)));
        wizardModel.add((IWizardStep)new AdminCredentials(domain));
        wizardModel.add((IWizardStep)new Content(domain));
        wizardModel.add((IWizardStep)new KeymasterConfParams(domain, this.pageRef));
        return wizardModel;
    }

    public static class Neo4jStorage
    extends WizardStep {
        private static final long serialVersionUID = 3671044119870133102L;

        public Neo4jStorage(Domain domain) {
            this.add(new Component[]{new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)domain, "key")).addRequiredLabel()});
            final PropertyModel uriModel = new PropertyModel((Object)domain, "uri");
            this.add(new Component[]{new AjaxTextFieldPanel("uri", "uri", (IModel)new IModel<String>(){
                private static final long serialVersionUID = 807008909842554829L;

                public String getObject() {
                    return Optional.ofNullable((URI)uriModel.getObject()).map(URI::toASCIIString).orElse(null);
                }

                public void setObject(String object) {
                    uriModel.setObject((Object)URI.create(object));
                }
            }).addRequiredLabel()});
            this.add(new Component[]{new AjaxTextFieldPanel("username", "username", (IModel)new PropertyModel((Object)domain, "username")).addRequiredLabel()});
            this.add(new Component[]{new EncryptedFieldPanel("password", "password", (IModel)new PropertyModel((Object)domain, "password"), false)});
        }
    }

    public static class JPAStorage
    extends WizardStep {
        private static final long serialVersionUID = 3671044119870133102L;

        public JPAStorage(Domain domain) {
            this.add(new Component[]{new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)domain, "key")).addRequiredLabel()});
            AjaxDropDownChoicePanel jdbcDriver = new AjaxDropDownChoicePanel("jdbcDriver", "jdbcDriver", (IModel)new PropertyModel((Object)domain, "jdbcDriver"), false);
            jdbcDriver.setChoices(JDBC_DRIVERS);
            jdbcDriver.addRequiredLabel();
            jdbcDriver.setNullValid(false);
            this.add(new Component[]{jdbcDriver});
            this.add(new Component[]{new AjaxTextFieldPanel("jdbcURL", "jdbcURL", (IModel)new PropertyModel((Object)domain, "jdbcURL")).addRequiredLabel()});
            this.add(new Component[]{new AjaxTextFieldPanel("dbSchema", "dbSchema", (IModel)new PropertyModel((Object)domain, "dbSchema")).setRequired(false)});
            this.add(new Component[]{new AjaxTextFieldPanel("dbUsername", "dbUsername", (IModel)new PropertyModel((Object)domain, "dbUsername")).addRequiredLabel()});
            this.add(new Component[]{new EncryptedFieldPanel("dbPassword", "dbPassword", (IModel)new PropertyModel((Object)domain, "dbPassword"), false)});
            AjaxDropDownChoicePanel transactionIsolation = new AjaxDropDownChoicePanel("transactionIsolation", "transactionIsolation", (IModel)new PropertyModel((Object)domain, "transactionIsolation"), false);
            transactionIsolation.setChoices(List.of(JPADomain.TransactionIsolation.values()));
            transactionIsolation.addRequiredLabel();
            transactionIsolation.setNullValid(false);
            this.add(new Component[]{transactionIsolation});
            this.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)0).build("poolMaxActive", "poolMaxActive", Integer.class, (IModel)new PropertyModel((Object)domain, "poolMaxActive")).addRequiredLabel()});
            this.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)0).build("poolMinIdle", "poolMinIdle", Integer.class, (IModel)new PropertyModel((Object)domain, "poolMinIdle")).addRequiredLabel()});
            this.add(new Component[]{new AjaxTextFieldPanel("orm", "orm", (IModel)new PropertyModel((Object)domain, "orm")).addRequiredLabel()});
            AjaxDropDownChoicePanel databasePlatform = new AjaxDropDownChoicePanel("databasePlatform", "databasePlatform", (IModel)new PropertyModel((Object)domain, "databasePlatform"), false);
            databasePlatform.setChoices(DATABASE_PLATFORMS);
            databasePlatform.addRequiredLabel();
            databasePlatform.setNullValid(false);
            this.add(new Component[]{databasePlatform});
        }
    }

    public static class AdminCredentials
    extends WizardStep {
        private static final long serialVersionUID = -7472243942630790243L;

        public AdminCredentials(Domain domain) {
            AjaxDropDownChoicePanel adminCipherAlgorithm = new AjaxDropDownChoicePanel("adminCipherAlgorithm", "adminCipherAlgorithm", (IModel)new PropertyModel((Object)domain, "adminCipherAlgorithm"), false);
            adminCipherAlgorithm.setChoices(List.of(CipherAlgorithm.values()));
            adminCipherAlgorithm.addRequiredLabel();
            adminCipherAlgorithm.setNullValid(false);
            this.add(new Component[]{adminCipherAlgorithm});
            EncryptedFieldPanel adminPassword = new EncryptedFieldPanel("adminPassword", "adminPassword", (IModel)new PropertyModel((Object)domain, "adminPassword"), false);
            adminPassword.addRequiredLabel();
            this.add(new Component[]{adminPassword});
        }
    }

    public class Content
    extends WizardStep {
        private static final long serialVersionUID = -4214163958296844853L;

        public Content(Domain domain) {
            final XMLEditorPanel content = new XMLEditorPanel(null, (IModel<String>)new PropertyModel((Object)domain, "content"), false, DomainWizardBuilder.this.pageRef);
            content.setOutputMarkupPlaceholderTag(true);
            content.setVisible(false);
            this.add(new Component[]{content});
            final AjaxCheckBoxPanel defaultContent = new AjaxCheckBoxPanel("defaultContent", "defaultContent", (IModel)Model.of((Serializable)Boolean.valueOf(true)), true);
            defaultContent.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    content.setVisible(!BooleanUtils.toBoolean((Boolean)((Boolean)defaultContent.getField().getConvertedInput())));
                    target.add(new Component[]{content});
                }
            }});
            this.add(new Component[]{defaultContent});
        }
    }

    public static class KeymasterConfParams
    extends WizardStep {
        private static final long serialVersionUID = -8448363577805933925L;

        public KeymasterConfParams(Domain domain, PageReference pageRef) {
            final JsonEditorPanel keymasterConfParams = new JsonEditorPanel(null, (IModel<String>)new PropertyModel((Object)domain, "keymasterConfParams"), false, pageRef);
            keymasterConfParams.setOutputMarkupPlaceholderTag(true);
            keymasterConfParams.setVisible(false);
            this.add(new Component[]{keymasterConfParams});
            final AjaxCheckBoxPanel defaultKeymasterConfParams = new AjaxCheckBoxPanel("defaultKeymasterConfParams", "defaultKeymasterConfParams", (IModel)Model.of((Serializable)Boolean.valueOf(true)), true);
            defaultKeymasterConfParams.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -6139318907146065915L;

                protected void onUpdate(AjaxRequestTarget target) {
                    keymasterConfParams.setVisible(!BooleanUtils.toBoolean((Boolean)((Boolean)defaultKeymasterConfParams.getField().getConvertedInput())));
                    target.add(new Component[]{keymasterConfParams});
                }
            }});
            this.add(new Component[]{defaultKeymasterConfParams});
        }
    }
}

