/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketRegistrySessionStore
implements SessionStore {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketRegistrySessionStore.class);
    private static final String SESSION_ID_IN_REQUEST_ATTRIBUTE = "sessionIdInRequestAttribute";
    private final TicketRegistry ticketRegistry;
    private final TicketFactory ticketFactory;
    private final CasCookieBuilder cookieGenerator;

    public Optional<String> getSessionId(WebContext webContext, boolean create) {
        LOGGER.trace("Fetching session id...");
        String sessionId = this.fetchSessionIdFromContext(webContext);
        return Optional.ofNullable(sessionId);
    }

    public Optional get(WebContext context, String key) {
        LOGGER.trace("Getting key: [{}]", (Object)key);
        TransientSessionTicket ticket = this.getTransientSessionTicketForSession(context);
        if (ticket == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ticket.getProperties().get(key));
    }

    public void set(WebContext context, String key, Object value) {
        LOGGER.trace("Setting key: [{}]", (Object)key);
        String sessionId = this.getSessionId(context, true).orElseGet(() -> {
            String newSessionId = UUID.randomUUID().toString();
            LOGGER.trace("Generated session id: [{}]", (Object)newSessionId);
            return newSessionId;
        });
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        if (value instanceof Serializable) {
            Serializable serializable = (Serializable)value;
            properties.put(key, serializable);
        } else if (value != null) {
            LOGGER.warn("Object value [{}] assigned to [{}] is not serializable and may not be part of the ticket [{}]", new Object[]{value, key, sessionId});
        }
        TransientSessionTicket ticket = this.getTransientSessionTicketForSession(context);
        if (value == null && ticket != null) {
            ticket.getProperties().remove(key);
            this.updateTicket(context, ticket);
        } else if (ticket == null) {
            FunctionUtils.doAndHandle(__ -> {
                TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
                TransientSessionTicket transientSessionTicket = transientFactory.create(sessionId, (Map)properties);
                Ticket addedTicket = this.ticketRegistry.addTicket((Ticket)transientSessionTicket);
                JEEContext webContext = (JEEContext)context;
                this.cookieGenerator.addCookie(webContext.getNativeRequest(), webContext.getNativeResponse(), addedTicket.getId());
                context.setRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE, (Object)addedTicket.getId());
            });
        } else {
            ticket.getProperties().putAll(properties);
            this.updateTicket(context, ticket);
        }
    }

    private void updateTicket(WebContext context, TransientSessionTicket ticket) {
        FunctionUtils.doUnchecked(__ -> {
            Ticket updatedTicket = this.ticketRegistry.updateTicket((Ticket)ticket);
            context.setRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE, (Object)updatedTicket.getId());
        }, (Object[])new Object[0]);
    }

    public boolean destroySession(WebContext webContext) {
        String sessionId = this.fetchSessionIdFromContext(webContext);
        if (sessionId != null) {
            String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)sessionId);
            FunctionUtils.doUnchecked(__ -> this.ticketRegistry.deleteTicket(ticketId), (Object[])new Object[0]);
            JEEContext context = (JEEContext)webContext;
            this.cookieGenerator.removeCookie(context.getNativeResponse());
            LOGGER.trace("Removes session cookie and ticket: [{}]", (Object)ticketId);
        }
        return true;
    }

    public Optional getTrackableSession(WebContext context) {
        String sessionId = this.fetchSessionIdFromContext(context);
        LOGGER.trace("Track session id: [{}]", (Object)sessionId);
        return Optional.ofNullable(sessionId);
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        context.setRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE, trackableSession);
        LOGGER.trace("Force session id: [{}]", trackableSession);
        return Optional.of(this);
    }

    public boolean renewSession(WebContext context) {
        return false;
    }

    protected String fetchSessionIdFromContext(WebContext webContext) {
        LOGGER.trace("Fetched session id from context");
        String sessionId = webContext.getRequestAttribute(SESSION_ID_IN_REQUEST_ATTRIBUTE).orElse(null);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            LOGGER.trace("Session id not found as a request attribute; checking session cookie [{}]", (Object)this.cookieGenerator.getCookieName());
            JEEContext context = (JEEContext)webContext;
            sessionId = this.cookieGenerator.retrieveCookieValue(context.getNativeRequest());
        }
        LOGGER.trace("Fetched session id: [{}]", (Object)sessionId);
        return sessionId;
    }

    private TransientSessionTicket getTransientSessionTicketForSession(WebContext context) {
        try {
            String sessionId = this.fetchSessionIdFromContext(context);
            if (sessionId != null) {
                String ticketId = TransientSessionTicketFactory.normalizeTicketId((String)sessionId);
                LOGGER.trace("Fetching ticket: [{}]", (Object)ticketId);
                return (TransientSessionTicket)this.ticketRegistry.getTicket(ticketId, TransientSessionTicket.class);
            }
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Generated
    public TicketRegistrySessionStore(TicketRegistry ticketRegistry, TicketFactory ticketFactory, CasCookieBuilder cookieGenerator) {
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
        this.cookieGenerator = cookieGenerator;
    }
}

