/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005y4AAD\b\u0001)!)\u0011\u0004\u0001C\u00015!9A\u0004\u0001b\u0001\n\u0003j\u0002B\u0002\u0013\u0001A\u0003%a\u0004C\u0004&\u0001\t\u0007I\u0011I\u000f\t\r\u0019\u0002\u0001\u0015!\u0003\u001f\u0011\u001d9\u0003A1A\u0005\u0002!Ba!\r\u0001!\u0002\u0013I\u0003\"\u0002\u001a\u0001\t\u0003\u001a\u0004\"B \u0001\t\u0013\u0001\u0005\"\u0002/\u0001\t\u0003i\u0006\"B5\u0001\t\u0003i\u0006\"B6\u0001\t\u0003i\u0006\"B7\u0001\t\u0013q'AH!mi\u0016\u0014(+\u001a9mS\u000e\fGj\\4ESJ\u001c(+Z9vKN$H+Z:u\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1r#D\u0001\u0010\u0013\tArBA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0017\u0001\u0005YAn\\4ESJ\u001cu.\u001e8u+\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#aA%oi\u0006aAn\\4ESJ\u001cu.\u001e8uA\u0005Y!M]8lKJ\u001cu.\u001e8u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003\u0015!x\u000e]5d+\u0005I\u0003C\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u0011a\u0017M\\4\u000b\u00039\nAA[1wC&\u0011\u0001g\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u00025oA\u0011q$N\u0005\u0003m\u0001\u0012A!\u00168ji\")\u0001\b\u0003a\u0001s\u0005Q\u0001O]8qKJ$\u0018.Z:\u0011\u0005ijT\"A\u001e\u000b\u0005qj\u0013\u0001B;uS2L!AP\u001e\u0003\u0015A\u0013x\u000e]3si&,7/A\u000bgS:$WI\u001d:pe\u001a{'\u000fU1si&$\u0018n\u001c8\u0015\u0007\u0005se\u000b\u0005\u0002C\u00196\t1I\u0003\u0002E\u000b\u0006A\u0001O]8u_\u000e|GN\u0003\u0002G\u000f\u000611m\\7n_:T!A\u0005%\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'oZ\u0005\u0003\u001b\u000e\u0013a!\u0012:s_J\u001c\b\"B(\n\u0001\u0004\u0001\u0016\u0001\u0003:fgB|gn]3\u0011\u0005E#V\"\u0001*\u000b\u0005M+\u0015\u0001\u0003:fcV,7\u000f^:\n\u0005U\u0013&aG!mi\u0016\u0014(+\u001a9mS\u000e\fGj\\4ESJ\u001c(+Z:q_:\u001cX\rC\u0003X\u0013\u0001\u0007\u0001,\u0001\u0002uaB\u0011\u0011LW\u0007\u0002\u000b&\u00111,\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003y!Xm\u001d;BYR,'OU3qY&\u001c\u0017\rT8h\t&\u00148OU3rk\u0016\u001cH\u000fF\u00015Q\tQq\f\u0005\u0002aO6\t\u0011M\u0003\u0002cG\u0006\u0019\u0011\r]5\u000b\u0005\u0011,\u0017a\u00026va&$XM\u001d\u0006\u0003M*\u000bQA[;oSRL!\u0001[1\u0003\tQ+7\u000f^\u0001(i\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006dun\u001a#jeN\u0014V-];fgR,%O]8s\u0007>$W\r\u000b\u0002\f?\u0006YC/Z:u\u00032$XM\u001d*fa2L7-\u0019'pO\u0012K'o\u001d*fcV,7\u000f^,ji\"\u0014V\r^3oi&|g\u000e\u000b\u0002\r?\u0006q2/\u001a8e\u00032$XM\u001d*fa2L7-\u0019'pO\u0012K'o\u001d*fcV,7\u000f\u001e\u000b\u0003!>DQ\u0001]\u0007A\u0002E\fQ\u0002]1si&$\u0018n\u001c8ESJ\u001c\b\u0003\u0002:z1rt!a]<\u0011\u0005Q\u0004S\"A;\u000b\u0005Y\u001c\u0012A\u0002\u001fs_>$h(\u0003\u0002yA\u00051\u0001K]3eK\u001aL!A_>\u0003\u00075\u000b\u0007O\u0003\u0002yAA\u0011!/`\u0005\u0003am\u0004")
public class AlterReplicaLogDirsRequestTest
extends BaseRequestTest {
    private final int logDirCount;
    private final int brokerCount;
    private final String topic;

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("log.initial.task.delay.ms", "0");
        properties.put("log.retention.check.interval.ms", "1000");
    }

    private Errors findErrorForPartition(AlterReplicaLogDirsResponse response, TopicPartition tp) {
        return Errors.forCode((short)((AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult)CollectionConverters$.MODULE$.ListHasAsScala(((AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult)CollectionConverters$.MODULE$.ListHasAsScala(response.data().results()).asScala().find((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)AlterReplicaLogDirsRequestTest.$anonfun$findErrorForPartition$1(tp, x))).get()).partitions()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AlterReplicaLogDirsRequestTest.$anonfun$findErrorForPartition$2(tp, p))).get()).errorCode());
    }

    @Test
    public void testAlterReplicaLogDirsRequest() {
        int partitionNum = 5;
        String logDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir1)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)this.findErrorForPartition(alterReplicaLogDirsResponse1, tp));
            LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
            boolean x$2 = qual$1.getLog$default$2();
            Assertions.assertTrue((boolean)qual$1.getLog(tp, x$2).isEmpty());
        });
        this.createTopic(this.topic(), partitionNum, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$3 = new TopicPartition(this.topic(), partition);
            boolean x$4 = qual$2.getLog$default$2();
            Assertions.assertEquals((Object)logDir1, (Object)((UnifiedLog)qual$2.getLog(x$3, x$4).get()).dir().getParent());
        });
        String logDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir2)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.findErrorForPartition(alterReplicaLogDirsResponse2, tp));
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequest$6(this, logDir2, partition)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"timed out waiting for replica movement");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirsRequestErrorCode() {
        String offlineDir = new File((String)((IterableOps)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        String validDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(1)).getAbsolutePath();
        String validDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(2)).getAbsolutePath();
        String validDir3 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(3)).getAbsolutePath();
        scala.collection.mutable.Map partitionDirs1 = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir1);
        AlterReplicaLogDirsResponse alterReplicaDirResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, (Object)this.findErrorForPartition(alterReplicaDirResponse1, new TopicPartition(this.topic(), 0)));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)this.findErrorForPartition(alterReplicaDirResponse1, new TopicPartition(this.topic(), 1)));
        this.createTopic(this.topic(), 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        scala.collection.mutable.Map partitionDirs2 = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir2);
        AlterReplicaLogDirsResponse alterReplicaDirResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, (Object)this.findErrorForPartition(alterReplicaDirResponse2, new TopicPartition(this.topic(), 0)));
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.findErrorForPartition(alterReplicaDirResponse2, new TopicPartition(this.topic(), 1)));
        ((KafkaServer)this.servers().head()).logDirFailureChannel().maybeAddOfflineLogDir(offlineDir, "", new IOException());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 3000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequestErrorCode$1(this, offlineDir)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequestErrorCode$2(offlineDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.mutable.Map partitionDirs3 = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir3);
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 2), (Object)offlineDir);
        AlterReplicaLogDirsResponse alterReplicaDirResponse3 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs3.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Assertions.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, (Object)this.findErrorForPartition(alterReplicaDirResponse3, new TopicPartition(this.topic(), 0)));
        Assertions.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, (Object)this.findErrorForPartition(alterReplicaDirResponse3, new TopicPartition(this.topic(), 1)));
        Assertions.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, (Object)this.findErrorForPartition(alterReplicaDirResponse3, new TopicPartition(this.topic(), 2)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirsRequestWithRetention() {
        int partitionNum = 1;
        String logDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(1)).getAbsolutePath();
        Map partitionDirs1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir1)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1);
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)this.findErrorForPartition(alterReplicaLogDirsResponse1, tp));
        LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(tp, x$2).isEmpty());
        Properties topicProperties = new Properties();
        topicProperties.put("retention.bytes", "1024");
        topicProperties.put("file.delete.delay.ms", "10000");
        topicProperties.put("segment.bytes", "1024");
        this.createTopic(this.topic(), partitionNum, 1, topicProperties, this.createTopic$default$5(), this.createTopic$default$6());
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Object)logDir1, (Object)((UnifiedLog)qual$2.getLog(tp, x$4).get()).dir().getParent());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$1 -> TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.topic(), 10, 1));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequestWithRetention$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for log segment to roll");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequestWithRetention$5(logDir1, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"timed out waiting for log segment to retention");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        String logDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(2)).getAbsolutePath();
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)logDir2)}))));
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.findErrorForPartition(alterReplicaLogDirsResponse2, tp));
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequestWithRetention$8(this, logDir2, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"timed out waiting for replica movement");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequestWithRetention$10(logDir2, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"timed out waiting for removing deleted log segment");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
    }

    private AlterReplicaLogDirsResponse sendAlterReplicaLogDirsRequest(Map<TopicPartition, String> partitionDirs) {
        scala.collection.immutable.Iterable logDirs = (scala.collection.immutable.Iterable)partitionDirs.groupBy((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (String)x0$1._2();
            }
            throw new MatchError(null);
        }).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String dir = (String)x0$2._1();
                Map tps = (Map)x0$2._2();
                return new AlterReplicaLogDirsRequestData.AlterReplicaLogDir().setPath(dir).setTopics(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopicCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)tps.groupBy((Function1 & Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        return ((TopicPartition)x0$3._1()).topic();
                    }
                    throw new MatchError(null);
                }).map((Function1 & Serializable)x0$4 -> {
                    if (x0$4 != null) {
                        String topic = (String)x0$4._1();
                        Map tpPartitions = (Map)x0$4._2();
                        return new AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic().setName(topic).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)tpPartitions.map((Function1 & Serializable)x0$5 -> {
                            if (x0$5 != null) {
                                return BoxesRunTime.boxToInteger((int)((TopicPartition)x0$5._1()).partition());
                            }
                            throw new MatchError(null);
                        })).toList()).asJava());
                    }
                    throw new MatchError(null);
                })).toList()).asJava().iterator()));
            }
            throw new MatchError(null);
        });
        AlterReplicaLogDirsRequestData data = new AlterReplicaLogDirsRequestData().setDirs(new AlterReplicaLogDirsRequestData.AlterReplicaLogDirCollection(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)logDirs).asJava().iterator()));
        AlterReplicaLogDirsRequest request = (AlterReplicaLogDirsRequest)new AlterReplicaLogDirsRequest.Builder(data).build();
        return (AlterReplicaLogDirsResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterReplicaLogDirsResponse.class));
    }

    public static final /* synthetic */ boolean $anonfun$findErrorForPartition$1(TopicPartition tp$1, AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult x) {
        String string = x.topicName();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findErrorForPartition$2(TopicPartition tp$1, AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult p) {
        return p.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirsRequest$6(AlterReplicaLogDirsRequestTest $this, String logDir2$1, int partition$1) {
        String string = logDir2$1;
        LogManager qual$3 = ((KafkaServer)$this.servers().head()).logManager();
        TopicPartition x$5 = new TopicPartition($this.topic(), partition$1);
        boolean x$6 = qual$3.getLog$default$2();
        String string2 = ((UnifiedLog)qual$3.getLog(x$5, x$6).get()).dir().getParent();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirsRequest$7() {
        return "timed out waiting for replica movement";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirsRequestErrorCode$1(AlterReplicaLogDirsRequestTest $this, String offlineDir$1) {
        return !((KafkaServer)$this.servers().head()).logManager().isLogDirOnline(offlineDir$1);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirsRequestErrorCode$2(String offlineDir$1) {
        return new StringBuilder(36).append("timed out waiting for ").append(offlineDir$1).append(" to be offline").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirsRequestWithRetention$3(AlterReplicaLogDirsRequestTest $this) {
        boolean x$6;
        TopicPartition x$5;
        LogManager qual$3 = ((KafkaServer)$this.servers().head()).logManager();
        return ((UnifiedLog)qual$3.getLog(x$5 = new TopicPartition($this.topic(), 0), x$6 = qual$3.getLog$default$2()).get()).numberOfSegments() > 1;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirsRequestWithRetention$4() {
        return "timed out waiting for log segment to roll";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirsRequestWithRetention$6(File x$2) {
        return x$2.getName().endsWith(".deleted");
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirsRequestWithRetention$5(String logDir1$2, TopicPartition tp$2) {
        return ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])new File(logDir1$2, tp$2.toString()).listFiles()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequestWithRetention$6(x$2))) > 0;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirsRequestWithRetention$7() {
        return "timed out waiting for log segment to retention";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirsRequestWithRetention$8(AlterReplicaLogDirsRequestTest $this, String logDir2$2, TopicPartition tp$2) {
        String string = logDir2$2;
        LogManager qual$4 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$8 = qual$4.getLog$default$2();
        String string2 = ((UnifiedLog)qual$4.getLog(tp$2, x$8).get()).dir().getParent();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirsRequestWithRetention$9() {
        return "timed out waiting for replica movement";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirsRequestWithRetention$11(File x$3) {
        return x$3.getName().endsWith(".deleted");
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirsRequestWithRetention$10(String logDir2$2, TopicPartition tp$2) {
        return ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])new File(logDir2$2, tp$2.toString()).listFiles()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterReplicaLogDirsRequestTest.$anonfun$testAlterReplicaLogDirsRequestWithRetention$11(x$3))) == 0;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirsRequestWithRetention$12() {
        return "timed out waiting for removing deleted log segment";
    }

    public AlterReplicaLogDirsRequestTest() {
        this.logDirCount = 5;
        this.brokerCount = 1;
        this.topic = "topic";
    }
}

