/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.introspection;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20IntrospectionEndpointController;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenResponse;
import org.apereo.cas.ticket.OAuth20TokenSigningAndEncryptionService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class OidcIntrospectionEndpointController
extends OAuth20IntrospectionEndpointController<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcIntrospectionEndpointController.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    public OidcIntrospectionEndpointController(OidcConfigurationContext context) {
        super((OAuth20ConfigurationContext)context);
    }

    @GetMapping(consumes={"application/token-introspection+jwt", "application/x-www-form-urlencoded", "application/json"}, produces={"application/token-introspection+jwt", "application/json"}, value={"/oidc/introspect", "/**/introspect"})
    public ResponseEntity handleRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "introspect")) {
            Map body = OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer");
            return new ResponseEntity((Object)body, (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return super.handleRequest(request, response);
    }

    @PostMapping(consumes={"application/token-introspection+jwt", "application/json", "application/x-www-form-urlencoded"}, produces={"application/json", "application/token-introspection+jwt"}, value={"/oidc/introspect", "/**/introspect"})
    public ResponseEntity handlePostRequest(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return super.handlePostRequest(request, response);
    }

    protected ResponseEntity buildIntrospectionEntityResponse(WebContext context, OAuth20IntrospectionAccessTokenResponse introspect) {
        ResponseEntity responseEntity = super.buildIntrospectionEntityResponse(context, introspect);
        return context.getRequestHeader("Accept").filter(headerValue -> StringUtils.equalsAnyIgnoreCase((CharSequence)headerValue, (CharSequence[])new CharSequence[]{"application/token-introspection+jwt"})).map(headerValue -> {
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager(), (String)introspect.getClientId());
            OAuth20TokenSigningAndEncryptionService signingAndEncryptionService = ((OidcConfigurationContext)this.getConfigurationContext()).getIntrospectionSigningAndEncryptionService();
            return (ResponseEntity)FunctionUtils.doAndHandle(() -> {
                if (signingAndEncryptionService.shouldSignToken(registeredService) || signingAndEncryptionService.shouldEncryptToken(registeredService)) {
                    return this.signAndEncryptIntrospection(context, introspect, registeredService);
                }
                return this.buildPlainIntrospectionClaims(context, introspect, registeredService);
            }, e -> ResponseEntity.badRequest().body((Object)"Unable to produce introspection JWT claims")).get();
        }).orElse(responseEntity);
    }

    protected ResponseEntity<String> buildPlainIntrospectionClaims(WebContext context, OAuth20IntrospectionAccessTokenResponse introspect, OAuthRegisteredService registeredService) throws Exception {
        JwtClaims claims = this.convertIntrospectionIntoClaims(introspect, registeredService);
        PlainJWT jwt = new PlainJWT(JWTClaimsSet.parse((Map)claims.getClaimsMap()));
        String jwtRequest = jwt.serialize();
        return OidcIntrospectionEndpointController.buildResponseEntity(jwtRequest, registeredService);
    }

    private JwtClaims convertIntrospectionIntoClaims(OAuth20IntrospectionAccessTokenResponse introspect, OAuthRegisteredService registeredService) throws Exception {
        OAuth20TokenSigningAndEncryptionService signingAndEncryptionService = ((OidcConfigurationContext)this.getConfigurationContext()).getIntrospectionSigningAndEncryptionService();
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(signingAndEncryptionService.resolveIssuer(Optional.of(registeredService)));
        claims.setAudience(registeredService.getClientId());
        claims.setIssuedAt(NumericDate.now());
        claims.setJwtId(UUID.randomUUID().toString());
        claims.setClaim("token_introspection", MAPPER.readValue(MAPPER.writeValueAsString((Object)introspect), Map.class));
        return claims;
    }

    protected ResponseEntity<String> signAndEncryptIntrospection(WebContext context, OAuth20IntrospectionAccessTokenResponse introspect, OAuthRegisteredService registeredService) throws Throwable {
        JwtClaims claims = this.convertIntrospectionIntoClaims(introspect, registeredService);
        LOGGER.debug("Collected introspection claims, before cipher operations, are [{}]", (Object)claims);
        OAuth20TokenSigningAndEncryptionService signingAndEncryptionService = ((OidcConfigurationContext)this.getConfigurationContext()).getIntrospectionSigningAndEncryptionService();
        String result = signingAndEncryptionService.encode(registeredService, claims);
        LOGGER.debug("Finalized introspection JWT is [{}]", (Object)result);
        return OidcIntrospectionEndpointController.buildResponseEntity(result, registeredService);
    }

    private static ResponseEntity<String> buildResponseEntity(String result, OAuthRegisteredService registeredService) {
        Map context = CollectionUtils.wrap((String)"Content-Type", (Object)"application/token-introspection+jwt", (String)"Client ID", (Object)registeredService.getClientId(), (String)"Service", (Object)registeredService.getName());
        LoggingUtils.protocolMessage((String)"OpenID Connect Introspection Response", (Map)context, (Object)result);
        HttpHeaders headers = new HttpHeaders();
        headers.put("Content-Type", CollectionUtils.wrapList((Object[])new String[]{"application/token-introspection+jwt"}));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)result);
    }
}

