/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.authorize;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.web.controllers.authorize.OidcAuthorizeEndpointController;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

public class OidcPushedAuthorizeEndpointController
extends OidcAuthorizeEndpointController {
    public OidcPushedAuthorizeEndpointController(OidcConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @Override
    @GetMapping(value={"/**/oidcPushAuthorize"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) {
        return OAuth20Utils.produceUnauthorizedErrorView((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED);
    }

    @Override
    @PostMapping(value={"/**/oidcPushAuthorize"})
    public ModelAndView handleRequestPost(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "oidcPushAuthorize")) {
            return OAuth20Utils.writeError((HttpServletResponse)response, (String)"invalid_request", (String)"Invalid issuer");
        }
        return super.handleRequest(request, response);
    }
}

