/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.SslTransportLayerTest;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class SslVersionsTransportLayerTest {
    private static final int BUFFER_SIZE = 4096;
    private static final Time TIME = Time.SYSTEM;

    public static Stream<Arguments> parameters() {
        ArrayList<Arguments> parameters = new ArrayList<Arguments>();
        parameters.add(Arguments.of((Object[])new Object[]{Collections.singletonList("TLSv1.2"), Collections.singletonList("TLSv1.2")}));
        if (Java.IS_JAVA11_COMPATIBLE) {
            parameters.add(Arguments.of((Object[])new Object[]{Collections.singletonList("TLSv1.2"), Collections.singletonList("TLSv1.3")}));
            parameters.add(Arguments.of((Object[])new Object[]{Collections.singletonList("TLSv1.3"), Collections.singletonList("TLSv1.2")}));
            parameters.add(Arguments.of((Object[])new Object[]{Collections.singletonList("TLSv1.3"), Collections.singletonList("TLSv1.3")}));
            parameters.add(Arguments.of((Object[])new Object[]{Collections.singletonList("TLSv1.2"), Arrays.asList("TLSv1.2", "TLSv1.3")}));
            parameters.add(Arguments.of((Object[])new Object[]{Collections.singletonList("TLSv1.2"), Arrays.asList("TLSv1.3", "TLSv1.2")}));
            parameters.add(Arguments.of((Object[])new Object[]{Collections.singletonList("TLSv1.3"), Arrays.asList("TLSv1.2", "TLSv1.3")}));
            parameters.add(Arguments.of((Object[])new Object[]{Collections.singletonList("TLSv1.3"), Arrays.asList("TLSv1.3", "TLSv1.2")}));
            parameters.add(Arguments.of((Object[])new Object[]{Arrays.asList("TLSv1.3", "TLSv1.2"), Collections.singletonList("TLSv1.3")}));
            parameters.add(Arguments.of((Object[])new Object[]{Arrays.asList("TLSv1.3", "TLSv1.2"), Collections.singletonList("TLSv1.2")}));
            parameters.add(Arguments.of((Object[])new Object[]{Arrays.asList("TLSv1.3", "TLSv1.2"), Arrays.asList("TLSv1.2", "TLSv1.3")}));
            parameters.add(Arguments.of((Object[])new Object[]{Arrays.asList("TLSv1.3", "TLSv1.2"), Arrays.asList("TLSv1.3", "TLSv1.2")}));
            parameters.add(Arguments.of((Object[])new Object[]{Arrays.asList("TLSv1.2", "TLSv1.3"), Collections.singletonList("TLSv1.3")}));
            parameters.add(Arguments.of((Object[])new Object[]{Arrays.asList("TLSv1.2", "TLSv1.3"), Collections.singletonList("TLSv1.2")}));
            parameters.add(Arguments.of((Object[])new Object[]{Arrays.asList("TLSv1.2", "TLSv1.3"), Arrays.asList("TLSv1.2", "TLSv1.3")}));
            parameters.add(Arguments.of((Object[])new Object[]{Arrays.asList("TLSv1.2", "TLSv1.3"), Arrays.asList("TLSv1.3", "TLSv1.2")}));
        }
        return parameters.stream();
    }

    @ParameterizedTest(name="tlsServerProtocol = {0}, tlsClientProtocol = {1}")
    @MethodSource(value={"parameters"})
    public void testTlsDefaults(List<String> serverProtocols, List<String> clientProtocols) throws Exception {
        CertStores serverCertStores = new CertStores(true, "server", "localhost");
        CertStores clientCertStores = new CertStores(false, "client", "localhost");
        Map<String, Object> sslClientConfigs = SslVersionsTransportLayerTest.getTrustingConfig(clientCertStores, serverCertStores, clientProtocols);
        Map<String, Object> sslServerConfigs = SslVersionsTransportLayerTest.getTrustingConfig(serverCertStores, clientCertStores, serverProtocols);
        NioEchoServer server = NetworkTestUtils.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), SecurityProtocol.SSL, new TestSecurityConfig(sslServerConfigs), null, TIME);
        Selector selector = this.createClientSelector(sslClientConfigs);
        String node = "0";
        selector.connect(node, new InetSocketAddress("localhost", server.port()), 4096, 4096);
        if (this.isCompatible(serverProtocols, clientProtocols)) {
            NetworkTestUtils.waitForChannelReady(selector, node);
            int msgSz = 0x100000;
            String message = TestUtils.randomString(msgSz);
            selector.send(new NetworkSend(node, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)ByteBuffer.wrap(message.getBytes()))));
            while (selector.completedReceives().isEmpty()) {
                selector.poll(100L);
            }
            int totalBytes = msgSz + 4;
            server.waitForMetric("incoming-byte", totalBytes);
            server.waitForMetric("outgoing-byte", totalBytes);
            server.waitForMetric("request", 1.0);
            server.waitForMetric("response", 1.0);
        } else {
            NetworkTestUtils.waitForChannelClose(selector, node, ChannelState.State.AUTHENTICATION_FAILED);
            server.verifyAuthenticationMetrics(0, 1);
        }
        server.close();
        selector.close();
    }

    private boolean isCompatible(List<String> serverProtocols, List<String> clientProtocols) {
        Assertions.assertNotNull(serverProtocols);
        Assertions.assertFalse((boolean)serverProtocols.isEmpty());
        Assertions.assertNotNull(clientProtocols);
        Assertions.assertFalse((boolean)clientProtocols.isEmpty());
        return serverProtocols.contains(clientProtocols.get(0)) || clientProtocols.get(0).equals("TLSv1.3") && !Collections.disjoint(serverProtocols, clientProtocols);
    }

    private static Map<String, Object> getTrustingConfig(CertStores certStores, CertStores peerCertStores, List<String> tlsProtocols) {
        Map<String, Object> configs = certStores.getTrustingConfig(peerCertStores);
        configs.putAll(SslVersionsTransportLayerTest.sslConfig(tlsProtocols));
        return configs;
    }

    private static Map<String, Object> sslConfig(List<String> tlsProtocols) {
        HashMap<String, Object> sslConfig = new HashMap<String, Object>();
        sslConfig.put("ssl.protocol", tlsProtocols.get(0));
        sslConfig.put("ssl.enabled.protocols", tlsProtocols);
        return sslConfig;
    }

    private Selector createClientSelector(Map<String, Object> sslClientConfigs) {
        SslTransportLayerTest.TestSslChannelBuilder channelBuilder = new SslTransportLayerTest.TestSslChannelBuilder(Mode.CLIENT);
        channelBuilder.configureBufferSizes(null, null, null);
        channelBuilder.configure(sslClientConfigs);
        return new Selector(500000L, new Metrics(), TIME, "MetricGroup", (ChannelBuilder)channelBuilder, new LogContext());
    }
}

