/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.clients.consumer.internals.OffsetCommitCallbackInvoker;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class OffsetCommitCallbackInvokerTest {
    @Mock
    private ConsumerInterceptors<?, ?> consumerInterceptors;
    private OffsetCommitCallbackInvoker offsetCommitCallbackInvoker;

    @BeforeEach
    public void setup() {
        this.offsetCommitCallbackInvoker = new OffsetCommitCallbackInvoker(this.consumerInterceptors);
    }

    @Test
    public void testMultipleUserCallbacksInvoked() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        Map<TopicPartition, OffsetAndMetadata> offsets1 = Collections.singletonMap(t0, new OffsetAndMetadata(10L));
        Map<TopicPartition, OffsetAndMetadata> offsets2 = Collections.singletonMap(t0, new OffsetAndMetadata(20L));
        OffsetCommitCallback callback1 = (OffsetCommitCallback)Mockito.mock(OffsetCommitCallback.class);
        OffsetCommitCallback callback2 = (OffsetCommitCallback)Mockito.mock(OffsetCommitCallback.class);
        this.offsetCommitCallbackInvoker.enqueueUserCallbackInvocation(callback1, offsets1, null);
        this.offsetCommitCallbackInvoker.enqueueUserCallbackInvocation(callback2, offsets2, null);
        ((OffsetCommitCallback)Mockito.verify((Object)callback1, (VerificationMode)Mockito.never())).onComplete((Map)ArgumentMatchers.any(), (Exception)ArgumentMatchers.any());
        ((OffsetCommitCallback)Mockito.verify((Object)callback2, (VerificationMode)Mockito.never())).onComplete((Map)ArgumentMatchers.any(), (Exception)ArgumentMatchers.any());
        this.offsetCommitCallbackInvoker.executeCallbacks();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{callback1, callback2});
        ((OffsetCommitCallback)inOrder.verify((Object)callback1)).onComplete(offsets1, null);
        ((OffsetCommitCallback)inOrder.verify((Object)callback2)).onComplete(offsets2, null);
        this.offsetCommitCallbackInvoker.executeCallbacks();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testNoOnCommitOnEmptyInterceptors() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        Map<TopicPartition, OffsetAndMetadata> offsets1 = Collections.singletonMap(t0, new OffsetAndMetadata(10L));
        Map<TopicPartition, OffsetAndMetadata> offsets2 = Collections.singletonMap(t0, new OffsetAndMetadata(20L));
        Mockito.when((Object)this.consumerInterceptors.isEmpty()).thenReturn((Object)true);
        this.offsetCommitCallbackInvoker.enqueueInterceptorInvocation(offsets1);
        this.offsetCommitCallbackInvoker.enqueueInterceptorInvocation(offsets2);
        this.offsetCommitCallbackInvoker.executeCallbacks();
        ((ConsumerInterceptors)Mockito.verify(this.consumerInterceptors, (VerificationMode)Mockito.never())).onCommit((Map)ArgumentMatchers.any());
    }

    @Test
    public void testOnlyInterceptors() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        Map<TopicPartition, OffsetAndMetadata> offsets1 = Collections.singletonMap(t0, new OffsetAndMetadata(10L));
        Map<TopicPartition, OffsetAndMetadata> offsets2 = Collections.singletonMap(t0, new OffsetAndMetadata(20L));
        Mockito.when((Object)this.consumerInterceptors.isEmpty()).thenReturn((Object)false);
        this.offsetCommitCallbackInvoker.enqueueInterceptorInvocation(offsets1);
        this.offsetCommitCallbackInvoker.enqueueInterceptorInvocation(offsets2);
        ((ConsumerInterceptors)Mockito.verify(this.consumerInterceptors, (VerificationMode)Mockito.never())).onCommit((Map)ArgumentMatchers.any());
        this.offsetCommitCallbackInvoker.executeCallbacks();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.consumerInterceptors});
        ((ConsumerInterceptors)inOrder.verify(this.consumerInterceptors)).onCommit(offsets1);
        ((ConsumerInterceptors)inOrder.verify(this.consumerInterceptors)).onCommit(offsets2);
        this.offsetCommitCallbackInvoker.executeCallbacks();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testMixedCallbacksInterceptorsInvoked() {
        TopicPartition t0 = new TopicPartition("t0", 2);
        Map<TopicPartition, OffsetAndMetadata> offsets1 = Collections.singletonMap(t0, new OffsetAndMetadata(10L));
        Map<TopicPartition, OffsetAndMetadata> offsets2 = Collections.singletonMap(t0, new OffsetAndMetadata(20L));
        OffsetCommitCallback callback1 = (OffsetCommitCallback)Mockito.mock(OffsetCommitCallback.class);
        Mockito.when((Object)this.consumerInterceptors.isEmpty()).thenReturn((Object)false);
        this.offsetCommitCallbackInvoker.enqueueInterceptorInvocation(offsets1);
        this.offsetCommitCallbackInvoker.enqueueInterceptorInvocation(offsets2);
        this.offsetCommitCallbackInvoker.enqueueUserCallbackInvocation(callback1, offsets1, null);
        ((OffsetCommitCallback)Mockito.verify((Object)callback1, (VerificationMode)Mockito.never())).onComplete((Map)ArgumentMatchers.any(), (Exception)ArgumentMatchers.any());
        ((ConsumerInterceptors)Mockito.verify(this.consumerInterceptors, (VerificationMode)Mockito.never())).onCommit((Map)ArgumentMatchers.any());
        this.offsetCommitCallbackInvoker.executeCallbacks();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{callback1, this.consumerInterceptors});
        ((ConsumerInterceptors)inOrder.verify(this.consumerInterceptors)).onCommit(offsets1);
        ((ConsumerInterceptors)inOrder.verify(this.consumerInterceptors)).onCommit(offsets2);
        ((OffsetCommitCallback)inOrder.verify((Object)callback1)).onComplete(offsets1, null);
        this.offsetCommitCallbackInvoker.executeCallbacks();
        inOrder.verifyNoMoreInteractions();
    }
}

