/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PrincipalElectionStrategyConflictResolver;
import org.apereo.cas.authentication.adaptive.intel.BlackDotIPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.DefaultIPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.GroovyIPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.IPAddressIntelligenceService;
import org.apereo.cas.authentication.adaptive.intel.RestfulIPAddressIntelligenceService;
import org.apereo.cas.authentication.policy.AllAuthenticationHandlersSucceededAuthenticationPolicy;
import org.apereo.cas.authentication.policy.AllCredentialsValidatedAuthenticationPolicy;
import org.apereo.cas.authentication.policy.AtLeastOneCredentialValidatedAuthenticationPolicy;
import org.apereo.cas.authentication.policy.BaseAuthenticationPolicy;
import org.apereo.cas.authentication.policy.GroovyScriptAuthenticationPolicy;
import org.apereo.cas.authentication.policy.NotPreventedAuthenticationPolicy;
import org.apereo.cas.authentication.policy.RequiredAttributesAuthenticationPolicy;
import org.apereo.cas.authentication.policy.RequiredAuthenticationHandlerAuthenticationPolicy;
import org.apereo.cas.authentication.policy.RestfulAuthenticationPolicy;
import org.apereo.cas.authentication.principal.merger.AttributeMerger;
import org.apereo.cas.authentication.principal.merger.MultivaluedAttributeMerger;
import org.apereo.cas.authentication.principal.merger.NoncollidingAttributeAdder;
import org.apereo.cas.authentication.principal.merger.ReplacingAttributeAdder;
import org.apereo.cas.authentication.principal.merger.ReturnChangesAttributeMerger;
import org.apereo.cas.authentication.principal.merger.ReturnOriginalAttributeMerger;
import org.apereo.cas.authentication.support.password.DefaultPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.support.password.GroovyPasswordPolicyHandlingStrategy;
import org.apereo.cas.authentication.support.password.RejectResultCodePasswordPolicyHandlingStrategy;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationIPIntelligenceProperties;
import org.apereo.cas.configuration.model.core.authentication.AdaptiveAuthenticationProperties;
import org.apereo.cas.configuration.model.core.authentication.AuthenticationPolicyProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordPolicyProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.core.authentication.policy.BaseAuthenticationPolicyProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public final class CoreAuthenticationUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreAuthenticationUtils.class);

    public static Map<String, Object> convertAttributeValuesToObjects(Map<String, ?> attributes) {
        Set<Map.Entry<String, ?>> entries = attributes.entrySet();
        return entries.stream().map(entry -> Map.entry((String)entry.getKey(), entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Set value = CollectionUtils.toCollection(entry.getValue());
            return value.size() == 1 && !(value.iterator().next() instanceof Map) ? value.iterator().next() : value;
        }));
    }

    public static AttributeMerger getAttributeMerger(PrincipalAttributesCoreProperties.MergingStrategyTypes mergingPolicy) {
        switch (mergingPolicy) {
            case MULTIVALUED: {
                MultivaluedAttributeMerger merger = new MultivaluedAttributeMerger();
                merger.setDistinctValues(true);
                return merger;
            }
            case ADD: {
                return new NoncollidingAttributeAdder();
            }
            case SOURCE: {
                return new ReturnOriginalAttributeMerger();
            }
            case DESTINATION: {
                return new ReturnChangesAttributeMerger();
            }
        }
        return new ReplacingAttributeAdder();
    }

    public static boolean isRememberMeAuthentication(Authentication model, Assertion assertion) {
        Map authnAttributes = model.getAttributes();
        List authnMethod = (List)authnAttributes.get("org.apereo.cas.authentication.principal.REMEMBER_ME");
        return authnMethod != null && authnMethod.contains(Boolean.TRUE) && assertion.isFromNewLogin();
    }

    public static Boolean isRememberMeAuthentication(Authentication authentication) {
        if (authentication == null) {
            return Boolean.FALSE;
        }
        Map attributes = authentication.getAttributes();
        LOGGER.trace("Located authentication attributes [{}]", (Object)attributes);
        if (attributes.containsKey("org.apereo.cas.authentication.principal.REMEMBER_ME")) {
            List rememberMeValue = (List)attributes.get("org.apereo.cas.authentication.principal.REMEMBER_ME");
            LOGGER.debug("Located remember-me authentication attribute [{}]", (Object)rememberMeValue);
            return rememberMeValue.contains(Boolean.TRUE);
        }
        return Boolean.FALSE;
    }

    public static Map<String, List<Object>> mergeAttributes(Map<String, List<Object>> currentAttributes, Map<String, List<Object>> attributesToMerge, AttributeMerger merger) {
        Map<String, ArrayList> toModify = currentAttributes.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((ArrayList)CollectionUtils.toCollection(entry.getValue(), ArrayList.class)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        Map<String, ArrayList> toMerge = attributesToMerge.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((ArrayList)CollectionUtils.toCollection(entry.getValue(), ArrayList.class)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        LOGGER.trace("Merging current attributes [{}] with [{}]", toModify, toMerge);
        Map results = merger.mergeAttributes(toModify, toMerge);
        LOGGER.debug("Merged attributes with the final result as [{}]", (Object)results);
        return results;
    }

    public static Map<String, List<Object>> mergeAttributes(Map<String, List<Object>> currentAttributes, Map<String, List<Object>> attributesToMerge) {
        MultivaluedAttributeMerger merger = new MultivaluedAttributeMerger();
        merger.setDistinctValues(true);
        return CoreAuthenticationUtils.mergeAttributes(currentAttributes, attributesToMerge, merger);
    }

    public static Map<String, Object> transformPrincipalAttributesListIntoMap(List<String> list) {
        Multimap<String, Object> map = CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap(list);
        return CollectionUtils.wrap(map);
    }

    public static Multimap<String, Object> transformPrincipalAttributesListIntoMultiMap(List<String> list) {
        ArrayListMultimap attributes = ArrayListMultimap.create();
        if (list.isEmpty()) {
            LOGGER.debug("No principal attributes are defined");
        } else {
            list.forEach(a -> {
                String attributeName = a.trim();
                if (attributeName.contains(":")) {
                    List attrCombo = Splitter.on((String)":").splitToList((CharSequence)attributeName);
                    String name = ((String)attrCombo.getFirst()).trim();
                    String value = ((String)attrCombo.get(1)).trim();
                    LOGGER.debug("Mapped principal attribute name [{}] to [{}]", (Object)name, (Object)value);
                    attributes.put((Object)name, (Object)value);
                } else {
                    LOGGER.debug("Mapped principal attribute name [{}]", (Object)attributeName);
                    attributes.put((Object)attributeName, (Object)attributeName);
                }
            });
        }
        return attributes;
    }

    public static Predicate<Credential> newCredentialSelectionPredicate(String selectionCriteria) {
        try {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectionCriteria)) {
                return credential -> true;
            }
            Optional scriptFactoryInstance = ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory();
            if (scriptFactoryInstance.isPresent() && ((ExecutableCompiledScriptFactory)scriptFactoryInstance.get()).isExternalScript(selectionCriteria) && CasRuntimeHintsRegistrar.notInNativeImage()) {
                DefaultResourceLoader loader = new DefaultResourceLoader();
                Resource resource = loader.getResource(selectionCriteria);
                String script = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                ExecutableCompiledScriptFactory scriptFactory = (ExecutableCompiledScriptFactory)scriptFactoryInstance.get();
                return (Predicate)scriptFactory.newObjectInstance(script, Predicate.class);
            }
            Class predicateClazz = ClassUtils.getClass((String)selectionCriteria);
            return (Predicate)predicateClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Predicate<String> predicate = Pattern.compile(selectionCriteria).asPredicate();
            return credential -> predicate.test(credential.getId());
        }
    }

    public static AuthenticationPasswordPolicyHandlingStrategy newPasswordPolicyHandlingStrategy(PasswordPolicyProperties properties, ApplicationContext applicationContext) {
        if (properties.getStrategy() == PasswordPolicyProperties.PasswordPolicyHandlingOptions.REJECT_RESULT_CODE) {
            LOGGER.debug("Created password policy handling strategy based on blocked authentication result codes");
            return new RejectResultCodePasswordPolicyHandlingStrategy();
        }
        Resource location = properties.getGroovy().getLocation();
        if (properties.getStrategy() == PasswordPolicyProperties.PasswordPolicyHandlingOptions.GROOVY && location != null && CasRuntimeHintsRegistrar.notInNativeImage()) {
            LOGGER.debug("Created password policy handling strategy based on Groovy script [{}]", (Object)location);
            return new GroovyPasswordPolicyHandlingStrategy(location, applicationContext);
        }
        LOGGER.trace("Created default password policy handling strategy");
        return new DefaultPasswordPolicyHandlingStrategy();
    }

    public static Collection<AuthenticationPolicy> newAuthenticationPolicy(AuthenticationPolicyProperties policyProps) {
        if (policyProps.getReq().isEnabled()) {
            Set requiredHandlerNames = StringUtils.commaDelimitedListToSet((String)policyProps.getReq().getHandlerName());
            RequiredAuthenticationHandlerAuthenticationPolicy policy = new RequiredAuthenticationHandlerAuthenticationPolicy(requiredHandlerNames, policyProps.getReq().isTryAll());
            return CollectionUtils.wrapList((Object[])new AuthenticationPolicy[]{CoreAuthenticationUtils.configureAuthenticationPolicy(policy, (BaseAuthenticationPolicyProperties)policyProps.getReq())});
        }
        if (policyProps.getRequiredAttributes().isEnabled()) {
            RequiredAttributesAuthenticationPolicy policy = new RequiredAttributesAuthenticationPolicy(policyProps.getRequiredAttributes().getAttributes());
            return CollectionUtils.wrapList((Object[])new AuthenticationPolicy[]{CoreAuthenticationUtils.configureAuthenticationPolicy(policy, (BaseAuthenticationPolicyProperties)policyProps.getRequiredAttributes())});
        }
        if (policyProps.getAllHandlers().isEnabled()) {
            AllAuthenticationHandlersSucceededAuthenticationPolicy policy = new AllAuthenticationHandlersSucceededAuthenticationPolicy();
            return CollectionUtils.wrapList((Object[])new AuthenticationPolicy[]{CoreAuthenticationUtils.configureAuthenticationPolicy(policy, (BaseAuthenticationPolicyProperties)policyProps.getAllHandlers())});
        }
        if (policyProps.getAll().isEnabled()) {
            AllCredentialsValidatedAuthenticationPolicy policy = new AllCredentialsValidatedAuthenticationPolicy();
            return CollectionUtils.wrapList((Object[])new AuthenticationPolicy[]{CoreAuthenticationUtils.configureAuthenticationPolicy(policy, (BaseAuthenticationPolicyProperties)policyProps.getAll())});
        }
        if (policyProps.getNotPrevented().isEnabled()) {
            NotPreventedAuthenticationPolicy policy = new NotPreventedAuthenticationPolicy();
            return CollectionUtils.wrapList((Object[])new AuthenticationPolicy[]{CoreAuthenticationUtils.configureAuthenticationPolicy(policy, (BaseAuthenticationPolicyProperties)policyProps.getNotPrevented())});
        }
        if (!policyProps.getGroovy().isEmpty() && CasRuntimeHintsRegistrar.notInNativeImage()) {
            return policyProps.getGroovy().stream().map(groovy -> {
                GroovyScriptAuthenticationPolicy policy = new GroovyScriptAuthenticationPolicy(groovy.getScript());
                return CoreAuthenticationUtils.configureAuthenticationPolicy(policy, (BaseAuthenticationPolicyProperties)groovy);
            }).collect(Collectors.toList());
        }
        if (!policyProps.getRest().isEmpty()) {
            return policyProps.getRest().stream().map(RestfulAuthenticationPolicy::new).collect(Collectors.toList());
        }
        if (policyProps.getAny().isEnabled()) {
            AtLeastOneCredentialValidatedAuthenticationPolicy policy = new AtLeastOneCredentialValidatedAuthenticationPolicy(policyProps.getAny().isTryAll());
            return CollectionUtils.wrapList((Object[])new AuthenticationPolicy[]{CoreAuthenticationUtils.configureAuthenticationPolicy(policy, (BaseAuthenticationPolicyProperties)policyProps.getAny())});
        }
        return new ArrayList<AuthenticationPolicy>();
    }

    private static AuthenticationPolicy configureAuthenticationPolicy(BaseAuthenticationPolicy policy, BaseAuthenticationPolicyProperties properties) {
        return policy.setName((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)properties.getName(), (CharSequence)policy.getClass().getSimpleName())).setOrder(properties.getOrder());
    }

    public static IPAddressIntelligenceService newIpAddressIntelligenceService(AdaptiveAuthenticationProperties adaptive) {
        AdaptiveAuthenticationIPIntelligenceProperties intel = adaptive.getIpIntel();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)intel.getRest().getUrl())) {
            return new RestfulIPAddressIntelligenceService(adaptive);
        }
        if (intel.getGroovy().getLocation() != null && CasRuntimeHintsRegistrar.notInNativeImage()) {
            return new GroovyIPAddressIntelligenceService(adaptive);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)intel.getBlackDot().getEmailAddress())) {
            return new BlackDotIPAddressIntelligenceService(adaptive);
        }
        return new DefaultIPAddressIntelligenceService(adaptive);
    }

    public static PrincipalElectionStrategyConflictResolver newPrincipalElectionStrategyConflictResolver(PersonDirectoryPrincipalResolverProperties properties) {
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)properties.getPrincipalResolutionConflictStrategy(), (CharSequence)"first")) {
            return PrincipalElectionStrategyConflictResolver.first();
        }
        return PrincipalElectionStrategyConflictResolver.last();
    }

    @Generated
    private CoreAuthenticationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

