/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import io.micrometer.observation.ObservationRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.integration.config.EnableIntegrationManagement;
import org.springframework.integration.config.IntegrationManagementConfigurer;
import org.springframework.integration.support.management.ControlBusCommandRegistry;
import org.springframework.integration.support.management.metrics.MetricsCaptor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
public class IntegrationManagementConfiguration
implements ImportAware,
EnvironmentAware {
    private final ControlBusCommandRegistry controlBusCommandRegistry;
    private AnnotationAttributes attributes;
    private Environment environment;

    public IntegrationManagementConfiguration(ControlBusCommandRegistry controlBusCommandRegistry) {
        this.controlBusCommandRegistry = controlBusCommandRegistry;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map map = importMetadata.getAnnotationAttributes(EnableIntegrationManagement.class.getName());
        this.attributes = AnnotationAttributes.fromMap((Map)map);
        Assert.notNull((Object)this.attributes, () -> "@EnableIntegrationManagement is not present on importing class " + importMetadata.getClassName());
        this.controlBusCommandRegistry.setEagerInitialization(Boolean.parseBoolean(this.environment.resolvePlaceholders(this.attributes.getString("loadControlBusCommands"))));
    }

    @Bean(name={"integrationManagementConfigurer"})
    @Role(value=2)
    public IntegrationManagementConfigurer managementConfigurer(ObjectProvider<MetricsCaptor> metricsCaptorProvider, ObjectProvider<ObservationRegistry> observationRegistryProvider) {
        IntegrationManagementConfigurer configurer = new IntegrationManagementConfigurer();
        configurer.setDefaultLoggingEnabled(Boolean.parseBoolean(this.environment.resolvePlaceholders((String)this.attributes.get((Object)"defaultLoggingEnabled"))));
        configurer.setMetricsCaptorProvider(metricsCaptorProvider);
        String[] observationPatterns = this.obtainObservationPatterns();
        if (observationPatterns.length > 0) {
            configurer.setObservationPatterns(observationPatterns);
            configurer.setObservationRegistry(observationRegistryProvider);
        }
        return configurer;
    }

    private String[] obtainObservationPatterns() {
        Collection<String> observationPatterns = new HashSet();
        String[] patternsProperties = (String[])this.attributes.get((Object)"observationPatterns");
        boolean hasAsterisk = false;
        for (String patternProperty : patternsProperties) {
            String[] patternsToProcess;
            String patternValue = this.environment.resolvePlaceholders(patternProperty);
            for (String pattern2 : patternsToProcess = StringUtils.commaDelimitedListToStringArray((String)patternValue)) {
                if (!StringUtils.hasText((String)pattern2) || !pattern2.startsWith("!") && (hasAsterisk |= "*".equals(pattern2))) continue;
                observationPatterns.add(pattern2);
            }
        }
        if (hasAsterisk) {
            observationPatterns = observationPatterns.stream().filter(pattern -> pattern.startsWith("!")).collect(Collectors.toList());
            observationPatterns.add("*");
        }
        return observationPatterns.toArray(new String[0]);
    }
}

