/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.spel;

import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowVariablePropertyAccessor
implements PropertyAccessor {
    private static Map<String, FlowVariableAccessor> variables = new HashMap<String, FlowVariableAccessor>();

    public Class<?>[] getSpecificTargetClasses() {
        return null;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) {
        return variables.containsKey(name);
    }

    public TypedValue read(EvaluationContext context, Object target, String name) {
        FlowVariableAccessor var = variables.get(name);
        return new TypedValue(var.getVariable());
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new AccessException(name + " is a flow reserved word and cannot be set with an expression.");
    }

    static {
        variables.put("currentUser", () -> RequestContextHolder.getRequestContext().getExternalContext().getCurrentUser());
        variables.put("flowRequestContext", RequestContextHolder::getRequestContext);
        variables.put("resourceBundle", () -> RequestContextHolder.getRequestContext().getActiveFlow().getApplicationContext());
    }

    private static interface FlowVariableAccessor {
        public Object getVariable();
    }
}

