/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionConstructionException;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.engine.builder.FlowAssembler;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.FlowBuilderException;

public class DefaultFlowHolder
implements FlowDefinitionHolder {
    private static final Log logger = LogFactory.getLog(DefaultFlowHolder.class);
    private FlowDefinition flowDefinition;
    private FlowAssembler assembler;
    private boolean assembling;

    public DefaultFlowHolder(FlowAssembler assembler) {
        Assert.notNull((Object)assembler, (String)"The FlowAssembler is required");
        this.assembler = assembler;
    }

    @Override
    public String getFlowDefinitionId() {
        return this.assembler.getFlowBuilderContext().getFlowId();
    }

    @Override
    public String getFlowDefinitionResourceString() {
        return this.assembler.getFlowBuilder().getFlowResourceString();
    }

    @Override
    public synchronized FlowDefinition getFlowDefinition() throws FlowDefinitionConstructionException {
        if (this.assembling) {
            return this.getFlowBuilder().getFlow();
        }
        if (this.flowDefinition == null) {
            logger.debug((Object)"Assembling the flow for the first time");
            this.assembleFlow();
        } else if (this.flowDefinition.inDevelopment() && this.getFlowBuilder().hasFlowChanged()) {
            logger.debug((Object)"The flow under development has changed; reassembling...");
            this.assembleFlow();
        }
        return this.flowDefinition;
    }

    @Override
    public synchronized void refresh() throws FlowDefinitionConstructionException {
        this.assembleFlow();
    }

    @Override
    public void destroy() {
        if (this.flowDefinition != null) {
            this.flowDefinition.destroy();
        }
    }

    private void assembleFlow() throws FlowDefinitionConstructionException {
        try {
            this.assembling = true;
            this.flowDefinition = this.assembler.assembleFlow();
        }
        catch (FlowBuilderException e) {
            throw new FlowDefinitionConstructionException(this.assembler.getFlowBuilderContext().getFlowId(), e);
        }
        finally {
            this.assembling = false;
        }
    }

    private FlowBuilder getFlowBuilder() {
        return this.assembler.getFlowBuilder();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowBuilder", (Object)this.assembler.getFlowBuilder()).toString();
    }
}

