/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.persistence.jpa.upgrade;

import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;

@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class })
public class SyncopeCorePersistenceJPAUpgrader implements CommandLineRunner {

    private static final Logger LOG = LoggerFactory.getLogger(SyncopeCorePersistenceJPAUpgrader.class);

    public static void main(final String[] args) {
        SpringApplication.run(SyncopeCorePersistenceJPAUpgrader.class, args);
    }

    @Autowired
    private GenerateUpgradeSQL generateUpgradeSQL;

    @Override
    public void run(final String... args) throws Exception {
        Writer out;
        if (args.length > 0) {
            LOG.info("Sending upgrade statements to {}", args[0]);
            out = Files.newBufferedWriter(Path.of(args[0]), StandardCharsets.UTF_8);
        } else {
            LOG.info("Sending upgrade statements to stdout");
            out = new PrintWriter(System.out);
        }
        generateUpgradeSQL.run(out);
    }
}
