/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricValueStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class MetricValueStatusFluent<A extends MetricValueStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer averageUtilization;
    private Quantity averageValue;
    private Quantity value;

    public MetricValueStatusFluent() {
    }

    public MetricValueStatusFluent(MetricValueStatus instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    protected void copyInstance(MetricValueStatus instance) {
        MetricValueStatus metricValueStatus = instance = instance != null ? instance : new MetricValueStatus();
        if (instance != null) {
            this.withAverageUtilization(instance.getAverageUtilization());
            this.withAverageValue(instance.getAverageValue());
            this.withValue(instance.getValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetricValueStatusFluent that = (MetricValueStatusFluent)((Object)o);
        if (!Objects.equals(this.averageUtilization, that.averageUtilization)) {
            return false;
        }
        if (!Objects.equals(this.averageValue, that.averageValue)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getAverageUtilization() {
        return this.averageUtilization;
    }

    public Quantity getAverageValue() {
        return this.averageValue;
    }

    public Quantity getValue() {
        return this.value;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAverageUtilization() {
        return this.averageUtilization != null;
    }

    public boolean hasAverageValue() {
        return this.averageValue != null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public int hashCode() {
        return Objects.hash(this.averageUtilization, this.averageValue, this.value, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.averageUtilization != null) {
            sb.append("averageUtilization:");
            sb.append(this.averageUtilization);
            sb.append(",");
        }
        if (this.averageValue != null) {
            sb.append("averageValue:");
            sb.append(this.averageValue);
            sb.append(",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAverageUtilization(Integer averageUtilization) {
        this.averageUtilization = averageUtilization;
        return (A)((Object)this);
    }

    public A withAverageValue(Quantity averageValue) {
        this.averageValue = averageValue;
        return (A)((Object)this);
    }

    public A withNewAverageValue(String amount) {
        return this.withAverageValue(new Quantity(amount));
    }

    public A withNewAverageValue(String amount, String format) {
        return this.withAverageValue(new Quantity(amount, format));
    }

    public A withNewValue(String amount) {
        return this.withValue(new Quantity(amount));
    }

    public A withNewValue(String amount, String format) {
        return this.withValue(new Quantity(amount, format));
    }

    public A withValue(Quantity value) {
        this.value = value;
        return (A)((Object)this);
    }
}

